/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.SentenceAttribute;
import org.apache.lucene.util.AttributeSource;

public class SentenceAttributeExtractor {
    private final TokenStream input;
    private final SentenceAttribute sentenceAtt;
    private final List<AttributeSource> sentenceTokenAttrs = new ArrayList<AttributeSource>();
    private AttributeSource prevAttributeSource;
    private int currSentence = 0;
    private boolean hasNextToken = true;

    public SentenceAttributeExtractor(TokenStream input, SentenceAttribute sentenceAtt) {
        this.input = input;
        this.sentenceAtt = sentenceAtt;
    }

    public List<AttributeSource> extractSentenceAttributes() throws IOException {
        boolean hasNext;
        this.sentenceTokenAttrs.clear();
        do {
            this.hasNextToken = this.input.incrementToken();
            int currSentenceTmp = this.sentenceAtt.getSentenceIndex();
            hasNext = this.currSentence == currSentenceTmp && this.hasNextToken;
            this.currSentence = currSentenceTmp;
            if (this.prevAttributeSource != null) {
                this.sentenceTokenAttrs.add(this.prevAttributeSource);
            }
            this.prevAttributeSource = this.input.cloneAttributes();
        } while (hasNext);
        return this.sentenceTokenAttrs;
    }

    public List<AttributeSource> getSentenceAttributes() {
        return this.sentenceTokenAttrs;
    }

    public boolean allSentencesProcessed() {
        return !this.hasNextToken;
    }

    public void reset() {
        this.hasNextToken = true;
        this.sentenceTokenAttrs.clear();
        this.currSentence = 0;
        this.prevAttributeSource = null;
    }
}

