/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.comparators;

import java.io.IOException;
import java.util.ArrayDeque;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesSkipIndexType;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.AbstractDocIdSetIterator;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.SkipBlockRangeIterator;
import org.apache.lucene.search.comparators.UpdateableDocIdSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.PriorityQueue;

public class TermOrdValComparator
extends FieldComparator<BytesRef> {
    final int[] ords;
    final BytesRef[] values;
    private final BytesRefBuilder[] tempBRs;
    final int[] readerGen;
    int currentReaderGen = -1;
    private final String field;
    private final boolean reverse;
    private final boolean sortMissingLast;
    BytesRef bottomValue;
    int bottomSlot = -1;
    BytesRef topValue;
    final int missingSortCmp;
    private boolean singleSort;
    private boolean canSkipDocuments;
    private boolean hitsThresholdReached = false;

    public TermOrdValComparator(int numHits, String field, boolean sortMissingLast, boolean reverse, Pruning pruning) {
        this.canSkipDocuments = pruning != Pruning.NONE;
        this.ords = new int[numHits];
        this.values = new BytesRef[numHits];
        this.tempBRs = new BytesRefBuilder[numHits];
        this.readerGen = new int[numHits];
        this.field = field;
        this.reverse = reverse;
        this.sortMissingLast = sortMissingLast;
        this.missingSortCmp = sortMissingLast ? 1 : -1;
    }

    @Override
    public void disableSkipping() {
        this.canSkipDocuments = false;
    }

    @Override
    public void setSingleSort() {
        this.singleSort = true;
    }

    @Override
    public int compare(int slot1, int slot2) {
        if (this.readerGen[slot1] == this.readerGen[slot2]) {
            return this.ords[slot1] - this.ords[slot2];
        }
        BytesRef val1 = this.values[slot1];
        BytesRef val2 = this.values[slot2];
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return this.missingSortCmp;
        }
        if (val2 == null) {
            return -this.missingSortCmp;
        }
        return val1.compareTo(val2);
    }

    protected SortedDocValues getSortedDocValues(LeafReaderContext context, String field) throws IOException {
        return DocValues.getSorted(context.reader(), field);
    }

    @Override
    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        ++this.currentReaderGen;
        return new TermOrdValLeafComparator(context, this.getSortedDocValues(context, this.field));
    }

    @Override
    public void setTopValue(BytesRef value) {
        this.topValue = value;
    }

    @Override
    public BytesRef value(int slot) {
        return this.values[slot];
    }

    @Override
    public int compareValues(BytesRef val1, BytesRef val2) {
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return this.missingSortCmp;
        }
        if (val2 == null) {
            return -this.missingSortCmp;
        }
        return val1.compareTo(val2);
    }

    class TermOrdValLeafComparator
    implements LeafFieldComparator {
        final SortedDocValues termsIndex;
        boolean bottomSameReader;
        int bottomOrd;
        final boolean topSameReader;
        final int topOrd;
        final int missingOrd;
        private final CompetitiveState competitiveState;
        private final boolean dense;

        TermOrdValLeafComparator(LeafReaderContext context, SortedDocValues values) throws IOException {
            boolean enableSkipping;
            this.termsIndex = values;
            this.missingOrd = TermOrdValComparator.this.sortMissingLast ? Integer.MAX_VALUE : -1;
            if (TermOrdValComparator.this.topValue != null) {
                int ord = this.termsIndex.lookupTerm(TermOrdValComparator.this.topValue);
                if (ord >= 0) {
                    this.topSameReader = true;
                    this.topOrd = ord;
                } else {
                    this.topSameReader = false;
                    this.topOrd = -ord - 2;
                }
            } else {
                this.topOrd = this.missingOrd;
                this.topSameReader = true;
            }
            if (TermOrdValComparator.this.bottomSlot != -1) {
                this.setBottom(TermOrdValComparator.this.bottomSlot);
            }
            Terms terms = null;
            DocValuesSkipper skipper = null;
            if (!TermOrdValComparator.this.canSkipDocuments) {
                this.dense = false;
                enableSkipping = false;
            } else {
                FieldInfo fieldInfo = context.reader().getFieldInfos().fieldInfo(TermOrdValComparator.this.field);
                if (fieldInfo == null) {
                    if (this.termsIndex.getValueCount() != 0) {
                        throw new IllegalStateException("Field [" + TermOrdValComparator.this.field + "] cannot be found in field infos");
                    }
                    this.dense = false;
                    enableSkipping = true;
                } else if (fieldInfo.getIndexOptions() != IndexOptions.NONE) {
                    terms = context.reader().terms(TermOrdValComparator.this.field);
                    this.dense = terms != null && terms.getDocCount() == context.reader().maxDoc();
                    enableSkipping = this.shouldEnableSkipping(this.dense);
                } else if (fieldInfo.docValuesSkipIndexType() != DocValuesSkipIndexType.NONE) {
                    skipper = context.reader().getDocValuesSkipper(TermOrdValComparator.this.field);
                    this.dense = skipper != null && skipper.docCount() == context.reader().maxDoc();
                    enableSkipping = this.shouldEnableSkipping(this.dense);
                } else {
                    this.dense = false;
                    enableSkipping = false;
                }
            }
            this.competitiveState = enableSkipping ? (terms != null ? new PostingsBasedCompetitiveState(context, TermOrdValComparator.this.field, this.dense, values.termsEnum()) : (skipper != null ? new SkipperBasedCompetitiveState(context, skipper) : new EmptyCompetitiveState(context))) : null;
            this.updateCompetitiveIterator();
        }

        private boolean shouldEnableSkipping(boolean dense) {
            if (dense || TermOrdValComparator.this.topValue != null) {
                return true;
            }
            return TermOrdValComparator.this.reverse != TermOrdValComparator.this.sortMissingLast;
        }

        private int getOrdForDoc(int doc) throws IOException {
            if (this.termsIndex.advanceExact(doc)) {
                return this.termsIndex.ordValue();
            }
            return -1;
        }

        @Override
        public void setHitsThresholdReached() throws IOException {
            TermOrdValComparator.this.hitsThresholdReached = true;
            this.updateCompetitiveIterator();
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            assert (TermOrdValComparator.this.bottomSlot != -1);
            int docOrd = this.getOrdForDoc(doc);
            if (docOrd == -1) {
                docOrd = this.missingOrd;
            }
            if (this.bottomSameReader) {
                return this.bottomOrd - docOrd;
            }
            if (this.bottomOrd >= docOrd) {
                return 1;
            }
            return -1;
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            int ord = this.getOrdForDoc(doc);
            if (ord == -1) {
                ord = this.missingOrd;
                TermOrdValComparator.this.values[slot] = null;
            } else {
                assert (ord >= 0);
                if (TermOrdValComparator.this.tempBRs[slot] == null) {
                    TermOrdValComparator.this.tempBRs[slot] = new BytesRefBuilder();
                }
                TermOrdValComparator.this.tempBRs[slot].copyBytes(this.termsIndex.lookupOrd(ord));
                TermOrdValComparator.this.values[slot] = TermOrdValComparator.this.tempBRs[slot].get();
            }
            TermOrdValComparator.this.ords[slot] = ord;
            TermOrdValComparator.this.readerGen[slot] = TermOrdValComparator.this.currentReaderGen;
        }

        @Override
        public void setBottom(int bottom) throws IOException {
            TermOrdValComparator.this.bottomSlot = bottom;
            TermOrdValComparator.this.bottomValue = TermOrdValComparator.this.values[TermOrdValComparator.this.bottomSlot];
            if (TermOrdValComparator.this.currentReaderGen == TermOrdValComparator.this.readerGen[TermOrdValComparator.this.bottomSlot]) {
                this.bottomOrd = TermOrdValComparator.this.ords[TermOrdValComparator.this.bottomSlot];
                this.bottomSameReader = true;
            } else if (TermOrdValComparator.this.bottomValue == null) {
                assert (TermOrdValComparator.this.ords[TermOrdValComparator.this.bottomSlot] == this.missingOrd);
                this.bottomOrd = this.missingOrd;
                this.bottomSameReader = true;
                TermOrdValComparator.this.readerGen[TermOrdValComparator.this.bottomSlot] = TermOrdValComparator.this.currentReaderGen;
            } else {
                int ord = this.termsIndex.lookupTerm(TermOrdValComparator.this.bottomValue);
                if (ord < 0) {
                    this.bottomOrd = -ord - 2;
                    this.bottomSameReader = false;
                } else {
                    this.bottomOrd = ord;
                    this.bottomSameReader = true;
                    TermOrdValComparator.this.readerGen[TermOrdValComparator.this.bottomSlot] = TermOrdValComparator.this.currentReaderGen;
                    TermOrdValComparator.this.ords[TermOrdValComparator.this.bottomSlot] = this.bottomOrd;
                }
            }
            this.updateCompetitiveIterator();
        }

        @Override
        public int compareTop(int doc) throws IOException {
            int ord = this.getOrdForDoc(doc);
            if (ord == -1) {
                ord = this.missingOrd;
            }
            if (this.topSameReader) {
                return this.topOrd - ord;
            }
            if (ord <= this.topOrd) {
                return 1;
            }
            return -1;
        }

        @Override
        public void setScorer(Scorable scorer) {
        }

        private void updateCompetitiveIterator() throws IOException {
            int maxOrd;
            int minOrd;
            if (this.competitiveState == null || !TermOrdValComparator.this.hitsThresholdReached || TermOrdValComparator.this.bottomSlot == -1) {
                return;
            }
            if (!TermOrdValComparator.this.reverse) {
                minOrd = TermOrdValComparator.this.topValue != null ? (this.topSameReader ? this.topOrd : this.topOrd + 1) : (TermOrdValComparator.this.sortMissingLast || this.dense ? 0 : -1);
                maxOrd = this.bottomOrd == this.missingOrd ? (TermOrdValComparator.this.singleSort ? this.termsIndex.getValueCount() - 1 : Integer.MAX_VALUE) : (this.bottomSameReader ? (TermOrdValComparator.this.singleSort ? this.bottomOrd - 1 : this.bottomOrd) : this.bottomOrd);
            } else {
                minOrd = this.bottomOrd == this.missingOrd ? (TermOrdValComparator.this.singleSort ? 0 : -1) : (this.bottomSameReader ? (TermOrdValComparator.this.singleSort ? this.bottomOrd + 1 : this.bottomOrd) : this.bottomOrd + 1);
                maxOrd = TermOrdValComparator.this.topValue != null ? this.topOrd : (!TermOrdValComparator.this.sortMissingLast || this.dense ? this.termsIndex.getValueCount() - 1 : Integer.MAX_VALUE);
            }
            if (minOrd == -1 || maxOrd == Integer.MAX_VALUE) {
                return;
            }
            assert (minOrd >= 0);
            assert (maxOrd < this.termsIndex.getValueCount());
            this.competitiveState.update(minOrd, maxOrd);
        }

        @Override
        public DocIdSetIterator competitiveIterator() {
            return this.competitiveState != null ? this.competitiveState.iterator : null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isSkippingDisabled() {
            CompetitiveState competitiveState = this.competitiveState;
            if (!(competitiveState instanceof SkipperBasedCompetitiveState)) return false;
            SkipperBasedCompetitiveState skipperState = (SkipperBasedCompetitiveState)competitiveState;
            if (skipperState.state != SkipperBasedCompetitiveState.State.DISABLED) return false;
            return true;
        }
    }

    private static class SkipperBasedCompetitiveState
    extends CompetitiveState {
        private static final int WARMUP_BOUNDARY_CROSSINGS = 16;
        private final DocValuesSkipper skipper;
        private final int maxDoc;
        private int prevMinOrd = Integer.MIN_VALUE;
        private int prevMaxOrd = Integer.MIN_VALUE;
        private State state = State.WARMING;

        SkipperBasedCompetitiveState(LeafReaderContext context, DocValuesSkipper skipper) {
            super(context);
            this.skipper = skipper;
            this.maxDoc = context.reader().maxDoc();
            this.iterator.update(DocIdSetIterator.all(this.maxDoc));
        }

        @Override
        public void update(int minOrd, int maxOrd) {
            if (this.state == State.DISABLED) {
                return;
            }
            if (minOrd == this.prevMinOrd && maxOrd == this.prevMaxOrd) {
                return;
            }
            this.prevMinOrd = minOrd;
            this.prevMaxOrd = maxOrd;
            this.iterator.update(new AdaptiveSkipIterator(new SkipBlockRangeIterator(this.skipper, minOrd, maxOrd)));
        }

        private static enum State {
            WARMING,
            ACTIVE,
            DISABLED;

        }

        private class AdaptiveSkipIterator
        extends AbstractDocIdSetIterator {
            private final SkipBlockRangeIterator in;
            private int blockEndDoc = -1;
            private int boundaryCrossings;

            AdaptiveSkipIterator(SkipBlockRangeIterator in) {
                this.in = in;
            }

            @Override
            public int nextDoc() throws IOException {
                return this.advance(this.doc + 1);
            }

            @Override
            public int advance(int target) throws IOException {
                int n = switch (SkipperBasedCompetitiveState.this.state.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 2 -> target;
                    case 1 -> this.in.advance(target);
                    case 0 -> {
                        int result = this.in.advance(target);
                        if (target > this.blockEndDoc) {
                            this.blockEndDoc = SkipperBasedCompetitiveState.this.skipper.maxDocID(0);
                            ++this.boundaryCrossings;
                            if (result > target) {
                                SkipperBasedCompetitiveState.this.state = State.ACTIVE;
                            } else if (this.boundaryCrossings >= 16) {
                                SkipperBasedCompetitiveState.this.state = State.DISABLED;
                                SkipperBasedCompetitiveState.this.iterator.update(DocIdSetIterator.all(SkipperBasedCompetitiveState.this.maxDoc));
                            }
                        }
                        yield result;
                    }
                };
                this.doc = n;
                return n;
            }

            @Override
            public long cost() {
                return this.in.cost();
            }

            @Override
            public int docIDRunEnd() throws IOException {
                if (SkipperBasedCompetitiveState.this.state == State.DISABLED) {
                    return Integer.MAX_VALUE;
                }
                return this.in.docIDRunEnd();
            }

            @Override
            public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
                if (SkipperBasedCompetitiveState.this.state == State.DISABLED) {
                    bitSet.set(this.doc - offset, upTo - offset);
                    this.doc = upTo;
                    return;
                }
                this.in.intoBitSet(upTo, bitSet, offset);
                this.doc = this.in.docID();
            }
        }
    }

    private class PostingsBasedCompetitiveState
    extends CompetitiveState {
        private static final int MAX_TERMS = 1024;
        private final LeafReaderContext context;
        private final String field;
        private final boolean dense;
        private final TermsEnum docValuesTerms;
        private ArrayDeque<PostingsEnumAndOrd> postings;
        private DocIdSetIterator docsWithField;
        private PriorityQueue<PostingsEnumAndOrd> disjunction;
        private final DocIdSetIterator disjunctionIterator;

        PostingsBasedCompetitiveState(LeafReaderContext context, String field, boolean dense, TermsEnum docValuesTerms) {
            super(context);
            this.context = context;
            this.field = field;
            this.dense = dense;
            this.docValuesTerms = docValuesTerms;
            this.disjunctionIterator = new AbstractDocIdSetIterator(){

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.doc + 1);
                }

                @Override
                public int advance(int target) throws IOException {
                    PostingsEnumAndOrd top = PostingsBasedCompetitiveState.this.disjunction.top();
                    if (top == null) {
                        this.doc = Integer.MAX_VALUE;
                        return Integer.MAX_VALUE;
                    }
                    while (top.postings.docID() < target) {
                        top.postings.advance(target);
                        top = PostingsBasedCompetitiveState.this.disjunction.updateTop();
                    }
                    this.doc = top.postings.docID();
                    return this.doc;
                }

                @Override
                public long cost() {
                    long cost = 0L;
                    for (PostingsEnumAndOrd posting : PostingsBasedCompetitiveState.this.disjunction) {
                        cost += posting.postings.cost();
                    }
                    return cost;
                }
            };
        }

        @Override
        public void update(int minOrd, int maxOrd) throws IOException {
            int maxTerms = Math.min(1024, IndexSearcher.getMaxClauseCount());
            int size = Math.max(0, maxOrd - minOrd + 1);
            if (size > maxTerms) {
                if (!this.dense && this.docsWithField == null) {
                    this.docsWithField = TermOrdValComparator.this.getSortedDocValues(this.context, this.field);
                    this.iterator.update(this.docsWithField);
                }
            } else if (this.postings == null) {
                this.init(minOrd, maxOrd);
                this.iterator.update(this.disjunctionIterator);
            } else if (size < this.postings.size()) {
                assert (this.postings.isEmpty() || this.postings.getFirst().ord <= minOrd);
                while (!this.postings.isEmpty() && this.postings.getFirst().ord < minOrd) {
                    this.postings.removeFirst();
                }
                assert (this.postings.isEmpty() || this.postings.getLast().ord >= maxOrd);
                while (!this.postings.isEmpty() && this.postings.getLast().ord > maxOrd) {
                    this.postings.removeLast();
                }
                this.disjunction.clear();
                this.disjunction.addAll(this.postings);
            }
        }

        private void init(int minOrd, int maxOrd) throws IOException {
            int size = Math.max(0, maxOrd - minOrd + 1);
            this.postings = new ArrayDeque(size);
            if (size > 0) {
                this.docValuesTerms.seekExact(minOrd);
                BytesRef minTerm = this.docValuesTerms.term();
                TermsEnum terms = this.context.reader().terms(this.field).iterator();
                if (!terms.seekExact(minTerm)) {
                    throw new IllegalStateException("Term " + String.valueOf(minTerm) + " exists in doc values but not in the terms index");
                }
                this.postings.add(new PostingsEnumAndOrd(terms.postings(null, 0), minOrd));
                for (int ord = minOrd + 1; ord <= maxOrd; ++ord) {
                    BytesRef next = terms.next();
                    if (next == null) {
                        throw new IllegalStateException("Terms have more than " + ord + " unique terms while doc values have exactly " + ord + " terms");
                    }
                    assert (this.docValuesTerms.seekExact(next) && this.docValuesTerms.ord() == (long)ord);
                    this.postings.add(new PostingsEnumAndOrd(terms.postings(null, 0), ord));
                }
            }
            this.disjunction = new PriorityQueue<PostingsEnumAndOrd>(this, size){

                @Override
                protected boolean lessThan(PostingsEnumAndOrd a, PostingsEnumAndOrd b) {
                    return a.postings.docID() < b.postings.docID();
                }
            };
            this.disjunction.addAll(this.postings);
        }
    }

    private static class EmptyCompetitiveState
    extends CompetitiveState {
        EmptyCompetitiveState(LeafReaderContext context) {
            super(context);
        }

        @Override
        void update(int minOrd, int maxOrd) throws IOException {
            this.iterator.update(DocIdSetIterator.empty());
        }
    }

    private static abstract class CompetitiveState {
        final UpdateableDocIdSetIterator iterator = new UpdateableDocIdSetIterator();

        CompetitiveState(LeafReaderContext context) {
            this.iterator.update(DocIdSetIterator.all(context.reader().maxDoc()));
        }

        abstract void update(int var1, int var2) throws IOException;
    }

    private record PostingsEnumAndOrd(PostingsEnum postings, int ord) {
    }
}

