/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.io;

import java.io.File;
import java.io.IOException;
import opennlp.tools.ml.maxent.io.GISModelReader;
import opennlp.tools.ml.maxent.quasinewton.QNModel;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.DataReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QNModelReader
extends GISModelReader {
    private static final Logger logger = LoggerFactory.getLogger(QNModelReader.class);

    public QNModelReader(DataReader dataReader) {
        super(dataReader);
    }

    public QNModelReader(File file) throws IOException {
        super(file);
    }

    @Override
    public void checkModelType() throws IOException {
        String modelType = this.readUTF();
        if (!modelType.equals("QN")) {
            logger.error("Attempting to load a {} model as a MAXENT_QN model. You should expect problems.", (Object)modelType);
        }
    }

    @Override
    public QNModel constructModel() throws IOException {
        String[] outcomeLabels = this.getOutcomes();
        int[][] outcomePatterns = this.getOutcomePatterns();
        String[] predLabels = this.getPredicates();
        Context[] params = this.getParameters(outcomePatterns);
        return new QNModel(params, predLabels, outcomeLabels);
    }
}

