/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene103;

import java.io.IOException;
import org.apache.lucene.backward_codecs.lucene103.PostingDecodingUtil;
import org.apache.lucene.store.DataOutput;

public final class ForUtil {
    public static final int BLOCK_SIZE = 128;
    static final int BLOCK_SIZE_LOG2 = 7;
    private final int[] tmp = new int[128];
    static final int[] MASKS8;
    static final int[] MASKS16;
    static final int[] MASKS32;
    static final int MASK8_1;
    static final int MASK8_2;
    static final int MASK8_3;
    static final int MASK8_4;
    static final int MASK8_5;
    static final int MASK8_6;
    static final int MASK8_7;
    static final int MASK16_1;
    static final int MASK16_2;
    static final int MASK16_3;
    static final int MASK16_4;
    static final int MASK16_5;
    static final int MASK16_6;
    static final int MASK16_7;
    static final int MASK16_8;
    static final int MASK16_9;
    static final int MASK16_10;
    static final int MASK16_11;
    static final int MASK16_12;
    static final int MASK16_13;
    static final int MASK16_14;
    static final int MASK16_15;
    static final int MASK32_1;
    static final int MASK32_2;
    static final int MASK32_3;
    static final int MASK32_4;
    static final int MASK32_5;
    static final int MASK32_6;
    static final int MASK32_7;
    static final int MASK32_8;
    static final int MASK32_9;
    static final int MASK32_10;
    static final int MASK32_11;
    static final int MASK32_12;
    static final int MASK32_13;
    static final int MASK32_14;
    static final int MASK32_15;
    static final int MASK32_16;

    static int expandMask16(int mask16) {
        return mask16 | mask16 << 16;
    }

    static int expandMask8(int mask8) {
        return ForUtil.expandMask16(mask8 | mask8 << 8);
    }

    static int mask32(int bitsPerValue) {
        return (1 << bitsPerValue) - 1;
    }

    static int mask16(int bitsPerValue) {
        return ForUtil.expandMask16((1 << bitsPerValue) - 1);
    }

    static int mask8(int bitsPerValue) {
        return ForUtil.expandMask8((1 << bitsPerValue) - 1);
    }

    static void expand8(int[] arr) {
        for (int i = 0; i < 32; ++i) {
            int l = arr[i];
            arr[i] = l >>> 24 & 0xFF;
            arr[32 + i] = l >>> 16 & 0xFF;
            arr[64 + i] = l >>> 8 & 0xFF;
            arr[96 + i] = l & 0xFF;
        }
    }

    static void collapse8(int[] arr) {
        for (int i = 0; i < 32; ++i) {
            arr[i] = arr[i] << 24 | arr[32 + i] << 16 | arr[64 + i] << 8 | arr[96 + i];
        }
    }

    static void expand16(int[] arr) {
        for (int i = 0; i < 64; ++i) {
            int l = arr[i];
            arr[i] = l >>> 16 & 0xFFFF;
            arr[64 + i] = l & 0xFFFF;
        }
    }

    static void collapse16(int[] arr) {
        for (int i = 0; i < 64; ++i) {
            arr[i] = arr[i] << 16 | arr[64 + i];
        }
    }

    void encode(int[] ints, int bitsPerValue, DataOutput out) throws IOException {
        int nextPrimitive;
        if (bitsPerValue <= 8) {
            nextPrimitive = 8;
            ForUtil.collapse8(ints);
        } else if (bitsPerValue <= 16) {
            nextPrimitive = 16;
            ForUtil.collapse16(ints);
        } else {
            nextPrimitive = 32;
        }
        ForUtil.encode(ints, bitsPerValue, nextPrimitive, out, this.tmp);
    }

    static void encode(int[] ints, int bitsPerValue, int primitiveSize, DataOutput out, int[] tmp) throws IOException {
        int i;
        int numInts = 128 * primitiveSize / 32;
        int numIntsPerShift = bitsPerValue * 4;
        int idx = 0;
        int shift = primitiveSize - bitsPerValue;
        for (i = 0; i < numIntsPerShift; ++i) {
            tmp[i] = ints[idx++] << shift;
        }
        shift -= bitsPerValue;
        while (shift >= 0) {
            i = 0;
            while (i < numIntsPerShift) {
                int n = i++;
                tmp[n] = tmp[n] | ints[idx++] << shift;
            }
            shift -= bitsPerValue;
        }
        int remainingBitsPerInt = shift + bitsPerValue;
        int maskRemainingBitsPerInt = primitiveSize == 8 ? MASKS8[remainingBitsPerInt] : (primitiveSize == 16 ? MASKS16[remainingBitsPerInt] : MASKS32[remainingBitsPerInt]);
        int tmpIdx = 0;
        int remainingBitsPerValue = bitsPerValue;
        while (idx < numInts) {
            int mask2;
            int mask1;
            if (remainingBitsPerValue >= remainingBitsPerInt) {
                int n = tmpIdx++;
                tmp[n] = tmp[n] | ints[idx] >>> (remainingBitsPerValue -= remainingBitsPerInt) & maskRemainingBitsPerInt;
                if (remainingBitsPerValue != 0) continue;
                ++idx;
                remainingBitsPerValue = bitsPerValue;
                continue;
            }
            if (primitiveSize == 8) {
                mask1 = MASKS8[remainingBitsPerValue];
                mask2 = MASKS8[remainingBitsPerInt - remainingBitsPerValue];
            } else if (primitiveSize == 16) {
                mask1 = MASKS16[remainingBitsPerValue];
                mask2 = MASKS16[remainingBitsPerInt - remainingBitsPerValue];
            } else {
                mask1 = MASKS32[remainingBitsPerValue];
                mask2 = MASKS32[remainingBitsPerInt - remainingBitsPerValue];
            }
            int n = tmpIdx;
            tmp[n] = tmp[n] | (ints[idx++] & mask1) << remainingBitsPerInt - remainingBitsPerValue;
            remainingBitsPerValue = bitsPerValue - remainingBitsPerInt + remainingBitsPerValue;
            int n2 = tmpIdx++;
            tmp[n2] = tmp[n2] | ints[idx] >>> remainingBitsPerValue & mask2;
        }
        for (int i2 = 0; i2 < numIntsPerShift; ++i2) {
            out.writeInt(tmp[i2]);
        }
    }

    static int numBytes(int bitsPerValue) {
        return bitsPerValue << 4;
    }

    static void decodeSlow(int bitsPerValue, PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        int numInts = bitsPerValue << 2;
        int mask = MASKS32[bitsPerValue];
        pdu.splitInts(numInts, ints, 32 - bitsPerValue, 32, mask, tmp, 0, -1);
        int remainingBitsPerInt = 32 - bitsPerValue;
        int mask32RemainingBitsPerInt = MASKS32[remainingBitsPerInt];
        int tmpIdx = 0;
        int remainingBits = remainingBitsPerInt;
        for (int intsIdx = numInts; intsIdx < 128; ++intsIdx) {
            int b = bitsPerValue - remainingBits;
            int l = (tmp[tmpIdx++] & MASKS32[remainingBits]) << b;
            while (b >= remainingBitsPerInt) {
                l |= (tmp[tmpIdx++] & mask32RemainingBitsPerInt) << (b -= remainingBitsPerInt);
            }
            if (b > 0) {
                l |= tmp[tmpIdx] >>> remainingBitsPerInt - b & MASKS32[b];
                remainingBits = remainingBitsPerInt - b;
            } else {
                remainingBits = remainingBitsPerInt;
            }
            ints[intsIdx] = l;
        }
    }

    void decode(int bitsPerValue, PostingDecodingUtil pdu, int[] ints) throws IOException {
        switch (bitsPerValue) {
            case 1: {
                ForUtil.decode1(pdu, ints);
                ForUtil.expand8(ints);
                break;
            }
            case 2: {
                ForUtil.decode2(pdu, ints);
                ForUtil.expand8(ints);
                break;
            }
            case 3: {
                ForUtil.decode3(pdu, this.tmp, ints);
                ForUtil.expand8(ints);
                break;
            }
            case 4: {
                ForUtil.decode4(pdu, ints);
                ForUtil.expand8(ints);
                break;
            }
            case 5: {
                ForUtil.decode5(pdu, this.tmp, ints);
                ForUtil.expand8(ints);
                break;
            }
            case 6: {
                ForUtil.decode6(pdu, this.tmp, ints);
                ForUtil.expand8(ints);
                break;
            }
            case 7: {
                ForUtil.decode7(pdu, this.tmp, ints);
                ForUtil.expand8(ints);
                break;
            }
            case 8: {
                ForUtil.decode8(pdu, ints);
                ForUtil.expand8(ints);
                break;
            }
            case 9: {
                ForUtil.decode9(pdu, this.tmp, ints);
                ForUtil.expand16(ints);
                break;
            }
            case 10: {
                ForUtil.decode10(pdu, this.tmp, ints);
                ForUtil.expand16(ints);
                break;
            }
            case 11: {
                ForUtil.decode11(pdu, this.tmp, ints);
                ForUtil.expand16(ints);
                break;
            }
            case 12: {
                ForUtil.decode12(pdu, this.tmp, ints);
                ForUtil.expand16(ints);
                break;
            }
            case 13: {
                ForUtil.decode13(pdu, this.tmp, ints);
                ForUtil.expand16(ints);
                break;
            }
            case 14: {
                ForUtil.decode14(pdu, this.tmp, ints);
                ForUtil.expand16(ints);
                break;
            }
            case 15: {
                ForUtil.decode15(pdu, this.tmp, ints);
                ForUtil.expand16(ints);
                break;
            }
            case 16: {
                ForUtil.decode16(pdu, ints);
                ForUtil.expand16(ints);
                break;
            }
            default: {
                ForUtil.decodeSlow(bitsPerValue, pdu, this.tmp, ints);
            }
        }
    }

    static void decode1(PostingDecodingUtil pdu, int[] ints) throws IOException {
        pdu.splitInts(4, ints, 7, 1, MASK8_1, ints, 28, MASK8_1);
    }

    static void decode2(PostingDecodingUtil pdu, int[] ints) throws IOException {
        pdu.splitInts(8, ints, 6, 2, MASK8_2, ints, 24, MASK8_2);
    }

    static void decode3(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(12, ints, 5, 3, MASK8_3, tmp, 0, MASK8_2);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 24;
        while (iter < 4) {
            int l0 = tmp[tmpIdx + 0] << 1;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 1 & MASK8_1;
            int l1 = (tmp[tmpIdx + 1] & MASK8_1) << 2;
            ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            intsIdx += 2;
        }
    }

    static void decode4(PostingDecodingUtil pdu, int[] ints) throws IOException {
        pdu.splitInts(16, ints, 4, 4, MASK8_4, ints, 16, MASK8_4);
    }

    static void decode5(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(20, ints, 3, 5, MASK8_5, tmp, 0, MASK8_3);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 20;
        while (iter < 4) {
            int l0 = tmp[tmpIdx + 0] << 2;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 1 & MASK8_2;
            int l1 = (tmp[tmpIdx + 1] & MASK8_1) << 4;
            l1 |= tmp[tmpIdx + 2] << 1;
            ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 3] >>> 2 & MASK8_1;
            int l2 = (tmp[tmpIdx + 3] & MASK8_2) << 3;
            ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 4] << 0;
            ++iter;
            tmpIdx += 5;
            intsIdx += 3;
        }
    }

    static void decode6(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(24, ints, 2, 6, MASK8_6, tmp, 0, MASK8_2);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 24;
        while (iter < 8) {
            int l0 = tmp[tmpIdx + 0] << 4;
            l0 |= tmp[tmpIdx + 1] << 2;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            ++intsIdx;
        }
    }

    static void decode7(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(28, ints, 1, 7, MASK8_7, tmp, 0, MASK8_1);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 28;
        while (iter < 4) {
            int l0 = tmp[tmpIdx + 0] << 6;
            l0 |= tmp[tmpIdx + 1] << 5;
            l0 |= tmp[tmpIdx + 2] << 4;
            l0 |= tmp[tmpIdx + 3] << 3;
            l0 |= tmp[tmpIdx + 4] << 2;
            l0 |= tmp[tmpIdx + 5] << 1;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 6] << 0;
            ++iter;
            tmpIdx += 7;
            ++intsIdx;
        }
    }

    static void decode8(PostingDecodingUtil pdu, int[] ints) throws IOException {
        pdu.in.readInts(ints, 0, 32);
    }

    static void decode9(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(36, ints, 7, 9, MASK16_9, tmp, 0, MASK16_7);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 36;
        while (iter < 4) {
            int l0 = tmp[tmpIdx + 0] << 2;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 5 & MASK16_2;
            int l1 = (tmp[tmpIdx + 1] & MASK16_5) << 4;
            ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 2] >>> 3 & MASK16_4;
            int l2 = (tmp[tmpIdx + 2] & MASK16_3) << 6;
            ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 3] >>> 1 & MASK16_6;
            int l3 = (tmp[tmpIdx + 3] & MASK16_1) << 8;
            l3 |= tmp[tmpIdx + 4] << 1;
            ints[intsIdx + 3] = l3 |= tmp[tmpIdx + 5] >>> 6 & MASK16_1;
            int l4 = (tmp[tmpIdx + 5] & MASK16_6) << 3;
            ints[intsIdx + 4] = l4 |= tmp[tmpIdx + 6] >>> 4 & MASK16_3;
            int l5 = (tmp[tmpIdx + 6] & MASK16_4) << 5;
            ints[intsIdx + 5] = l5 |= tmp[tmpIdx + 7] >>> 2 & MASK16_5;
            int l6 = (tmp[tmpIdx + 7] & MASK16_2) << 7;
            ints[intsIdx + 6] = l6 |= tmp[tmpIdx + 8] << 0;
            ++iter;
            tmpIdx += 9;
            intsIdx += 7;
        }
    }

    static void decode10(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(40, ints, 6, 10, MASK16_10, tmp, 0, MASK16_6);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 40;
        while (iter < 8) {
            int l0 = tmp[tmpIdx + 0] << 4;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 2 & MASK16_4;
            int l1 = (tmp[tmpIdx + 1] & MASK16_2) << 8;
            l1 |= tmp[tmpIdx + 2] << 2;
            ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 3] >>> 4 & MASK16_2;
            int l2 = (tmp[tmpIdx + 3] & MASK16_4) << 6;
            ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 4] << 0;
            ++iter;
            tmpIdx += 5;
            intsIdx += 3;
        }
    }

    static void decode11(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(44, ints, 5, 11, MASK16_11, tmp, 0, MASK16_5);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 44;
        while (iter < 4) {
            int l0 = tmp[tmpIdx + 0] << 6;
            l0 |= tmp[tmpIdx + 1] << 1;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 2] >>> 4 & MASK16_1;
            int l1 = (tmp[tmpIdx + 2] & MASK16_4) << 7;
            l1 |= tmp[tmpIdx + 3] << 2;
            ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 4] >>> 3 & MASK16_2;
            int l2 = (tmp[tmpIdx + 4] & MASK16_3) << 8;
            l2 |= tmp[tmpIdx + 5] << 3;
            ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 6] >>> 2 & MASK16_3;
            int l3 = (tmp[tmpIdx + 6] & MASK16_2) << 9;
            l3 |= tmp[tmpIdx + 7] << 4;
            ints[intsIdx + 3] = l3 |= tmp[tmpIdx + 8] >>> 1 & MASK16_4;
            int l4 = (tmp[tmpIdx + 8] & MASK16_1) << 10;
            l4 |= tmp[tmpIdx + 9] << 5;
            ints[intsIdx + 4] = l4 |= tmp[tmpIdx + 10] << 0;
            ++iter;
            tmpIdx += 11;
            intsIdx += 5;
        }
    }

    static void decode12(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(48, ints, 4, 12, MASK16_12, tmp, 0, MASK16_4);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 48;
        while (iter < 16) {
            int l0 = tmp[tmpIdx + 0] << 8;
            l0 |= tmp[tmpIdx + 1] << 4;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 2] << 0;
            ++iter;
            tmpIdx += 3;
            ++intsIdx;
        }
    }

    static void decode13(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(52, ints, 3, 13, MASK16_13, tmp, 0, MASK16_3);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 52;
        while (iter < 4) {
            int l0 = tmp[tmpIdx + 0] << 10;
            l0 |= tmp[tmpIdx + 1] << 7;
            l0 |= tmp[tmpIdx + 2] << 4;
            l0 |= tmp[tmpIdx + 3] << 1;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 4] >>> 2 & MASK16_1;
            int l1 = (tmp[tmpIdx + 4] & MASK16_2) << 11;
            l1 |= tmp[tmpIdx + 5] << 8;
            l1 |= tmp[tmpIdx + 6] << 5;
            l1 |= tmp[tmpIdx + 7] << 2;
            ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 8] >>> 1 & MASK16_2;
            int l2 = (tmp[tmpIdx + 8] & MASK16_1) << 12;
            l2 |= tmp[tmpIdx + 9] << 9;
            l2 |= tmp[tmpIdx + 10] << 6;
            l2 |= tmp[tmpIdx + 11] << 3;
            ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 12] << 0;
            ++iter;
            tmpIdx += 13;
            intsIdx += 3;
        }
    }

    static void decode14(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(56, ints, 2, 14, MASK16_14, tmp, 0, MASK16_2);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 56;
        while (iter < 8) {
            int l0 = tmp[tmpIdx + 0] << 12;
            l0 |= tmp[tmpIdx + 1] << 10;
            l0 |= tmp[tmpIdx + 2] << 8;
            l0 |= tmp[tmpIdx + 3] << 6;
            l0 |= tmp[tmpIdx + 4] << 4;
            l0 |= tmp[tmpIdx + 5] << 2;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 6] << 0;
            ++iter;
            tmpIdx += 7;
            ++intsIdx;
        }
    }

    static void decode15(PostingDecodingUtil pdu, int[] tmp, int[] ints) throws IOException {
        pdu.splitInts(60, ints, 1, 15, MASK16_15, tmp, 0, MASK16_1);
        int iter = 0;
        int tmpIdx = 0;
        int intsIdx = 60;
        while (iter < 4) {
            int l0 = tmp[tmpIdx + 0] << 14;
            l0 |= tmp[tmpIdx + 1] << 13;
            l0 |= tmp[tmpIdx + 2] << 12;
            l0 |= tmp[tmpIdx + 3] << 11;
            l0 |= tmp[tmpIdx + 4] << 10;
            l0 |= tmp[tmpIdx + 5] << 9;
            l0 |= tmp[tmpIdx + 6] << 8;
            l0 |= tmp[tmpIdx + 7] << 7;
            l0 |= tmp[tmpIdx + 8] << 6;
            l0 |= tmp[tmpIdx + 9] << 5;
            l0 |= tmp[tmpIdx + 10] << 4;
            l0 |= tmp[tmpIdx + 11] << 3;
            l0 |= tmp[tmpIdx + 12] << 2;
            l0 |= tmp[tmpIdx + 13] << 1;
            ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 14] << 0;
            ++iter;
            tmpIdx += 15;
            ++intsIdx;
        }
    }

    static void decode16(PostingDecodingUtil pdu, int[] ints) throws IOException {
        pdu.in.readInts(ints, 0, 64);
    }

    static {
        int i;
        MASKS8 = new int[8];
        MASKS16 = new int[16];
        MASKS32 = new int[32];
        for (i = 0; i < 8; ++i) {
            ForUtil.MASKS8[i] = ForUtil.mask8(i);
        }
        for (i = 0; i < 16; ++i) {
            ForUtil.MASKS16[i] = ForUtil.mask16(i);
        }
        for (i = 0; i < 32; ++i) {
            ForUtil.MASKS32[i] = ForUtil.mask32(i);
        }
        MASK8_1 = MASKS8[1];
        MASK8_2 = MASKS8[2];
        MASK8_3 = MASKS8[3];
        MASK8_4 = MASKS8[4];
        MASK8_5 = MASKS8[5];
        MASK8_6 = MASKS8[6];
        MASK8_7 = MASKS8[7];
        MASK16_1 = MASKS16[1];
        MASK16_2 = MASKS16[2];
        MASK16_3 = MASKS16[3];
        MASK16_4 = MASKS16[4];
        MASK16_5 = MASKS16[5];
        MASK16_6 = MASKS16[6];
        MASK16_7 = MASKS16[7];
        MASK16_8 = MASKS16[8];
        MASK16_9 = MASKS16[9];
        MASK16_10 = MASKS16[10];
        MASK16_11 = MASKS16[11];
        MASK16_12 = MASKS16[12];
        MASK16_13 = MASKS16[13];
        MASK16_14 = MASKS16[14];
        MASK16_15 = MASKS16[15];
        MASK32_1 = MASKS32[1];
        MASK32_2 = MASKS32[2];
        MASK32_3 = MASKS32[3];
        MASK32_4 = MASKS32[4];
        MASK32_5 = MASKS32[5];
        MASK32_6 = MASKS32[6];
        MASK32_7 = MASKS32[7];
        MASK32_8 = MASKS32[8];
        MASK32_9 = MASKS32[9];
        MASK32_10 = MASKS32[10];
        MASK32_11 = MASKS32[11];
        MASK32_12 = MASKS32[12];
        MASK32_13 = MASKS32[13];
        MASK32_14 = MASKS32[14];
        MASK32_15 = MASKS32[15];
        MASK32_16 = MASKS32[16];
    }
}

