/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.ConfigUtils;

public final class ChainedLocalRepositoryManager
implements LocalRepositoryManager {
    private static final String CONFIG_PROPS_PREFIX = "aether.chainedLocalRepository.";
    public static final String CONFIG_PROP_IGNORE_TAIL_AVAILABILITY = "aether.chainedLocalRepository.ignoreTailAvailability";
    public static final boolean DEFAULT_IGNORE_TAIL_AVAILABILITY = true;
    private final LocalRepositoryManager head;
    private final List<LocalRepositoryManager> tail;
    private final boolean ignoreTailAvailability;
    private final int installTarget;
    private final int cacheTarget;

    public ChainedLocalRepositoryManager(LocalRepositoryManager head, List<LocalRepositoryManager> tail, boolean ignoreTailAvailability) {
        this(head, tail, ignoreTailAvailability, 0, 0);
    }

    public ChainedLocalRepositoryManager(LocalRepositoryManager head, List<LocalRepositoryManager> tail, RepositorySystemSession session) {
        this(head, tail, ConfigUtils.getBoolean(session, true, CONFIG_PROP_IGNORE_TAIL_AVAILABILITY), 0, 0);
    }

    public ChainedLocalRepositoryManager(LocalRepositoryManager head, List<LocalRepositoryManager> tail, boolean ignoreTailAvailability, int installTarget, int cacheTarget) {
        this.head = Objects.requireNonNull(head, "head cannot be null");
        this.tail = Objects.requireNonNull(tail, "tail cannot be null");
        this.ignoreTailAvailability = ignoreTailAvailability;
        if (installTarget < 0 || installTarget > tail.size()) {
            throw new IllegalArgumentException("Illegal installTarget value");
        }
        this.installTarget = installTarget;
        if (cacheTarget < 0 || cacheTarget > tail.size()) {
            throw new IllegalArgumentException("Illegal cacheTarget value");
        }
        this.cacheTarget = cacheTarget;
    }

    public LocalRepository getRepository() {
        return this.head.getRepository();
    }

    private LocalRepositoryManager getInstallTarget() {
        if (this.installTarget == 0) {
            return this.head;
        }
        return this.tail.get(this.installTarget - 1);
    }

    private LocalRepositoryManager getCacheTarget() {
        if (this.cacheTarget == 0) {
            return this.head;
        }
        return this.tail.get(this.cacheTarget - 1);
    }

    public Path getAbsolutePathForLocalArtifact(Artifact artifact) {
        return this.getInstallTarget().getAbsolutePathForLocalArtifact(artifact);
    }

    public Path getAbsolutePathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.getCacheTarget().getAbsolutePathForRemoteArtifact(artifact, repository, context);
    }

    public Path getAbsolutePathForLocalMetadata(Metadata metadata) {
        return this.getInstallTarget().getAbsolutePathForLocalMetadata(metadata);
    }

    public Path getAbsolutePathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.getCacheTarget().getAbsolutePathForRemoteMetadata(metadata, repository, context);
    }

    public String getPathForLocalArtifact(Artifact artifact) {
        return this.getInstallTarget().getPathForLocalArtifact(artifact);
    }

    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.getCacheTarget().getPathForRemoteArtifact(artifact, repository, context);
    }

    public String getPathForLocalMetadata(Metadata metadata) {
        return this.getInstallTarget().getPathForLocalMetadata(metadata);
    }

    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.getCacheTarget().getPathForRemoteMetadata(metadata, repository, context);
    }

    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        LocalArtifactResult result = this.head.find(session, request);
        if (result.isAvailable()) {
            return result;
        }
        for (LocalRepositoryManager lrm : this.tail) {
            result = lrm.find(session, request);
            if (result.getPath() == null) continue;
            if (this.ignoreTailAvailability) {
                result.setAvailable(true);
                return result;
            }
            if (!result.isAvailable()) continue;
            return result;
        }
        return new LocalArtifactResult(request);
    }

    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        LocalRepositoryManager target;
        String artifactPath;
        if (request.getRepository() != null) {
            artifactPath = this.getPathForRemoteArtifact(request.getArtifact(), request.getRepository(), "check");
            target = this.getCacheTarget();
        } else {
            artifactPath = this.getPathForLocalArtifact(request.getArtifact());
            target = this.getInstallTarget();
        }
        Path file = target.getRepository().getBasePath().resolve(artifactPath);
        if (Files.isRegularFile(file, new LinkOption[0])) {
            target.add(session, request);
        }
    }

    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        LocalMetadataResult result = this.head.find(session, request);
        if (result.getPath() != null) {
            return result;
        }
        for (LocalRepositoryManager lrm : this.tail) {
            result = lrm.find(session, request);
            if (result.getPath() == null) continue;
            return result;
        }
        return new LocalMetadataResult(request);
    }

    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
        LocalRepositoryManager target;
        String metadataPath;
        if (request.getRepository() != null) {
            metadataPath = this.getPathForRemoteMetadata(request.getMetadata(), request.getRepository(), "check");
            target = this.getCacheTarget();
        } else {
            metadataPath = this.getPathForLocalMetadata(request.getMetadata());
            target = this.getInstallTarget();
        }
        Path file = target.getRepository().getBasePath().resolve(metadataPath);
        if (Files.isRegularFile(file, new LinkOption[0])) {
            target.add(session, request);
        }
    }

    public String toString() {
        return this.head.getRepository().toString() + this.tail.stream().map(LocalRepositoryManager::getRepository).collect(Collectors.toList());
    }
}

