/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.named.support;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.aether.named.NamedLock;
import org.eclipse.aether.named.NamedLockKey;
import org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.eclipse.aether.named.support.NamedLockSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeNamedLock
extends NamedLockSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeNamedLock.class);
    private final Map<NamedLockKey, NamedLock> locks;
    private final ArrayDeque<ArrayDeque<NamedLock>> steps = new ArrayDeque();

    public CompositeNamedLock(NamedLockKey key, NamedLockFactorySupport factory, Collection<NamedLock> namedLocks) {
        super(key, factory);
        LinkedHashMap map = new LinkedHashMap();
        namedLocks.forEach(l -> map.put(l.key(), l));
        this.locks = Collections.unmodifiableMap(map);
    }

    @Override
    protected boolean doLockShared(long time, TimeUnit unit) throws InterruptedException {
        return this.lock(time, unit, true);
    }

    @Override
    protected boolean doLockExclusively(long time, TimeUnit unit) throws InterruptedException {
        return this.lock(time, unit, false);
    }

    private boolean lock(long time, TimeUnit timeUnit, boolean shared) throws InterruptedException {
        ArrayDeque<NamedLock> step = new ArrayDeque<NamedLock>(this.locks.size());
        String timeStr = time + " " + (Object)((Object)timeUnit);
        String lockKind = shared ? "shared" : "exclusive";
        LOGGER.trace("{}: Need {} {} lock(s) of {} in {}", new Object[]{this.key().name(), this.locks.size(), lockKind, this.key().resources(), timeStr});
        for (NamedLock namedLock : this.locks.values()) {
            LOGGER.trace("{}: Acquiring {} lock for '{}'", new Object[]{this.key().name(), lockKind, namedLock.key()});
            boolean locked = shared ? namedLock.lockShared(time, timeUnit) : namedLock.lockExclusively(time, timeUnit);
            if (!locked) {
                LOGGER.trace("{}: Failed to acquire {} lock for '{}' in {}", new Object[]{this.key().name(), lockKind, namedLock.key(), timeStr});
                this.unlockAll(step);
                break;
            }
            step.push(namedLock);
        }
        if (step.size() == this.locks.size()) {
            this.steps.push(step);
            return true;
        }
        this.unlockAll(step);
        return false;
    }

    @Override
    protected void doUnlock() {
        this.unlockAll(this.steps.pop());
    }

    @Override
    protected void doClose() {
        this.locks.values().forEach(NamedLock::close);
    }

    private void unlockAll(ArrayDeque<NamedLock> locks) {
        if (locks.isEmpty()) {
            return;
        }
        while (!locks.isEmpty()) {
            NamedLock namedLock = locks.pop();
            LOGGER.trace("{}: Releasing lock for '{}'", (Object)this.key().name(), (Object)namedLock.key());
            namedLock.unlock();
        }
    }
}

