/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.context;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.myfaces.tobago.context.ThemeScript;
import org.apache.myfaces.tobago.context.ThemeStyle;
import org.apache.myfaces.tobago.exception.TobagoConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThemeResources
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Deprecated(since="5.0.0", forRemoval=true)
    private boolean production;
    private final List<ThemeScript> includeScripts = new ArrayList<ThemeScript>();
    private final List<ThemeScript> excludeScripts = new ArrayList<ThemeScript>();
    private final List<ThemeStyle> includeStyles = new ArrayList<ThemeStyle>();
    private final List<ThemeStyle> excludeStyles = new ArrayList<ThemeStyle>();

    public ThemeResources() {
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public ThemeResources(boolean production) {
        this.production = production;
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public void merge(ThemeResources fallback) {
        int i;
        if (this == fallback) {
            return;
        }
        for (i = fallback.includeScripts.size() - 1; i >= 0; --i) {
            ThemeScript script = fallback.includeScripts.get(i);
            this.includeScripts.remove(script);
            if (this.excludeScripts.contains(script)) continue;
            this.includeScripts.add(0, script);
        }
        for (i = fallback.includeStyles.size() - 1; i >= 0; --i) {
            ThemeStyle style = fallback.includeStyles.get(i);
            this.includeStyles.remove(style);
            if (this.excludeStyles.contains(style)) continue;
            this.includeStyles.add(0, style);
        }
    }

    public static ThemeResources merge(ThemeResources base, ThemeResources add) {
        if (base.production != add.production) {
            throw new TobagoConfigurationException("Resources mismatch!");
        }
        ThemeResources result = new ThemeResources(base.production);
        for (ThemeScript includeScript : base.includeScripts) {
            if (add.excludeScripts.contains(includeScript)) continue;
            result.addIncludeScript(includeScript);
        }
        for (ThemeScript includeScript : add.includeScripts) {
            result.addIncludeScript(includeScript);
        }
        for (ThemeStyle includeStyle : base.includeStyles) {
            if (add.excludeStyles.contains(includeStyle)) continue;
            result.addIncludeStyle(includeStyle);
        }
        for (ThemeStyle includeStyle : add.includeStyles) {
            result.addIncludeStyle(includeStyle);
        }
        return result;
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public boolean isProduction() {
        return this.production;
    }

    public boolean addIncludeScript(ThemeScript script) {
        for (ThemeScript resource : this.includeScripts) {
            if (!resource.getName().equals(script.getName())) continue;
            LOG.warn("Overwriting include script '{}'", (Object)script.getName());
            this.includeScripts.remove(resource);
            break;
        }
        return this.includeScripts.add(script);
    }

    public boolean addExcludeScript(ThemeScript script) {
        for (ThemeScript resource : this.excludeScripts) {
            if (!resource.getName().equals(script.getName())) continue;
            LOG.warn("Overwriting exclude script '{}'", (Object)script.getName());
            this.includeScripts.remove(resource);
            break;
        }
        return this.excludeScripts.add(script);
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public boolean addScript(ThemeScript script, boolean exclude) {
        return exclude ? this.addExcludeScript(script) : this.addIncludeScript(script);
    }

    public boolean addIncludeStyle(ThemeStyle style) {
        for (ThemeStyle resource : this.includeStyles) {
            if (!resource.getName().equals(style.getName())) continue;
            LOG.warn("Overwriting include style '{}'", (Object)style.getName());
            this.includeStyles.remove(resource);
            break;
        }
        return this.includeStyles.add(style);
    }

    public boolean addExcludeStyle(ThemeStyle style) {
        for (ThemeStyle resource : this.excludeStyles) {
            if (!resource.getName().equals(style.getName())) continue;
            LOG.warn("Overwriting exclude style '{}'", (Object)style.getName());
            this.includeStyles.remove(resource);
            break;
        }
        return this.excludeStyles.add(style);
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    public boolean addStyle(ThemeStyle style, boolean exclude) {
        return exclude ? this.addExcludeStyle(style) : this.addIncludeStyle(style);
    }

    public List<ThemeScript> getScriptList() {
        return this.includeScripts;
    }

    public List<ThemeStyle> getStyleList() {
        return this.includeStyles;
    }
}

