/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.xml.processing.transform;

import java.util.Objects;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.apache.nifi.xml.processing.ProcessingAttribute;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.transform.TransformProvider;

public class StandardTransformProvider
implements TransformProvider {
    private static final boolean SECURE_PROCESSING_ENABLED = true;
    private static final String ENABLED_PROPERTY = "yes";
    private static final String INDENT_AMOUNT_OUTPUT_KEY = "{http://xml.apache.org/xslt}indent-amount";
    private static final String INDENT_AMOUNT = "2";
    private boolean indent;
    private boolean omitXmlDeclaration;
    private String method;

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setOmitXmlDeclaration(boolean omitXmlDeclaration) {
        this.omitXmlDeclaration = omitXmlDeclaration;
    }

    @Override
    public void transform(Source source, Result result) {
        Transformer transformer;
        Objects.requireNonNull(source, "Source required");
        Objects.requireNonNull(result, "Result required");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", ProcessingAttribute.ACCESS_EXTERNAL_DTD.getValue());
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", ProcessingAttribute.ACCESS_EXTERNAL_STYLESHEET.getValue());
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new ProcessingException("Transformer configuration failed", e);
        }
        if (this.indent) {
            transformer.setOutputProperty("indent", ENABLED_PROPERTY);
            transformer.setOutputProperty(INDENT_AMOUNT_OUTPUT_KEY, INDENT_AMOUNT);
        }
        if (this.method != null) {
            transformer.setOutputProperty("method", this.method);
        }
        if (this.omitXmlDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", ENABLED_PROPERTY);
        }
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new ProcessingException("Transform failed", e);
        }
    }
}

