/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class ThreadDetails {
    private final ThreadInfo[] threadInfos;
    private final long[] deadlockedThreadIds;
    private final long[] monitorDeadlockThreadIds;

    private ThreadDetails(ThreadMXBean mbean) {
        this.threadInfos = mbean.dumpAllThreads(true, true);
        this.deadlockedThreadIds = mbean.findDeadlockedThreads();
        this.monitorDeadlockThreadIds = mbean.findMonitorDeadlockedThreads();
    }

    public ThreadInfo[] getThreadInfos() {
        return this.threadInfos;
    }

    public long[] getDeadlockedThreadIds() {
        return this.deadlockedThreadIds;
    }

    public long[] getMonitorDeadlockThreadIds() {
        return this.monitorDeadlockThreadIds;
    }

    public static ThreadDetails capture() {
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        return new ThreadDetails(mbean);
    }
}

