/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.sts.model.AssumeRoleWithWebIdentityRequest;
import software.amazon.awssdk.utils.IoUtils;

@SdkInternalApi
public class AssumeRoleWithWebIdentityRequestSupplier
implements Supplier<AssumeRoleWithWebIdentityRequest> {
    private final AssumeRoleWithWebIdentityRequest request;
    private final Path webIdentityTokenFile;
    private final String sourceChain;

    public AssumeRoleWithWebIdentityRequestSupplier(Builder builder) {
        this.request = builder.request;
        this.webIdentityTokenFile = builder.webIdentityTokenFile;
        this.sourceChain = builder.sourceChain;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public AssumeRoleWithWebIdentityRequest get() {
        return (AssumeRoleWithWebIdentityRequest)((Object)this.request.toBuilder().webIdentityToken(this.getToken(this.webIdentityTokenFile)).build());
    }

    public Optional<String> sourceChain() {
        return Optional.ofNullable(this.sourceChain);
    }

    private String getToken(Path file) {
        String string;
        block8: {
            InputStream webIdentityTokenStream = Files.newInputStream(file, new OpenOption[0]);
            try {
                string = IoUtils.toUtf8String((InputStream)webIdentityTokenStream);
                if (webIdentityTokenStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (webIdentityTokenStream != null) {
                        try {
                            webIdentityTokenStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            webIdentityTokenStream.close();
        }
        return string;
    }

    public static class Builder {
        private AssumeRoleWithWebIdentityRequest request;
        private Path webIdentityTokenFile;
        private String sourceChain;

        public Builder assumeRoleWithWebIdentityRequest(AssumeRoleWithWebIdentityRequest request) {
            this.request = request;
            return this;
        }

        public Builder webIdentityTokenFile(Path webIdentityTokenFile) {
            this.webIdentityTokenFile = webIdentityTokenFile;
            return this;
        }

        public AssumeRoleWithWebIdentityRequestSupplier build() {
            return new AssumeRoleWithWebIdentityRequestSupplier(this);
        }

        public Builder sourceChain(String sourceChain) {
            this.sourceChain = sourceChain;
            return this;
        }
    }
}

