/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.List;
import org.apache.nifi.diagnostics.DiagnosticsDump;
import org.apache.nifi.diagnostics.DiagnosticsDumpElement;

public class StandardDiagnosticsDump
implements DiagnosticsDump {
    private final List<DiagnosticsDumpElement> dumpElements;
    private final long timestamp;

    public StandardDiagnosticsDump(List<DiagnosticsDumpElement> dumpElements, long timestamp) {
        this.dumpElements = dumpElements;
        this.timestamp = timestamp;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(out);
        BufferedWriter writer = new BufferedWriter(outputStreamWriter);
        writer.write("Diagnostic Dump taken at ");
        Date date = new Date(this.timestamp);
        writer.write(date.toString());
        writer.write("\n\n");
        for (DiagnosticsDumpElement element : this.dumpElements) {
            this.writeHeader(writer, element.getName());
            for (String line : element.getDetails()) {
                writer.write(line);
                writer.write("\n");
            }
            writer.write("\n\n");
        }
        writer.flush();
    }

    private void writeHeader(BufferedWriter writer, String header) throws IOException {
        writer.write(header);
        writer.write("\n");
        for (int i = 0; i < header.length(); ++i) {
            writer.write("-");
        }
        writer.write("\n");
    }
}

