/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps.sax;

import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.Namespace;
import crawlercommons.sitemaps.SiteMapParser;
import crawlercommons.sitemaps.UnknownFormatException;
import crawlercommons.sitemaps.extension.Extension;
import crawlercommons.sitemaps.sax.AtomHandler;
import crawlercommons.sitemaps.sax.RSSHandler;
import crawlercommons.sitemaps.sax.XMLHandler;
import crawlercommons.sitemaps.sax.XMLIndexHandler;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DelegatorHandler
extends DefaultHandler {
    private LinkedList<String> elementStack;
    private DelegatorHandler delegate;
    private URL url;
    private boolean strict;
    private boolean strictNamespace;
    private UnknownFormatException exception;
    private Set<String> acceptedNamespaces;
    protected Map<String, Extension> extensionNamespaces;
    private StringBuilder characterBuffer = new StringBuilder();
    protected Function<String, String> urlFilter = url -> url;

    protected DelegatorHandler(LinkedList<String> elementStack, boolean strict) {
        this.elementStack = elementStack;
        this.strict = strict;
    }

    public DelegatorHandler(URL url2, boolean strict) {
        this.elementStack = new LinkedList();
        this.url = url2;
        this.strict = strict;
    }

    protected URL getUrl() {
        return this.url;
    }

    protected boolean isStrict() {
        return this.strict;
    }

    protected boolean isStrictNamespace() {
        return this.strictNamespace;
    }

    public void setStrictNamespace(boolean s) {
        this.strictNamespace = s;
    }

    public void setAcceptedNamespaces(Set<String> acceptedSet) {
        this.acceptedNamespaces = acceptedSet;
    }

    protected boolean isAcceptedNamespace(String uri) {
        return this.acceptedNamespaces.contains(uri);
    }

    public void setExtensionNamespaces(Map<String, Extension> extensionMap) {
        this.extensionNamespaces = extensionMap;
    }

    protected boolean isExtensionNamespace(String uri) {
        if (this.extensionNamespaces == null) {
            return false;
        }
        return this.extensionNamespaces.containsKey(uri);
    }

    public void setURLFilter(Function<String, String> urlFilter) {
        this.urlFilter = urlFilter;
    }

    protected void setException(UnknownFormatException exception) {
        this.exception = exception;
    }

    public UnknownFormatException getException() {
        return this.exception;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.elementStack.isEmpty() || this.delegate == null) {
            this.startRootElement(uri, localName, qName, attributes);
        } else {
            this.elementStack.push(localName);
        }
        if (this.delegate != null) {
            this.delegate.startElement(uri, localName, qName, attributes);
        }
    }

    private void startRootElement(String uri, String localName, String qName, Attributes attributes) {
        this.elementStack.push(localName);
        if ("feed".equals(localName)) {
            this.delegate = new AtomHandler(this.url, this.elementStack, this.strict);
        } else if ("channel".equals(localName)) {
            this.delegate = new RSSHandler(this.url, this.elementStack, this.strict);
        } else if ("sitemapindex".equals(localName)) {
            this.delegate = new XMLIndexHandler(this.url, this.elementStack, this.strict);
        } else if ("urlset".equals(localName)) {
            this.delegate = new XMLHandler(this.url, this.elementStack, this.strict);
        } else {
            SiteMapParser.LOG.debug("Skipped unknown root element <{}> in {}", (Object)localName, (Object)this.url);
            return;
        }
        this.delegate.setStrictNamespace(this.isStrictNamespace());
        this.delegate.setAcceptedNamespaces(this.acceptedNamespaces);
        if (this.isStrictNamespace()) {
            if (this.delegate instanceof AtomHandler || this.delegate instanceof RSSHandler) {
                return;
            }
            if (!this.isAcceptedNamespace(uri) && uri.startsWith("/")) {
                try {
                    uri = this.url.toURI().resolve(uri).toString();
                }
                catch (IllegalArgumentException | URISyntaxException e) {
                    SiteMapParser.LOG.warn("Failed to resolve relative namespace URI {} in sitemap {}", (Object)uri, (Object)this.url);
                }
            }
            if (!this.isAcceptedNamespace(uri)) {
                String msg = !Namespace.isSupported(uri) ? "Unsupported namespace <" + uri + ">" : "Namespace <" + uri + "> not accepted";
                this.setException(new UnknownFormatException(msg));
                this.delegate = null;
                return;
            }
        }
        this.delegate.setExtensionNamespaces(this.extensionNamespaces);
        this.delegate.setURLFilter(this.urlFilter);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.delegate != null) {
            this.delegate.endElement(uri, localName, qName);
        }
        this.elementStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.delegate != null) {
            this.delegate.characters(ch, start, length);
        }
    }

    protected void appendCharacterBuffer(char[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            this.characterBuffer.append(ch[i]);
        }
    }

    protected void appendCharacterBuffer(String str) {
        this.characterBuffer.append(str);
    }

    protected String getAndResetCharacterBuffer() {
        String value = this.characterBuffer.toString();
        this.resetCharacterBuffer();
        return value;
    }

    protected void resetCharacterBuffer() {
        this.characterBuffer = new StringBuilder();
    }

    protected String currentElement() {
        return this.elementStack.peek();
    }

    protected String currentElementParent() {
        return this.elementStack.size() < 2 ? null : this.elementStack.get(1);
    }

    public AbstractSiteMap getSiteMap() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.getSiteMap();
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (this.delegate != null) {
            this.delegate.error(e);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        if (this.delegate != null) {
            this.delegate.fatalError(e);
        }
    }

    public static boolean isAllBlank(CharSequence charSeq) {
        for (int i = 0; i < charSeq.length(); ++i) {
            if (DelegatorHandler.isWhitespace(charSeq.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(char c) {
        return Character.isWhitespace(c) || c == '\u00a0' || c == '\u2007' || c == '\u202f';
    }

    public static String stripAllBlank(CharSequence charSeq) {
        int start;
        if (charSeq.length() == 0) {
            return charSeq.toString();
        }
        int end = charSeq.length() - 1;
        for (start = 0; DelegatorHandler.isWhitespace(charSeq.charAt(start)) && start < end; ++start) {
        }
        if (start < end) {
            while (DelegatorHandler.isWhitespace(charSeq.charAt(end))) {
                --end;
            }
        }
        return charSeq.subSequence(start, end + 1).toString();
    }
}

