/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.css;

import com.gargoylesoftware.css.dom.AbstractCSSRuleImpl;
import com.gargoylesoftware.htmlunit.css.AbstractCssStyleDeclaration;
import com.gargoylesoftware.htmlunit.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.css.StyleElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import java.util.Locale;
import java.util.Map;

public class ElementCssStyleDeclaration
extends AbstractCssStyleDeclaration {
    private DomElement domElement_;

    public ElementCssStyleDeclaration(DomElement domElement) {
        this.domElement_ = domElement;
    }

    @Override
    public String getStylePriority(String name) {
        StyleElement element = this.domElement_.getStyleElement(name);
        if (element.getValue() != null) {
            return element.getPriority();
        }
        return "";
    }

    @Override
    public String getCssText() {
        return this.domElement_.getAttributeDirect("style");
    }

    @Override
    public String getStyleAttribute(String name) {
        StyleElement element = this.getStyleElement(name);
        if (element != null && element.getValue() != null) {
            String value = element.getValue();
            if (!value.contains("url")) {
                return value.toLowerCase(Locale.ROOT);
            }
            return value;
        }
        return "";
    }

    @Override
    public String getStyleAttribute(StyleAttributes.Definition definition, boolean getDefaultValueIfEmpty) {
        return this.getStyleAttribute(definition.getAttributeName());
    }

    @Override
    public void setCssText(String value) {
        this.domElement_.setAttribute("style", value);
    }

    @Override
    public void setStyleAttribute(String name, String newValue, String important) {
        this.domElement_.replaceStyleAttribute(name, newValue, important);
    }

    @Override
    public String removeStyleAttribute(String name) {
        return this.domElement_.removeStyleAttribute(name);
    }

    @Override
    public int getLength() {
        return this.domElement_.getStyleMap().size();
    }

    @Override
    public Object item(int index) {
        return this.domElement_.getStyleMap().get(index);
    }

    @Override
    public AbstractCSSRuleImpl getParentRule() {
        return null;
    }

    @Override
    public StyleElement getStyleElement(String name) {
        return this.domElement_.getStyleElement(name);
    }

    @Override
    public StyleElement getStyleElementCaseInSensitive(String name) {
        return this.domElement_.getStyleElementCaseInSensitive(name);
    }

    @Override
    public Map<String, StyleElement> getStyleMap() {
        return this.domElement_.getStyleMap();
    }

    @Override
    public Element getElementOrNull() {
        return (Element)this.domElement_.getScriptableObject();
    }

    @Override
    public DomElement getDomElementOrNull() {
        return this.domElement_;
    }
}

