/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net.protocols;

import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class HttpDateFormat {
    public static final DateTimeFormatter FORMAT = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US).withZone(ZoneId.of(ZoneOffset.UTC.toString()));
    public static final DateTimeFormatter PARSE_FORMAT = DateTimeFormatter.ofPattern("EEE, d MMM yyyy HH:mm:ss z", Locale.US).withZone(ZoneId.of(ZoneOffset.UTC.toString()));

    public static String toString(Date date) {
        return FORMAT.format(date.toInstant());
    }

    public static String toString(Calendar cal) {
        return FORMAT.format(cal.toInstant());
    }

    public static String toString(long millis) {
        return FORMAT.format(Instant.ofEpochMilli(millis));
    }

    public static ZonedDateTime toZonedDateTime(String dateString) throws ParseException {
        try {
            return PARSE_FORMAT.parse((CharSequence)dateString, ZonedDateTime::from);
        }
        catch (DateTimeParseException ex) {
            throw new ParseException(ex.getMessage(), 0);
        }
    }

    public static Date toDate(String dateString) throws ParseException {
        return Date.from(HttpDateFormat.toZonedDateTime(dateString).toInstant());
    }

    public static long toLong(String dateString) throws ParseException {
        return HttpDateFormat.toZonedDateTime(dateString).toInstant().toEpochMilli();
    }

    public static void main(String[] args) throws Exception {
        Date now = new Date(System.currentTimeMillis());
        String string = HttpDateFormat.toString(now);
        long time = HttpDateFormat.toLong(string);
        System.out.println(string);
        System.out.println(HttpDateFormat.toString(time));
    }
}

