/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.service.resources;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.nutch.service.NutchServer;
import org.apache.nutch.service.model.request.SeedList;
import org.apache.nutch.service.model.request.SeedUrl;
import org.apache.nutch.service.resources.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/seed")
public class SeedResource
extends AbstractResource {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getSeedLists() {
        Map<String, SeedList> seeds = NutchServer.getInstance().getSeedManager().getSeeds();
        if (seeds != null) {
            return Response.ok(seeds).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/create")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response createSeedFile(SeedList seedList) {
        try {
            if (seedList == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Seed list cannot be empty!").build();
            }
            Collection<SeedUrl> seedUrls = seedList.getSeedUrls();
            String seedFilePath = this.writeToSeedFile(seedUrls);
            seedList.setSeedFilePath(seedFilePath);
            NutchServer.getInstance().getSeedManager().setSeedList(seedList.getName(), seedList);
            return Response.ok().entity((Object)seedFilePath).build();
        }
        catch (Exception e) {
            LOG.warn("Error while creating seed : {}", (Object)e.getMessage());
            return Response.serverError().build();
        }
    }

    private String writeToSeedFile(Collection<SeedUrl> seedUrls) throws Exception {
        String seedFilePath = "seedFiles/seed-" + System.currentTimeMillis();
        org.apache.hadoop.fs.Path seedFolder = new org.apache.hadoop.fs.Path(seedFilePath);
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        if (!fs.exists(seedFolder) && !fs.mkdirs(seedFolder)) {
            throw new Exception("Could not create seed folder at : " + String.valueOf(seedFolder));
        }
        String filename = seedFilePath + System.getProperty("file.separator") + "urls";
        org.apache.hadoop.fs.Path seedPath = new org.apache.hadoop.fs.Path(filename);
        FSDataOutputStream os = fs.create(seedPath);
        if (CollectionUtils.isNotEmpty(seedUrls)) {
            for (SeedUrl seedUrl : seedUrls) {
                os.write(seedUrl.getUrl().getBytes());
                os.write("\n".getBytes());
            }
        }
        os.close();
        return seedPath.getParent().toString();
    }
}

