/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api;

import io.opentelemetry.api.DefaultOpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;

public interface OpenTelemetry {
    public static OpenTelemetry noop() {
        return DefaultOpenTelemetry.getNoop();
    }

    public static OpenTelemetry propagating(ContextPropagators propagators) {
        return DefaultOpenTelemetry.getPropagating(propagators);
    }

    public TracerProvider getTracerProvider();

    default public Tracer getTracer(String instrumentationScopeName) {
        return this.getTracerProvider().get(instrumentationScopeName);
    }

    default public Tracer getTracer(String instrumentationScopeName, String instrumentationScopeVersion) {
        return this.getTracerProvider().get(instrumentationScopeName, instrumentationScopeVersion);
    }

    default public TracerBuilder tracerBuilder(String instrumentationScopeName) {
        return this.getTracerProvider().tracerBuilder(instrumentationScopeName);
    }

    default public MeterProvider getMeterProvider() {
        return MeterProvider.noop();
    }

    default public Meter getMeter(String instrumentationScopeName) {
        return this.getMeterProvider().get(instrumentationScopeName);
    }

    default public MeterBuilder meterBuilder(String instrumentationScopeName) {
        return this.getMeterProvider().meterBuilder(instrumentationScopeName);
    }

    public ContextPropagators getPropagators();
}

