/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.quasinewton;

import opennlp.tools.ml.ArrayMath;
import opennlp.tools.ml.maxent.quasinewton.Function;

public class LineSearch {
    private static final double C = 1.0E-4;
    private static final double RHO = 0.5;

    public static void doLineSearch(Function function, double[] direction, LineSearchResult lsr, double initialStepSize) {
        double valueAtNextPoint;
        double stepSize = initialStepSize;
        int currFctEvalCount = lsr.getFctEvalCount();
        double[] x = lsr.getNextPoint();
        double[] gradAtX = lsr.getGradAtNext();
        double valueAtX = lsr.getValueAtNext();
        int dimension = x.length;
        double[] nextPoint = lsr.getCurrPoint();
        double[] gradAtNextPoint = lsr.getGradAtCurr();
        double dirGradientAtX = ArrayMath.innerProduct((double[])direction, (double[])gradAtX);
        double cachedProd = 1.0E-4 * dirGradientAtX;
        while (true) {
            for (int i = 0; i < dimension; ++i) {
                nextPoint[i] = x[i] + direction[i] * stepSize;
            }
            valueAtNextPoint = function.valueAt(nextPoint);
            ++currFctEvalCount;
            if (valueAtNextPoint <= valueAtX + cachedProd * stepSize) break;
            stepSize *= 0.5;
        }
        System.arraycopy(function.gradientAt(nextPoint), 0, gradAtNextPoint, 0, gradAtNextPoint.length);
        lsr.setAll(stepSize, valueAtX, valueAtNextPoint, gradAtX, gradAtNextPoint, x, nextPoint, currFctEvalCount);
    }

    public static void doConstrainedLineSearch(Function function, double[] direction, LineSearchResult lsr, double l1Cost, double initialStepSize) {
        double valueAtNextPoint;
        int i;
        double stepSize = initialStepSize;
        int currFctEvalCount = lsr.getFctEvalCount();
        double[] x = lsr.getNextPoint();
        double[] signX = lsr.getSignVector();
        double[] gradAtX = lsr.getGradAtNext();
        double[] pseudoGradAtX = lsr.getPseudoGradAtNext();
        double valueAtX = lsr.getValueAtNext();
        int dimension = x.length;
        double[] nextPoint = lsr.getCurrPoint();
        double[] gradAtNextPoint = lsr.getGradAtCurr();
        for (i = 0; i < dimension; ++i) {
            signX[i] = x[i] == 0.0 ? -pseudoGradAtX[i] : x[i];
        }
        while (true) {
            for (i = 0; i < dimension; ++i) {
                nextPoint[i] = x[i] + direction[i] * stepSize;
            }
            for (i = 0; i < dimension; ++i) {
                if (!(nextPoint[i] * signX[i] <= 0.0)) continue;
                nextPoint[i] = 0.0;
            }
            valueAtNextPoint = function.valueAt(nextPoint) + l1Cost * ArrayMath.l1norm((double[])nextPoint);
            ++currFctEvalCount;
            double dirGradientAtX = 0.0;
            for (i = 0; i < dimension; ++i) {
                dirGradientAtX += (nextPoint[i] - x[i]) * pseudoGradAtX[i];
            }
            if (valueAtNextPoint <= valueAtX + 1.0E-4 * dirGradientAtX) break;
            stepSize *= 0.5;
        }
        System.arraycopy(function.gradientAt(nextPoint), 0, gradAtNextPoint, 0, gradAtNextPoint.length);
        lsr.setAll(stepSize, valueAtX, valueAtNextPoint, gradAtX, gradAtNextPoint, pseudoGradAtX, x, nextPoint, signX, currFctEvalCount);
    }

    public static class LineSearchResult {
        private int fctEvalCount;
        private double stepSize;
        private double valueAtCurr;
        private double valueAtNext;
        private double[] gradAtCurr;
        private double[] gradAtNext;
        private double[] pseudoGradAtNext;
        private double[] currPoint;
        private double[] nextPoint;
        private double[] signVector;

        public LineSearchResult(double stepSize, double valueAtCurr, double valueAtNext, double[] gradAtCurr, double[] gradAtNext, double[] currPoint, double[] nextPoint, int fctEvalCount) {
            this.setAll(stepSize, valueAtCurr, valueAtNext, gradAtCurr, gradAtNext, currPoint, nextPoint, fctEvalCount);
        }

        public LineSearchResult(double stepSize, double valueAtCurr, double valueAtNext, double[] gradAtCurr, double[] gradAtNext, double[] pseudoGradAtNext, double[] currPoint, double[] nextPoint, double[] signVector, int fctEvalCount) {
            this.setAll(stepSize, valueAtCurr, valueAtNext, gradAtCurr, gradAtNext, pseudoGradAtNext, currPoint, nextPoint, signVector, fctEvalCount);
        }

        public void setAll(double stepSize, double valueAtCurr, double valueAtNext, double[] gradAtCurr, double[] gradAtNext, double[] currPoint, double[] nextPoint, int fctEvalCount) {
            this.setAll(stepSize, valueAtCurr, valueAtNext, gradAtCurr, gradAtNext, null, currPoint, nextPoint, null, fctEvalCount);
        }

        public void setAll(double stepSize, double valueAtCurr, double valueAtNext, double[] gradAtCurr, double[] gradAtNext, double[] pseudoGradAtNext, double[] currPoint, double[] nextPoint, double[] signVector, int fctEvalCount) {
            this.stepSize = stepSize;
            this.valueAtCurr = valueAtCurr;
            this.valueAtNext = valueAtNext;
            this.gradAtCurr = gradAtCurr;
            this.gradAtNext = gradAtNext;
            this.pseudoGradAtNext = pseudoGradAtNext;
            this.currPoint = currPoint;
            this.nextPoint = nextPoint;
            this.signVector = signVector;
            this.fctEvalCount = fctEvalCount;
        }

        public double getFuncChangeRate() {
            return (this.valueAtCurr - this.valueAtNext) / this.valueAtCurr;
        }

        public double getStepSize() {
            return this.stepSize;
        }

        public void setStepSize(double stepSize) {
            this.stepSize = stepSize;
        }

        public double getValueAtCurr() {
            return this.valueAtCurr;
        }

        public void setValueAtCurr(double valueAtCurr) {
            this.valueAtCurr = valueAtCurr;
        }

        public double getValueAtNext() {
            return this.valueAtNext;
        }

        public void setValueAtNext(double valueAtNext) {
            this.valueAtNext = valueAtNext;
        }

        public double[] getGradAtCurr() {
            return this.gradAtCurr;
        }

        public void setGradAtCurr(double[] gradAtCurr) {
            this.gradAtCurr = gradAtCurr;
        }

        public double[] getGradAtNext() {
            return this.gradAtNext;
        }

        public void setGradAtNext(double[] gradAtNext) {
            this.gradAtNext = gradAtNext;
        }

        public double[] getPseudoGradAtNext() {
            return this.pseudoGradAtNext;
        }

        public void setPseudoGradAtNext(double[] pseudoGradAtNext) {
            this.pseudoGradAtNext = pseudoGradAtNext;
        }

        public double[] getCurrPoint() {
            return this.currPoint;
        }

        public void setCurrPoint(double[] currPoint) {
            this.currPoint = currPoint;
        }

        public double[] getNextPoint() {
            return this.nextPoint;
        }

        public void setNextPoint(double[] nextPoint) {
            this.nextPoint = nextPoint;
        }

        public double[] getSignVector() {
            return this.signVector;
        }

        public void setSignVector(double[] signVector) {
            this.signVector = signVector;
        }

        public int getFctEvalCount() {
            return this.fctEvalCount;
        }

        public void setFctEvalCount(int fctEvalCount) {
            this.fctEvalCount = fctEvalCount;
        }

        public static LineSearchResult getInitialObject(double valueAtX, double[] gradAtX, double[] x) {
            return LineSearchResult.getInitialObject(valueAtX, gradAtX, null, x, null, 0);
        }

        public static LineSearchResult getInitialObjectForL1(double valueAtX, double[] gradAtX, double[] pseudoGradAtX, double[] x) {
            return LineSearchResult.getInitialObject(valueAtX, gradAtX, pseudoGradAtX, x, new double[x.length], 0);
        }

        public static LineSearchResult getInitialObject(double valueAtX, double[] gradAtX, double[] pseudoGradAtX, double[] x, double[] signX, int fctEvalCount) {
            return new LineSearchResult(0.0, 0.0, valueAtX, new double[x.length], gradAtX, pseudoGradAtX, new double[x.length], x, signX, fctEvalCount);
        }
    }
}

