/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.parser.Constituent;
import opennlp.tools.parser.GapLabeler;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.util.Span;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parse
implements Cloneable,
Comparable<Parse> {
    private static final Logger logger = LoggerFactory.getLogger(Parse.class);
    public static final String BRACKET_LRB = "(";
    public static final String BRACKET_RRB = ")";
    public static final String BRACKET_LCB = "{";
    public static final String BRACKET_RCB = "}";
    public static final String BRACKET_LSB = "[";
    public static final String BRACKET_RSB = "]";
    private final String text;
    private Span span;
    private String type;
    private List<Parse> parts;
    private Parse head;
    private String label;
    private int headIndex;
    private Parse parent;
    private double prob;
    private StringBuffer derivation;
    private boolean isChunk;
    private static final Pattern typePattern = Pattern.compile("^([^ =-]+)");
    private static final Pattern funTypePattern = Pattern.compile("^[^ =-]+-([^ =-]+)");
    private static final Pattern tokenPattern = Pattern.compile("^[^ ()]+ ([^ ()]+)\\s*\\)");
    private Collection<Parse> prevPunctSet;
    private Collection<Parse> nextPunctSet;
    private static boolean useFunctionTags;

    public Parse(String text, Span span, String type, double p, int index) {
        this.text = text;
        this.span = span;
        this.type = type;
        this.prob = p;
        this.head = this;
        this.headIndex = index;
        this.parts = new LinkedList<Parse>();
        this.label = null;
        this.parent = null;
    }

    public Parse(String text, Span span, String type, double p, Parse h) {
        this(text, span, type, p, 0);
        if (h != null) {
            this.head = h;
            this.headIndex = h.headIndex;
        }
    }

    public Object clone() {
        Parse p = new Parse(this.text, this.span, this.type, this.prob, this.head);
        p.parts = new LinkedList<Parse>();
        p.parts.addAll(this.parts);
        if (this.derivation != null) {
            p.derivation = new StringBuffer(100);
            p.derivation.append(this.derivation);
        }
        p.label = this.label;
        return p;
    }

    public Parse clone(Parse node) {
        if (this == node) {
            return (Parse)this.clone();
        }
        Parse c = (Parse)this.clone();
        Parse lc = c.parts.get(this.parts.size() - 1);
        c.parts.set(this.parts.size() - 1, lc.clone(node));
        return c;
    }

    public Parse cloneRoot(Parse node, int parseIndex) {
        Parse c = (Parse)this.clone();
        Parse fc = c.parts.get(parseIndex);
        c.parts.set(parseIndex, fc.clone(node));
        return c;
    }

    public static void useFunctionTags(boolean uft) {
        useFunctionTags = uft;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Collection<Parse> getPreviousPunctuationSet() {
        return this.prevPunctSet;
    }

    public void addPreviousPunctuation(Parse punct) {
        if (this.prevPunctSet == null) {
            this.prevPunctSet = new TreeSet<Parse>();
        }
        this.prevPunctSet.add(punct);
    }

    public Collection<Parse> getNextPunctuationSet() {
        return this.nextPunctSet;
    }

    public void addNextPunctuation(Parse punct) {
        if (this.nextPunctSet == null) {
            this.nextPunctSet = new TreeSet<Parse>();
        }
        this.nextPunctSet.add(punct);
    }

    public void setNextPunctuation(Collection<Parse> punctSet) {
        this.nextPunctSet = punctSet;
    }

    public void setPrevPunctuation(Collection<Parse> punctSet) {
        this.prevPunctSet = punctSet;
    }

    public void insert(Parse constituent) {
        int pi;
        Span ic = constituent.span;
        if (this.span.contains(ic)) {
            int pn = this.parts.size();
            for (pi = 0; pi < pn; ++pi) {
                Span sp;
                Parse subPart = this.parts.get(pi);
                if (logger.isTraceEnabled()) {
                    logger.trace("Parse.insert:con={} sp[{}] {} {}", new Object[]{constituent, pi, subPart, subPart.getType()});
                }
                if ((sp = subPart.span).getStart() >= ic.getEnd()) break;
                if (ic.contains(sp)) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Parse.insert:con contains subPart");
                    }
                    this.parts.remove(pi);
                    --pi;
                    constituent.parts.add(subPart);
                    subPart.setParent(constituent);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Parse.insert: {} -> {}", (Object)subPart.hashCode(), (Object)subPart.getParent().hashCode());
                    }
                    pn = this.parts.size();
                    continue;
                }
                if (!sp.contains(ic)) continue;
                if (logger.isTraceEnabled()) {
                    logger.trace("Parse.insert:subPart contains con");
                }
                subPart.insert(constituent);
                return;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("Parse.insert:adding con={} to {}", (Object)constituent, (Object)this);
            }
        } else {
            throw new IllegalArgumentException("Inserting constituent not contained in the sentence!");
        }
        this.parts.add(pi, constituent);
        constituent.setParent(this);
    }

    public void show(StringBuffer sb) {
        int start = this.span.getStart();
        if (!this.type.equals("TK")) {
            sb.append(BRACKET_LRB);
            sb.append(this.type).append(" ");
            if (logger.isTraceEnabled()) {
                logger.trace("{} ", (Object)this.label);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{} ", (Object)this.head);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("{} ", (Object)this.prob);
            }
        }
        for (Parse c : this.parts) {
            Span s = c.span;
            if (start < s.getStart()) {
                if (logger.isTraceEnabled()) {
                    logger.trace("pre {} {}", (Object)start, (Object)s.getStart());
                }
                sb.append(Parse.encodeToken(this.text.substring(start, s.getStart())));
            }
            c.show(sb);
            start = s.getEnd();
        }
        if (start < this.span.getEnd()) {
            sb.append(Parse.encodeToken(this.text.substring(start, this.span.getEnd())));
        }
        if (!this.type.equals("TK")) {
            sb.append(BRACKET_RRB);
        }
    }

    public void show() {
        StringBuffer sb = new StringBuffer(this.text.length() * 4);
        this.show(sb);
        logger.debug(sb.toString());
    }

    public double getTagSequenceProb() {
        if (logger.isTraceEnabled()) {
            logger.trace("Parse.getTagSequenceProb: {} {}", (Object)this.type, (Object)this);
        }
        if (this.parts.size() == 1 && this.parts.get((int)0).type.equals("TK")) {
            if (logger.isTraceEnabled()) {
                logger.trace("{} {}", (Object)this, (Object)this.prob);
            }
            return StrictMath.log(this.prob);
        }
        if (this.parts.size() == 0) {
            logger.warn("Parse.getTagSequenceProb: Wrong base case!");
            return 0.0;
        }
        double sum = 0.0;
        for (Parse part : this.parts) {
            sum += part.getTagSequenceProb();
        }
        return sum;
    }

    public boolean complete() {
        return this.parts.size() == 1;
    }

    public String getCoveredText() {
        return this.text.substring(this.span.getStart(), this.span.getEnd());
    }

    public String toStringPennTreebank() {
        StringBuffer buffer = new StringBuffer();
        this.show(buffer);
        return buffer.toString();
    }

    public String toString() {
        return this.getCoveredText();
    }

    public String getText() {
        return this.text;
    }

    public Span getSpan() {
        return this.span;
    }

    public double getProb() {
        return this.prob;
    }

    public void addProb(double logProb) {
        this.prob += logProb;
    }

    public Parse[] getChildren() {
        return this.parts.toArray(new Parse[0]);
    }

    public void setChild(int index, String label) {
        Parse newChild = (Parse)this.parts.get(index).clone();
        newChild.setLabel(label);
        this.parts.set(index, newChild);
    }

    public void add(Parse daughter, HeadRules rules) {
        if (daughter.prevPunctSet != null) {
            this.parts.addAll(daughter.prevPunctSet);
        }
        this.parts.add(daughter);
        this.span = new Span(this.span.getStart(), daughter.getSpan().getEnd());
        this.head = rules.getHead(this.getChildren(), this.type);
        this.headIndex = this.head.headIndex;
    }

    public void remove(int index) {
        this.parts.remove(index);
        if (!(this.parts.isEmpty() || index != 0 && index != this.parts.size())) {
            this.span = new Span(this.parts.get((int)0).span.getStart(), this.parts.get((int)(this.parts.size() - 1)).span.getEnd());
        }
    }

    public Parse adjoinRoot(Parse node, HeadRules rules, int parseIndex) {
        Parse lastChild = this.parts.get(parseIndex);
        Parse adjNode = new Parse(this.text, new Span(lastChild.getSpan().getStart(), node.getSpan().getEnd()), lastChild.getType(), 1.0, rules.getHead(new Parse[]{lastChild, node}, lastChild.getType()));
        adjNode.parts.add(lastChild);
        if (node.prevPunctSet != null) {
            adjNode.parts.addAll(node.prevPunctSet);
        }
        adjNode.parts.add(node);
        this.parts.set(parseIndex, adjNode);
        return adjNode;
    }

    public Parse adjoin(Parse sister, HeadRules rules) {
        Parse lastChild = this.parts.get(this.parts.size() - 1);
        Parse adjNode = new Parse(this.text, new Span(lastChild.getSpan().getStart(), sister.getSpan().getEnd()), lastChild.getType(), 1.0, rules.getHead(new Parse[]{lastChild, sister}, lastChild.getType()));
        adjNode.parts.add(lastChild);
        if (sister.prevPunctSet != null) {
            adjNode.parts.addAll(sister.prevPunctSet);
        }
        adjNode.parts.add(sister);
        this.parts.set(this.parts.size() - 1, adjNode);
        this.span = new Span(this.span.getStart(), sister.getSpan().getEnd());
        this.head = rules.getHead(this.getChildren(), this.type);
        this.headIndex = this.head.headIndex;
        return adjNode;
    }

    public void expandTopNode(Parse root) {
        boolean beforeRoot = true;
        if (logger.isTraceEnabled()) {
            logger.trace("expandTopNode: parts={}", this.parts);
        }
        int pi = 0;
        int ai = 0;
        while (pi < this.parts.size()) {
            Parse node = this.parts.get(pi);
            if (node == root) {
                beforeRoot = false;
            } else if (beforeRoot) {
                root.parts.add(ai, node);
                this.parts.remove(pi);
                --pi;
            } else {
                root.parts.add(node);
                this.parts.remove(pi);
                --pi;
            }
            ++pi;
            ++ai;
        }
        root.updateSpan();
    }

    public int getChildCount() {
        return this.parts.size();
    }

    public int indexOf(Parse child) {
        return this.parts.indexOf(child);
    }

    public Parse getHead() {
        return this.head;
    }

    public int getHeadIndex() {
        return this.headIndex;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    private static String getType(String rest) {
        if (rest.startsWith("-LCB-")) {
            return "-LCB-";
        }
        if (rest.startsWith("-RCB-")) {
            return "-RCB-";
        }
        if (rest.startsWith("-LRB-")) {
            return "-LRB-";
        }
        if (rest.startsWith("-RRB-")) {
            return "-RRB-";
        }
        if (rest.startsWith("-RSB-")) {
            return "-RSB-";
        }
        if (rest.startsWith("-LSB-")) {
            return "-LSB-";
        }
        if (rest.startsWith("-NONE-")) {
            return "-NONE-";
        }
        Matcher typeMatcher = typePattern.matcher(rest);
        if (typeMatcher.find()) {
            Matcher funMatcher;
            Object type = typeMatcher.group(1);
            if (useFunctionTags && (funMatcher = funTypePattern.matcher(rest)).find()) {
                String ftag = funMatcher.group(1);
                type = (String)type + "-" + ftag;
            }
            return type;
        }
        return null;
    }

    private static String encodeToken(String token) {
        if (BRACKET_LRB.equals(token)) {
            return "-LRB-";
        }
        if (BRACKET_RRB.equals(token)) {
            return "-RRB-";
        }
        if (BRACKET_LCB.equals(token)) {
            return "-LCB-";
        }
        if (BRACKET_RCB.equals(token)) {
            return "-RCB-";
        }
        if (BRACKET_LSB.equals(token)) {
            return "-LSB-";
        }
        if (BRACKET_RSB.equals(token)) {
            return "-RSB-";
        }
        return token;
    }

    private static String decodeToken(String token) {
        if ("-LRB-".equals(token)) {
            return BRACKET_LRB;
        }
        if ("-RRB-".equals(token)) {
            return BRACKET_RRB;
        }
        if ("-LCB-".equals(token)) {
            return BRACKET_LCB;
        }
        if ("-RCB-".equals(token)) {
            return BRACKET_RCB;
        }
        if ("-LSB-".equals(token)) {
            return BRACKET_LSB;
        }
        if ("-RSB-".equals(token)) {
            return BRACKET_RSB;
        }
        return token;
    }

    private static String getToken(String rest) {
        Matcher tokenMatcher = tokenPattern.matcher(rest);
        if (tokenMatcher.find()) {
            return Parse.decodeToken(tokenMatcher.group(1));
        }
        return null;
    }

    public void updateHeads(HeadRules rules) {
        if (this.parts != null && this.parts.size() != 0) {
            for (Parse c : this.parts) {
                c.updateHeads(rules);
            }
            this.head = rules.getHead(this.parts.toArray(new Parse[0]), this.type);
            if (this.head == null) {
                this.head = this;
            } else {
                this.headIndex = this.head.headIndex;
            }
        } else {
            this.head = this;
        }
    }

    public void updateSpan() {
        this.span = new Span(this.parts.get((int)0).span.getStart(), this.parts.get((int)(this.parts.size() - 1)).span.getEnd());
    }

    public static void pruneParse(Parse parse) {
        LinkedList<Parse> nodes = new LinkedList<Parse>();
        nodes.add(parse);
        while (nodes.size() != 0) {
            Parse node = (Parse)nodes.remove(0);
            Parse[] children = node.getChildren();
            if (children.length == 1 && node.getType().equals(children[0].getType())) {
                int index = node.getParent().parts.indexOf(node);
                children[0].setParent(node.getParent());
                node.getParent().parts.set(index, children[0]);
                node.parent = null;
                node.parts = null;
            }
            nodes.addAll(Arrays.asList(children));
        }
    }

    public static void fixPossesives(Parse parse) {
        Parse[] tags = parse.getTagNodes();
        for (int ti = 0; ti < tags.length; ++ti) {
            if (!tags[ti].getType().equals("POS") || ti + 1 >= tags.length || tags[ti + 1].getParent() != tags[ti].getParent().getParent()) continue;
            int start = tags[ti + 1].getSpan().getStart();
            int end = tags[ti + 1].getSpan().getEnd();
            for (int npi = ti + 2; npi < tags.length && tags[npi].getParent() == tags[npi - 1].getParent(); ++npi) {
                end = tags[npi].getSpan().getEnd();
            }
            Parse npPos = new Parse(parse.getText(), new Span(start, end), "NP", 1.0, tags[ti + 1]);
            parse.insert(npPos);
        }
    }

    public static Parse parseParse(String parse) {
        return Parse.parseParse(parse, null);
    }

    public static Parse parseParse(String parse, GapLabeler gl) {
        StringBuilder text = new StringBuilder();
        int offset = 0;
        Stack<Constituent> stack = new Stack<Constituent>();
        LinkedList<Constituent> cons = new LinkedList<Constituent>();
        int cl = parse.length();
        for (int ci = 0; ci < cl; ++ci) {
            Constituent con;
            int start;
            char c = parse.charAt(ci);
            if (c == '(') {
                String rest = parse.substring(ci + 1);
                String type = Parse.getType(rest);
                if (type == null) {
                    logger.warn("null type for: {}", (Object)rest);
                }
                String token = Parse.getToken(rest);
                stack.push(new Constituent(type, new Span(offset, offset)));
                if (token == null) continue;
                if (Objects.equals(type, "-NONE-") && gl != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("stack.size={}", (Object)stack.size());
                    }
                    gl.labelGaps(stack);
                    continue;
                }
                cons.add(new Constituent("TK", new Span(offset, offset + token.length())));
                text.append(token).append(" ");
                offset += token.length() + 1;
                continue;
            }
            if (c != ')' || (start = (con = (Constituent)stack.pop()).getSpan().getStart()) >= offset) continue;
            cons.add(new Constituent(con.getLabel(), new Span(start, offset - 1)));
        }
        String txt = text.toString();
        int tokenIndex = -1;
        Parse p = new Parse(txt, new Span(0, txt.length()), "TOP", 1.0, 0);
        for (Constituent con : cons) {
            String type = con.getLabel();
            if (type.equals("TOP")) continue;
            if ("TK".equals(type)) {
                ++tokenIndex;
            }
            Parse c = new Parse(txt, con.getSpan(), type, 1.0, tokenIndex);
            if (logger.isTraceEnabled()) {
                logger.trace("insert[{}] {} {} {}", new Object[]{tokenIndex, type, c, c.hashCode()});
            }
            p.insert(c);
        }
        return p;
    }

    public Parse getParent() {
        return this.parent;
    }

    public void setParent(Parse parent) {
        this.parent = parent;
    }

    public boolean isPosTag() {
        return this.parts.size() == 1 && this.parts.get(0).getType().equals("TK");
    }

    public boolean isFlat() {
        boolean flat = true;
        for (Parse part : this.parts) {
            flat &= part.isPosTag();
        }
        return flat;
    }

    public void isChunk(boolean ic) {
        this.isChunk = ic;
    }

    public boolean isChunk() {
        return this.isChunk;
    }

    public Parse[] getTagNodes() {
        LinkedList<Parse> tags = new LinkedList<Parse>();
        LinkedList<Parse> nodes = new LinkedList<Parse>(this.parts);
        while (nodes.size() != 0) {
            Parse p = (Parse)nodes.remove(0);
            if (p.isPosTag()) {
                tags.add(p);
                continue;
            }
            nodes.addAll(0, p.parts);
        }
        return tags.toArray(new Parse[0]);
    }

    public Parse[] getTokenNodes() {
        LinkedList<Parse> tokens = new LinkedList<Parse>();
        LinkedList<Parse> nodes = new LinkedList<Parse>(this.parts);
        while (nodes.size() != 0) {
            Parse p = (Parse)nodes.remove(0);
            if (p.getType().equals("TK")) {
                tokens.add(p);
                continue;
            }
            nodes.addAll(0, p.parts);
        }
        return tokens.toArray(new Parse[0]);
    }

    public Parse getCommonParent(Parse node) {
        if (this == node) {
            return this.parent;
        }
        HashSet<Parse> parents = new HashSet<Parse>();
        for (Parse cparent = this; cparent != null; cparent = cparent.getParent()) {
            parents.add(cparent);
        }
        while (node != null) {
            if (parents.contains(node)) {
                return node;
            }
            node = node.getParent();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Parse) {
            Parse p = (Parse)obj;
            return Objects.equals(this.label, p.label) && this.span.equals(p.span) && this.text.equals(p.text) && this.parts.equals(p.parts);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.span, this.text);
    }

    @Override
    public int compareTo(Parse p) {
        return Double.compare(p.getProb(), this.getProb());
    }

    public StringBuffer getDerivation() {
        return this.derivation;
    }

    public void setDerivation(StringBuffer derivation) {
        this.derivation = derivation;
    }

    private void codeTree(Parse p, int[] levels) {
        Parse[] kids = p.getChildren();
        StringBuilder levelsBuff = new StringBuilder();
        levelsBuff.append(BRACKET_LSB);
        int[] nlevels = new int[levels.length + 1];
        for (int li = 0; li < levels.length; ++li) {
            nlevels[li] = levels[li];
            levelsBuff.append(levels[li]).append(".");
        }
        for (int ki = 0; ki < kids.length; ++ki) {
            nlevels[levels.length] = ki;
            logger.info(levelsBuff.toString() + ki + "] " + kids[ki].getType() + " " + kids[ki].hashCode() + " -> " + kids[ki].getParent().hashCode() + " " + kids[ki].getParent().getType() + " " + kids[ki].getCoveredText());
            this.codeTree(kids[ki], nlevels);
        }
    }

    public void showCodeTree() {
        this.codeTree(this, new int[0]);
    }

    public static void addNames(String tag, Span[] names, Parse[] tokens) {
        for (Span nameTokenSpan : names) {
            Parse[] grandKids;
            Parse startToken = tokens[nameTokenSpan.getStart()];
            Parse endToken = tokens[nameTokenSpan.getEnd() - 1];
            Parse commonParent = startToken.getCommonParent(endToken);
            if (logger.isTraceEnabled()) {
                logger.trace("addNames: {} .. {} commonParent = {}", new Object[]{startToken, endToken, commonParent});
            }
            if (commonParent == null) continue;
            Span nameSpan = new Span(startToken.getSpan().getStart(), endToken.getSpan().getEnd());
            if (nameSpan.equals(commonParent.getSpan())) {
                commonParent.insert(new Parse(commonParent.getText(), nameSpan, tag, 1.0, endToken.getHeadIndex()));
                continue;
            }
            Parse[] kids = commonParent.getChildren();
            boolean crossingKids = false;
            for (Parse kid : kids) {
                if (!nameSpan.crosses(kid.getSpan())) continue;
                crossingKids = true;
            }
            if (!crossingKids) {
                commonParent.insert(new Parse(commonParent.getText(), nameSpan, tag, 1.0, endToken.getHeadIndex()));
                continue;
            }
            if (!commonParent.getType().equals("NP") || (grandKids = kids[0].getChildren()).length <= 1 || !nameSpan.contains(grandKids[grandKids.length - 1].getSpan())) continue;
            commonParent.insert(new Parse(commonParent.getText(), commonParent.getSpan(), tag, 1.0, commonParent.getHeadIndex()));
        }
    }
}

