/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.recon.api.AdminOnly;
import org.apache.hadoop.ozone.recon.api.types.VolumeObjectDBInfo;
import org.apache.hadoop.ozone.recon.api.types.VolumesResponse;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;

@Path(value="/volumes")
@Produces(value={"application/json"})
@AdminOnly
public class VolumeEndpoint {
    @Inject
    private ReconOMMetadataManager omMetadataManager;

    @Inject
    public VolumeEndpoint(ReconOMMetadataManager omMetadataManager) {
        this.omMetadataManager = omMetadataManager;
    }

    @GET
    public Response getVolumes(@DefaultValue(value="1000") @QueryParam(value="limit") int limit, @DefaultValue(value="") @QueryParam(value="prevKey") String prevKey) throws IOException {
        List<OmVolumeArgs> volumes = this.omMetadataManager.listVolumes(prevKey, limit);
        List<VolumeObjectDBInfo> volumeMetadata = volumes.stream().map(VolumeObjectDBInfo::new).collect(Collectors.toList());
        VolumesResponse volumesResponse = new VolumesResponse(volumes.size(), volumeMetadata);
        return Response.ok((Object)volumesResponse).build();
    }
}

