/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.api.types;

import org.apache.hadoop.hdds.scm.server.OzoneStorageContainerManager;
import org.apache.hadoop.ozone.recon.api.handlers.BucketEntityHandler;
import org.apache.hadoop.ozone.recon.api.handlers.BucketHandler;
import org.apache.hadoop.ozone.recon.api.handlers.DirectoryEntityHandler;
import org.apache.hadoop.ozone.recon.api.handlers.EntityHandler;
import org.apache.hadoop.ozone.recon.api.handlers.KeyEntityHandler;
import org.apache.hadoop.ozone.recon.api.handlers.RootEntityHandler;
import org.apache.hadoop.ozone.recon.api.handlers.UnknownEntityHandler;
import org.apache.hadoop.ozone.recon.api.handlers.VolumeEntityHandler;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.apache.hadoop.ozone.recon.spi.ReconNamespaceSummaryManager;

public enum EntityType {
    ROOT{

        @Override
        public EntityHandler create(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, BucketHandler bucketHandler, String path) {
            return new RootEntityHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM, path);
        }
    }
    ,
    VOLUME{

        @Override
        public EntityHandler create(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, BucketHandler bucketHandler, String path) {
            return new VolumeEntityHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM, path);
        }
    }
    ,
    BUCKET{

        @Override
        public EntityHandler create(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, BucketHandler bucketHandler, String path) {
            return new BucketEntityHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketHandler, path);
        }
    }
    ,
    DIRECTORY{

        @Override
        public EntityHandler create(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, BucketHandler bucketHandler, String path) {
            return new DirectoryEntityHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketHandler, path);
        }
    }
    ,
    KEY{

        @Override
        public EntityHandler create(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, BucketHandler bucketHandler, String path) {
            return new KeyEntityHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM, bucketHandler, path);
        }
    }
    ,
    UNKNOWN{

        @Override
        public EntityHandler create(ReconNamespaceSummaryManager reconNamespaceSummaryManager, ReconOMMetadataManager omMetadataManager, OzoneStorageContainerManager reconSCM, BucketHandler bucketHandler, String path) {
            return new UnknownEntityHandler(reconNamespaceSummaryManager, omMetadataManager, reconSCM);
        }
    };


    public abstract EntityHandler create(ReconNamespaceSummaryManager var1, ReconOMMetadataManager var2, OzoneStorageContainerManager var3, BucketHandler var4, String var5);
}

