/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.recovery;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.RDBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.TableCache;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.api.types.KeyEntityInfoProtoWrapper;
import org.apache.hadoop.ozone.recon.recovery.ReconOMMetadataManager;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ReconOmMetadataManagerImpl
extends OmMetadataManagerImpl
implements ReconOMMetadataManager {
    private static final Logger LOG = LoggerFactory.getLogger(ReconOmMetadataManagerImpl.class);
    private OzoneConfiguration ozoneConfiguration;
    private ReconUtils reconUtils;
    private boolean omTablesInitialized = false;

    @Inject
    public ReconOmMetadataManagerImpl(OzoneConfiguration configuration, ReconUtils reconUtils) {
        this.reconUtils = reconUtils;
        this.ozoneConfiguration = configuration;
    }

    public void start(OzoneConfiguration configuration) throws IOException {
        LOG.info("Starting ReconOMMetadataManagerImpl");
        File reconDbDir = this.reconUtils.getReconDbDir((ConfigurationSource)configuration, "ozone.recon.om.db.dir");
        File lastKnownOMSnapshot = this.reconUtils.getLastKnownDB(reconDbDir, "om.snapshot.db");
        if (lastKnownOMSnapshot != null) {
            LOG.info("Last known snapshot for OM : {}", (Object)lastKnownOMSnapshot.getAbsolutePath());
            this.initializeNewRdbStore(lastKnownOMSnapshot);
        }
    }

    private void initializeNewRdbStore(File dbFile) throws IOException {
        try {
            DBStoreBuilder dbStoreBuilder = DBStoreBuilder.newBuilder((ConfigurationSource)this.ozoneConfiguration).setName(dbFile.getName()).setPath(dbFile.toPath().getParent());
            ReconOmMetadataManagerImpl.addOMTablesAndCodecs((DBStoreBuilder)dbStoreBuilder);
            dbStoreBuilder.addCodec(KeyEntityInfoProtoWrapper.class, KeyEntityInfoProtoWrapper.getCodec());
            this.setStore(dbStoreBuilder.build());
            LOG.info("Created OM DB handle from snapshot at {}.", (Object)dbFile.getAbsolutePath());
        }
        catch (IOException ioEx) {
            LOG.error("Unable to initialize Recon OM DB snapshot store.", (Throwable)ioEx);
        }
        if (this.getStore() != null) {
            this.initializeOmTables(TableCache.CacheType.FULL_CACHE, true);
            this.omTablesInitialized = true;
        }
    }

    @Override
    public Table<String, KeyEntityInfoProtoWrapper> getKeyTableLite(BucketLayout bucketLayout) throws IOException {
        String tableName = bucketLayout.isFileSystemOptimized() ? "fileTable" : "keyTable";
        return this.getStore().getTable(tableName, String.class, KeyEntityInfoProtoWrapper.class);
    }

    @Override
    public void updateOmDB(File newDbLocation) throws IOException {
        File oldDBLocation;
        if (this.getStore() != null && (oldDBLocation = this.getStore().getDbLocation()).exists()) {
            LOG.info("Cleaning up old OM snapshot db at {}.", (Object)oldDBLocation.getAbsolutePath());
            FileUtils.deleteDirectory((File)oldDBLocation);
        }
        DBStore current = this.getStore();
        try {
            this.initializeNewRdbStore(newDbLocation);
        }
        finally {
            if (current != null && current != this.getStore()) {
                current.close();
            }
        }
    }

    @Override
    public long getLastSequenceNumberFromDB() {
        RDBStore rocksDBStore = (RDBStore)this.getStore();
        if (null == rocksDBStore) {
            return 0L;
        }
        try {
            return rocksDBStore.getDb().getLatestSequenceNumber();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Override
    public boolean isOmTablesInitialized() {
        return this.omTablesInitialized;
    }

    @Override
    public List<OmVolumeArgs> listVolumes(String startKey, int maxKeys) throws IOException {
        ArrayList result = Lists.newArrayList();
        boolean startKeyIsEmpty = Strings.isNullOrEmpty((String)startKey);
        Table volumeTable = this.getVolumeTable();
        if (volumeTable == null) {
            return result;
        }
        try (TableIterator iterator = volumeTable.iterator();){
            while (iterator.hasNext() && result.size() < maxKeys) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                OmVolumeArgs omVolumeArgs = (OmVolumeArgs)kv.getValue();
                String volumeName = omVolumeArgs.getVolume();
                if (!startKeyIsEmpty) {
                    if (!volumeName.equals(startKey)) continue;
                    startKeyIsEmpty = true;
                    continue;
                }
                result.add(omVolumeArgs);
            }
        }
        return result;
    }

    @Override
    public List<OmVolumeArgs> listVolumes() throws IOException {
        return this.listVolumes(null, Integer.MAX_VALUE);
    }

    @Override
    public boolean volumeExists(String volName) throws IOException {
        String volDBKey = this.getVolumeKey(volName);
        return this.getVolumeTable().getSkipCache((Object)volDBKey) != null;
    }

    @Override
    public List<OmBucketInfo> listBucketsUnderVolume(String volumeName, String startBucket, int maxNumOfBuckets) throws IOException {
        String startKey;
        ArrayList<OmBucketInfo> result = new ArrayList<OmBucketInfo>();
        if (Strings.isNullOrEmpty((String)volumeName)) {
            return this.listAllBuckets(maxNumOfBuckets);
        }
        if (!this.volumeExists(volumeName)) {
            return result;
        }
        boolean skipStartKey = false;
        if (StringUtil.isNotBlank((String)startBucket)) {
            startKey = this.getBucketKey(volumeName, startBucket);
            skipStartKey = true;
        } else {
            startKey = this.getBucketKey(volumeName, null);
        }
        String seekPrefix = this.getVolumeKey(volumeName + "/");
        int currentCount = 0;
        try (TableIterator iterator = this.getBucketTable().iterator((Object)seekPrefix);){
            while (currentCount < maxNumOfBuckets && iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                String key = (String)kv.getKey();
                OmBucketInfo omBucketInfo = (OmBucketInfo)kv.getValue();
                if (omBucketInfo == null || key.equals(startKey) && skipStartKey || !key.startsWith(seekPrefix) || key.compareTo(startKey) < 0) continue;
                result.add(omBucketInfo);
                ++currentCount;
            }
        }
        return result;
    }

    @Override
    public List<OmBucketInfo> listBucketsUnderVolume(String volumeName) throws IOException {
        return this.listBucketsUnderVolume(volumeName, null, Integer.MAX_VALUE);
    }

    @Override
    public OzoneConfiguration getOzoneConfiguration() {
        return this.ozoneConfiguration;
    }

    private List<OmBucketInfo> listAllBuckets(int maxNumberOfBuckets) throws IOException {
        ArrayList<OmBucketInfo> result = new ArrayList<OmBucketInfo>();
        int currentCount = 0;
        Table bucketTable = this.getBucketTable();
        if (bucketTable == null) {
            return result;
        }
        try (TableIterator iterator = bucketTable.iterator();){
            while (currentCount < maxNumberOfBuckets && iterator.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)iterator.next();
                OmBucketInfo omBucketInfo = (OmBucketInfo)kv.getValue();
                if (omBucketInfo == null) continue;
                result.add(omBucketInfo);
                ++currentCount;
            }
        }
        return result;
    }
}

