/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.recon.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.recon.ReconConstants;
import org.apache.hadoop.ozone.recon.ReconUtils;
import org.apache.hadoop.ozone.recon.tasks.OMDBUpdateEvent;
import org.apache.hadoop.ozone.recon.tasks.OMUpdateEventBatch;
import org.apache.hadoop.ozone.recon.tasks.ReconOmTask;
import org.apache.ozone.recon.schema.generated.tables.FileCountBySizeTable;
import org.apache.ozone.recon.schema.generated.tables.daos.FileCountBySizeDao;
import org.apache.ozone.recon.schema.generated.tables.pojos.FileCountBySize;
import org.jooq.DSLContext;
import org.jooq.Record3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileSizeCountTaskHelper {
    protected static final Logger LOG = LoggerFactory.getLogger(FileSizeCountTaskHelper.class);
    private static final Object TRUNCATE_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void truncateTableIfNeeded(DSLContext dslContext) {
        Object object = TRUNCATE_LOCK;
        synchronized (object) {
            if (ReconConstants.FILE_SIZE_COUNT_TABLE_TRUNCATED.compareAndSet(false, true)) {
                try {
                    int execute = dslContext.delete((org.jooq.Table)FileCountBySizeTable.FILE_COUNT_BY_SIZE).execute();
                    LOG.info("Deleted {} records from {}", (Object)execute, (Object)FileCountBySizeTable.FILE_COUNT_BY_SIZE);
                }
                catch (Exception e) {
                    ReconConstants.FILE_SIZE_COUNT_TABLE_TRUNCATED.set(false);
                    LOG.error("Error while truncating FILE_COUNT_BY_SIZE table, resetting flag.", (Throwable)e);
                    throw new RuntimeException("Table truncation failed", e);
                }
            } else {
                LOG.info("Table already truncated by another task; waiting for truncation to complete.");
            }
        }
    }

    public static ReconOmTask.TaskResult reprocess(OMMetadataManager omMetadataManager, DSLContext dslContext, FileCountBySizeDao fileCountBySizeDao, BucketLayout bucketLayout, String taskName) {
        LOG.info("Starting Reprocess for {}", (Object)taskName);
        HashMap<FileSizeCountKey, Long> fileSizeCountMap = new HashMap<FileSizeCountKey, Long>();
        long startTime = System.currentTimeMillis();
        FileSizeCountTaskHelper.truncateTableIfNeeded(dslContext);
        boolean status = FileSizeCountTaskHelper.reprocessBucketLayout(bucketLayout, omMetadataManager, fileSizeCountMap, dslContext, fileCountBySizeDao, taskName);
        if (!status) {
            return FileSizeCountTaskHelper.buildTaskResult(taskName, false);
        }
        FileSizeCountTaskHelper.writeCountsToDB(fileSizeCountMap, dslContext, fileCountBySizeDao);
        long endTime = System.currentTimeMillis();
        LOG.info("{} completed Reprocess in {} ms.", (Object)taskName, (Object)(endTime - startTime));
        return FileSizeCountTaskHelper.buildTaskResult(taskName, true);
    }

    public static boolean reprocessBucketLayout(BucketLayout bucketLayout, OMMetadataManager omMetadataManager, Map<FileSizeCountKey, Long> fileSizeCountMap, DSLContext dslContext, FileCountBySizeDao fileCountBySizeDao, String taskName) {
        Table omKeyInfoTable = omMetadataManager.getKeyTable(bucketLayout);
        int totalKeysProcessed = 0;
        try (TableIterator keyIter = omKeyInfoTable.iterator();){
            while (keyIter.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                FileSizeCountTaskHelper.handlePutKeyEvent((OmKeyInfo)kv.getValue(), fileSizeCountMap);
                ++totalKeysProcessed;
                if (fileSizeCountMap.size() < 100000) continue;
                FileSizeCountTaskHelper.writeCountsToDB(fileSizeCountMap, dslContext, fileCountBySizeDao);
                fileSizeCountMap.clear();
            }
        }
        catch (IOException ioEx) {
            LOG.error("Unable to populate File Size Count for {} in Recon DB.", (Object)taskName, (Object)ioEx);
            return false;
        }
        LOG.info("Reprocessed {} keys for bucket layout {}.", (Object)totalKeysProcessed, (Object)bucketLayout);
        return true;
    }

    public static ReconOmTask.TaskResult processEvents(OMUpdateEventBatch events, String tableName, DSLContext dslContext, FileCountBySizeDao fileCountBySizeDao, String taskName) {
        Iterator<OMDBUpdateEvent> eventIterator = events.getIterator();
        HashMap<FileSizeCountKey, Long> fileSizeCountMap = new HashMap<FileSizeCountKey, Long>();
        long startTime = System.currentTimeMillis();
        while (eventIterator.hasNext()) {
            OMDBUpdateEvent omdbUpdateEvent = eventIterator.next();
            if (!tableName.equals(omdbUpdateEvent.getTable())) continue;
            String updatedKey = (String)omdbUpdateEvent.getKey();
            Object value = omdbUpdateEvent.getValue();
            Object oldValue = omdbUpdateEvent.getOldValue();
            if (value instanceof OmKeyInfo) {
                OmKeyInfo omKeyInfo = (OmKeyInfo)value;
                OmKeyInfo omKeyInfoOld = (OmKeyInfo)oldValue;
                try {
                    switch (omdbUpdateEvent.getAction()) {
                        case PUT: {
                            FileSizeCountTaskHelper.handlePutKeyEvent(omKeyInfo, fileSizeCountMap);
                            break;
                        }
                        case DELETE: {
                            FileSizeCountTaskHelper.handleDeleteKeyEvent(updatedKey, omKeyInfo, fileSizeCountMap);
                            break;
                        }
                        case UPDATE: {
                            if (omKeyInfoOld != null) {
                                FileSizeCountTaskHelper.handleDeleteKeyEvent(updatedKey, omKeyInfoOld, fileSizeCountMap);
                                FileSizeCountTaskHelper.handlePutKeyEvent(omKeyInfo, fileSizeCountMap);
                                break;
                            }
                            LOG.warn("Update event does not have the old keyInfo for {}.", (Object)updatedKey);
                            break;
                        }
                        default: {
                            LOG.trace("Skipping DB update event: {}", (Object)omdbUpdateEvent.getAction());
                            break;
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    LOG.error("Unexpected exception while processing key {}.", (Object)updatedKey, (Object)e);
                    return FileSizeCountTaskHelper.buildTaskResult(taskName, false);
                }
            }
            LOG.warn("Unexpected value type {} for key {}. Skipping processing.", (Object)value.getClass().getName(), (Object)updatedKey);
        }
        FileSizeCountTaskHelper.writeCountsToDB(fileSizeCountMap, dslContext, fileCountBySizeDao);
        LOG.debug("{} successfully processed in {} milliseconds", (Object)taskName, (Object)(System.currentTimeMillis() - startTime));
        return FileSizeCountTaskHelper.buildTaskResult(taskName, true);
    }

    public static void writeCountsToDB(Map<FileSizeCountKey, Long> fileSizeCountMap, DSLContext dslContext, FileCountBySizeDao fileCountBySizeDao) {
        ArrayList insertToDb = new ArrayList();
        ArrayList updateInDb = new ArrayList();
        boolean isDbTruncated = FileSizeCountTaskHelper.isFileCountBySizeTableEmpty(dslContext);
        fileSizeCountMap.keySet().forEach(key -> {
            FileCountBySize newRecord = new FileCountBySize();
            newRecord.setVolume(((FileSizeCountKey)key).volume);
            newRecord.setBucket(((FileSizeCountKey)key).bucket);
            newRecord.setFileSize(((FileSizeCountKey)key).fileSizeUpperBound);
            newRecord.setCount((Long)fileSizeCountMap.get(key));
            if (!isDbTruncated) {
                Record3 recordToFind = dslContext.newRecord(FileCountBySizeTable.FILE_COUNT_BY_SIZE.VOLUME, FileCountBySizeTable.FILE_COUNT_BY_SIZE.BUCKET, FileCountBySizeTable.FILE_COUNT_BY_SIZE.FILE_SIZE).value1((Object)((FileSizeCountKey)key).volume).value2((Object)((FileSizeCountKey)key).bucket).value3((Object)((FileSizeCountKey)key).fileSizeUpperBound);
                FileCountBySize fileCountRecord = (FileCountBySize)fileCountBySizeDao.findById(recordToFind);
                if (fileCountRecord == null && newRecord.getCount() > 0L) {
                    insertToDb.add(newRecord);
                } else if (fileCountRecord != null) {
                    newRecord.setCount(fileCountRecord.getCount() + (Long)fileSizeCountMap.get(key));
                    updateInDb.add(newRecord);
                }
            } else if (newRecord.getCount() > 0L) {
                insertToDb.add(newRecord);
            }
        });
        fileCountBySizeDao.insert(insertToDb);
        fileCountBySizeDao.update(updateInDb);
    }

    public static void handlePutKeyEvent(OmKeyInfo omKeyInfo, Map<FileSizeCountKey, Long> fileSizeCountMap) {
        FileSizeCountKey key = FileSizeCountTaskHelper.getFileSizeCountKey(omKeyInfo);
        Long count = fileSizeCountMap.containsKey(key) ? fileSizeCountMap.get(key) + 1L : 1L;
        fileSizeCountMap.put(key, count);
    }

    public static void handleDeleteKeyEvent(String key, OmKeyInfo omKeyInfo, Map<FileSizeCountKey, Long> fileSizeCountMap) {
        if (omKeyInfo == null) {
            LOG.warn("Deleting a key not found while handling DELETE key event. Key not found in Recon OM DB: {}", (Object)key);
        } else {
            FileSizeCountKey countKey = FileSizeCountTaskHelper.getFileSizeCountKey(omKeyInfo);
            Long count = fileSizeCountMap.containsKey(countKey) ? fileSizeCountMap.get(countKey) - 1L : -1L;
            fileSizeCountMap.put(countKey, count);
        }
    }

    public static FileSizeCountKey getFileSizeCountKey(OmKeyInfo omKeyInfo) {
        return new FileSizeCountKey(omKeyInfo.getVolumeName(), omKeyInfo.getBucketName(), ReconUtils.getFileSizeUpperBound(omKeyInfo.getDataSize()));
    }

    public static boolean isFileCountBySizeTableEmpty(DSLContext dslContext) {
        return dslContext.fetchCount((org.jooq.Table)FileCountBySizeTable.FILE_COUNT_BY_SIZE) == 0;
    }

    public static ReconOmTask.TaskResult buildTaskResult(String taskName, boolean success) {
        return new ReconOmTask.TaskResult.Builder().setTaskName(taskName).setTaskSuccess(success).build();
    }

    public static class FileSizeCountKey {
        private final String volume;
        private final String bucket;
        private final Long fileSizeUpperBound;

        public FileSizeCountKey(String volume, String bucket, Long fileSizeUpperBound) {
            this.volume = volume;
            this.bucket = bucket;
            this.fileSizeUpperBound = fileSizeUpperBound;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileSizeCountKey) {
                FileSizeCountKey other = (FileSizeCountKey)obj;
                return this.volume.equals(other.volume) && this.bucket.equals(other.bucket) && this.fileSizeUpperBound.equals(other.fileSizeUpperBound);
            }
            return false;
        }

        public int hashCode() {
            return (this.volume + this.bucket + this.fileSizeUpperBound).hashCode();
        }
    }
}

