/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.nssummary;

import org.apache.hadoop.hdds.cli.AdminSubcommand;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.MutableConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.server.http.HttpConfig;
import org.apache.hadoop.ozone.admin.OzoneAdmin;
import org.apache.hadoop.ozone.admin.nssummary.DiskUsageSubCommand;
import org.apache.hadoop.ozone.admin.nssummary.FileSizeDistSubCommand;
import org.apache.hadoop.ozone.admin.nssummary.QuotaUsageSubCommand;
import org.apache.hadoop.ozone.admin.nssummary.SummarySubCommand;
import picocli.CommandLine;

@CommandLine.Command(name="namespace", description={"Namespace Summary specific admin operations"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class, subcommands={SummarySubCommand.class, DiskUsageSubCommand.class, QuotaUsageSubCommand.class, FileSizeDistSubCommand.class})
public class NSSummaryAdmin
implements AdminSubcommand {
    @CommandLine.ParentCommand
    private OzoneAdmin parent;

    private String getHostOnly(String host) {
        return host.split(":", 2)[0];
    }

    private String getPort(String host) {
        return host.split(":", 2)[1];
    }

    public String getReconWebAddress() {
        boolean isHostDefault;
        String host;
        String protocol;
        OzoneConfiguration conf = this.parent.getOzoneConf();
        HttpConfig.Policy webPolicy = HttpConfig.getHttpPolicy((MutableConfigurationSource)conf);
        if (webPolicy.isHttpsEnabled()) {
            protocol = "https";
            host = conf.get("ozone.recon.https-address", "0.0.0.0:9889");
            isHostDefault = this.getHostOnly(host).equals(this.getHostOnly("0.0.0.0:9889"));
        } else {
            protocol = "http";
            host = conf.get("ozone.recon.http-address", "0.0.0.0:9888");
            isHostDefault = this.getHostOnly(host).equals(this.getHostOnly("0.0.0.0:9888"));
        }
        if (isHostDefault) {
            String rpcHost = conf.get("ozone.recon.address", "0.0.0.0:9891");
            host = this.getHostOnly(rpcHost) + ":" + this.getPort(host);
        }
        return protocol + "://" + host;
    }

    public boolean isHTTPSEnabled() {
        OzoneConfiguration conf = this.parent.getOzoneConf();
        return HttpConfig.getHttpPolicy((MutableConfigurationSource)conf) == HttpConfig.Policy.HTTPS_ONLY;
    }

    public ConfigurationSource getOzoneConfig() {
        return this.parent.getOzoneConf();
    }
}

