/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.admin.scm;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmOption;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.apache.hadoop.ozone.admin.scm.ScmAdmin;
import picocli.CommandLine;

@CommandLine.Command(name="transfer", description={"Manually transfer the raft leadership to the target node."}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class TransferScmLeaderSubCommand
implements Callable<Void> {
    @CommandLine.ParentCommand
    private ScmAdmin parent;
    @CommandLine.Mixin
    private ScmOption scmOption;
    @CommandLine.ArgGroup(multiplicity="1")
    private TransferOption configGroup;

    @Override
    public Void call() throws Exception {
        ScmClient client = this.scmOption.createScmClient(this.parent.getParent().getOzoneConf());
        if (this.configGroup.isRandom) {
            this.configGroup.scmId = "";
        }
        client.transferLeadership(this.configGroup.scmId);
        System.out.println("Transfer leadership successfully to " + (this.configGroup.isRandom ? "random node" : this.configGroup.scmId) + ".");
        return null;
    }

    static class TransferOption {
        @CommandLine.Option(names={"-n", "--newLeaderId", "--new-leader-id"}, description={"The new leader id of SCM to transfer leadership. Should be ScmId(UUID)."})
        private String scmId;
        @CommandLine.Option(names={"-r", "--random"}, description={"Randomly choose a follower to transfer leadership."})
        private boolean isRandom;

        TransferOption() {
        }
    }
}

