/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.audit.parser.handler;

import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.ozone.debug.audit.parser.AuditParser;
import org.apache.hadoop.ozone.debug.audit.parser.common.DatabaseHelper;
import picocli.CommandLine;

@CommandLine.Command(name="load", aliases={"l"}, description={"Load ozone audit log files.\n\nTo load an audit log to database:\nozone debug auditparser <path to db file> load <logs>\n"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class LoadCommandHandler
implements Callable<Void> {
    @CommandLine.Parameters(arity="1..1", description={"Audit Log file(s)"})
    private String logs;
    @CommandLine.ParentCommand
    private AuditParser auditParser;

    @Override
    public Void call() throws Exception {
        if (DatabaseHelper.setup(this.auditParser.getDatabase(), this.logs)) {
            System.out.println(this.logs + " has been loaded successfully");
        } else {
            System.out.println("Failed to load " + this.logs);
        }
        return null;
    }
}

