/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.debug.ldb;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hdds.cli.AbstractSubcommand;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.FixedLengthStringCodec;
import org.apache.hadoop.hdds.utils.db.LongCodec;
import org.apache.hadoop.hdds.utils.db.managed.ManagedReadOptions;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksDB;
import org.apache.hadoop.hdds.utils.db.managed.ManagedRocksIterator;
import org.apache.hadoop.hdds.utils.db.managed.ManagedSlice;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.metadata.DatanodeSchemaThreeDBDefinition;
import org.apache.hadoop.ozone.debug.DBDefinitionFactory;
import org.apache.hadoop.ozone.debug.RocksDBUtils;
import org.apache.hadoop.ozone.debug.ldb.RDBParser;
import org.apache.hadoop.ozone.debug.ldb.ValueSchema;
import org.apache.hadoop.ozone.utils.Filter;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="scan", description={"Parse specified metadataTable"})
public class DBScanner
extends AbstractSubcommand
implements Callable<Void> {
    public static final Logger LOG = LoggerFactory.getLogger(DBScanner.class);
    private static final String SCHEMA_V3 = "V3";
    @CommandLine.ParentCommand
    private RDBParser parent;
    @CommandLine.Option(names={"--column_family", "--column-family", "--cf"}, required=true, description={"Table name"})
    private String tableName;
    @CommandLine.Option(names={"--with-keys"}, description={"Print a JSON object of key->value pairs (default) instead of a JSON array of only values."}, defaultValue="true", fallbackValue="true")
    private boolean withKey;
    @CommandLine.Option(names={"--length", "--limit", "-l"}, description={"Maximum number of items to list."}, defaultValue="-1")
    private long limit;
    @CommandLine.Option(names={"--out", "-o"}, description={"File to dump table scan data"})
    private String fileName;
    @CommandLine.Option(names={"--startkey", "--sk", "-s"}, description={"Key from which to iterate the DB"})
    private String startKey;
    @CommandLine.Option(names={"--endkey", "--ek", "-e"}, description={"Key at which iteration of the DB ends"})
    private String endKey;
    @CommandLine.Option(names={"--fields"}, description={"Comma-separated list of fields needed for each value. eg.) \"name,acls.type\" for showing name and type under acls."})
    private String fieldsFilter;
    @CommandLine.Option(names={"--filter"}, description={"Comma-separated list of \"<field>:<operator>:<value>\" where <field> is any valid field of the record, <operator> is [EQUALS,LESSER, GREATER or REGEX]. (EQUALS compares the exact string, REGEX compares with a valid regular expression passed, and LESSER/GREATER works with numeric values), <value> is the value of the field. \neg.) \"dataSize:equals:1000\" for showing records having the value 1000 for dataSize, \n     \"keyName:regex:^key.*$\" for showing records having keyName that matches the given regex."})
    private String filter;
    @CommandLine.Option(names={"--dnSchema", "--dn-schema", "-d"}, description={"Datanode DB Schema Version: V1/V2/V3"}, defaultValue="V3")
    private String dnDBSchemaVersion;
    @CommandLine.Option(names={"--container-id", "--cid"}, description={"Container ID. Applicable if datanode DB Schema is V3"}, defaultValue="-1")
    private long containerId;
    @CommandLine.Option(names={"--show-count", "--count"}, description={"Get estimated key count for the given DB column family"}, defaultValue="false", showDefaultValue=CommandLine.Help.Visibility.ALWAYS)
    private boolean showCount;
    @CommandLine.Option(names={"--compact"}, description={"disable the pretty print the output"}, defaultValue="false")
    private static boolean compact;
    @CommandLine.Option(names={"--batch-size"}, description={"Batch size for processing DB data."}, defaultValue="10000")
    private int batchSize;
    @CommandLine.Option(names={"--thread-count"}, description={"Thread count for concurrent processing."}, defaultValue="10")
    private int threadCount;
    @CommandLine.Option(names={"--max-records-per-file"}, description={"The number of records to print per file."}, defaultValue="0")
    private long recordsPerFile;
    private int fileSuffix = 0;
    private long globalCount = 0L;
    private static final String KEY_SEPARATOR_SCHEMA_V3;
    private static volatile boolean exception;
    private static final long FIRST_SEQUENCE_ID = 0L;

    @Override
    public Void call() throws Exception {
        boolean success;
        this.fileSuffix = 0;
        this.globalCount = 0L;
        List<ColumnFamilyDescriptor> cfDescList = RocksDBUtils.getColumnFamilyDescriptors(this.parent.getDbPath());
        ArrayList<ColumnFamilyHandle> cfHandleList = new ArrayList<ColumnFamilyHandle>();
        boolean schemaV3 = this.dnDBSchemaVersion != null && this.dnDBSchemaVersion.equalsIgnoreCase(SCHEMA_V3) && this.parent.getDbPath().contains("container.db");
        try (ManagedRocksDB db = ManagedRocksDB.openReadOnly((String)this.parent.getDbPath(), cfDescList, cfHandleList);){
            success = this.printTable(cfHandleList, db, this.parent.getDbPath(), schemaV3);
        }
        if (!success) {
            throw new Exception("Exit code is non-zero. Check the error message above");
        }
        return null;
    }

    public byte[] getValueObject(DBColumnFamilyDefinition dbColumnFamilyDefinition, String key) {
        Class keyType = dbColumnFamilyDefinition.getKeyType();
        if (keyType.equals(String.class)) {
            return key.getBytes(StandardCharsets.UTF_8);
        }
        if (keyType.equals(ContainerID.class)) {
            return ContainerID.getBytes((long)Long.parseLong(key));
        }
        if (keyType.equals(Long.class)) {
            return LongCodec.get().toPersistedFormat(Long.valueOf(Long.parseLong(key)));
        }
        if (keyType.equals(PipelineID.class)) {
            return PipelineID.valueOf((UUID)UUID.fromString(key)).getProtobuf().toByteArray();
        }
        throw new IllegalArgumentException("StartKey and EndKey is not supported for this table.");
    }

    private boolean displayTable(ManagedRocksIterator iterator, DBColumnFamilyDefinition dbColumnFamilyDef, boolean schemaV3) throws IOException {
        boolean flg;
        if (this.fileName == null) {
            return this.displayTable(iterator, dbColumnFamilyDef, this.out(), schemaV3);
        }
        File file = new File(this.fileName);
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !(flg = parentFile.mkdirs())) {
            throw new IOException("An exception occurred while creating the directory. Directorys: " + parentFile.getAbsolutePath());
        }
        while (((RocksIterator)iterator.get()).isValid() && this.withinLimit(this.globalCount)) {
            String fileNameTarget = this.recordsPerFile > 0L ? this.fileName + "." + this.fileSuffix++ : this.fileName;
            PrintWriter out = new PrintWriter(new BufferedWriter(new PrintWriter(fileNameTarget, StandardCharsets.UTF_8.name())));
            Throwable throwable = null;
            try {
                if (this.displayTable(iterator, dbColumnFamilyDef, out, schemaV3)) continue;
                boolean bl = false;
                return bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean displayTable(ManagedRocksIterator iterator, DBColumnFamilyDefinition dbColumnFamilyDef, PrintWriter printWriter, boolean schemaV3) {
        exception = false;
        ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("DBScanner-%d").build();
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(this.threadCount, this.threadCount, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1024), factory, new ThreadPoolExecutor.CallerRunsPolicy());
        LogWriter logWriter = new LogWriter(printWriter);
        try {
            printWriter.print(this.withKey ? "{ " : "[ ");
            logWriter.start();
            this.processRecords(iterator, dbColumnFamilyDef, logWriter, threadPool, schemaV3);
            threadPool.shutdownNow();
        }
        catch (IOException | InterruptedException e) {
            try {
                exception = true;
                Thread.currentThread().interrupt();
                threadPool.shutdownNow();
            }
            catch (Throwable throwable) {
                threadPool.shutdownNow();
                logWriter.stop();
                logWriter.join();
                printWriter.println(this.withKey ? " }" : " ]");
                throw throwable;
            }
            logWriter.stop();
            logWriter.join();
            printWriter.println(this.withKey ? " }" : " ]");
        }
        logWriter.stop();
        logWriter.join();
        printWriter.println(this.withKey ? " }" : " ]");
        return !exception;
    }

    private void processRecords(ManagedRocksIterator iterator, DBColumnFamilyDefinition dbColumnFamilyDef, LogWriter logWriter, ExecutorService threadPool, boolean schemaV3) throws InterruptedException, IOException {
        if (this.startKey != null) {
            ((RocksIterator)iterator.get()).seek(this.getValueObject(dbColumnFamilyDef, this.startKey));
        }
        ArrayList<ByteArrayKeyValue> batch = new ArrayList<ByteArrayKeyValue>(this.batchSize);
        long sequenceId = 0L;
        long count = 0L;
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        boolean reachedEnd = false;
        HashMap<String, Filter> fieldsFilterSplitMap = new HashMap<String, Filter>();
        if (this.filter != null) {
            for (String field : this.filter.split(",")) {
                String[] fieldValue = field.split(":");
                if (fieldValue.length != 3) {
                    this.err().println("Error: Invalid format for filter \"" + (String)field + "\". Usage: <field>:<operator>:<value>. Ignoring filter passed");
                    continue;
                }
                Filter filterValue = new Filter(fieldValue[1], (Object)fieldValue[2]);
                if (filterValue.getOperator() == null) {
                    this.err().println("Error: Invalid operator for filter \"" + filterValue + "\". <operator> can be one of [EQUALS,LESSER,GREATER]. Ignoring filter passed");
                    continue;
                }
                String[] subfields = fieldValue[0].split("\\.");
                this.getFilterSplit(Arrays.asList(subfields), fieldsFilterSplitMap, filterValue);
            }
        }
        while (this.withinLimit(this.globalCount) && ((RocksIterator)iterator.get()).isValid() && !exception && !reachedEnd) {
            if (null != this.endKey && Arrays.equals(((RocksIterator)iterator.get()).key(), this.getValueObject(dbColumnFamilyDef, this.endKey))) {
                reachedEnd = true;
            }
            Object o = dbColumnFamilyDef.getValueCodec().fromPersistedFormat(((RocksIterator)iterator.get()).value());
            if (this.filter == null || this.checkFilteredObject(o, dbColumnFamilyDef.getValueType(), fieldsFilterSplitMap)) {
                batch.add(new ByteArrayKeyValue(((RocksIterator)iterator.get()).key(), ((RocksIterator)iterator.get()).value()));
                ++this.globalCount;
                ++count;
                if (batch.size() >= this.batchSize) {
                    while (logWriter.getInflightLogCount() > (long)this.threadCount * 10L && !exception) {
                        Thread.sleep(100L);
                    }
                    Future<Void> future = threadPool.submit(new Task(dbColumnFamilyDef, batch, logWriter, sequenceId, this.withKey, schemaV3, this.fieldsFilter));
                    futures.add(future);
                    batch = new ArrayList(this.batchSize);
                    ++sequenceId;
                }
            }
            ((RocksIterator)iterator.get()).next();
            if (this.recordsPerFile <= 0L || count < this.recordsPerFile) continue;
            break;
        }
        if (!batch.isEmpty()) {
            Future<Void> future = threadPool.submit(new Task(dbColumnFamilyDef, batch, logWriter, sequenceId, this.withKey, schemaV3, this.fieldsFilter));
            futures.add(future);
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                LOG.error("Task execution failed", (Throwable)e);
            }
        }
    }

    private void getFilterSplit(List<String> fields, Map<String, Filter> fieldMap, Filter leafValue) throws IOException {
        int len = fields.size();
        if (len == 1) {
            Filter currentValue = fieldMap.get(fields.get(0));
            if (currentValue != null) {
                this.err().println("Cannot pass multiple values for the same field and cannot have filter for both parent and child");
                throw new IOException("Invalid filter passed");
            }
            fieldMap.put(fields.get(0), leafValue);
        } else {
            Filter fieldMapGet = fieldMap.computeIfAbsent(fields.get(0), k -> new Filter());
            if (fieldMapGet.getValue() != null) {
                this.err().println("Cannot pass multiple values for the same field and cannot have filter for both parent and child");
                throw new IOException("Invalid filter passed");
            }
            Map<String, Filter> nextLevel = fieldMapGet.getNextLevel();
            if (nextLevel == null) {
                fieldMapGet.setNextLevel(new HashMap<String, Filter>());
            }
            this.getFilterSplit(fields.subList(1, len), fieldMapGet.getNextLevel(), leafValue);
        }
    }

    private boolean checkFilteredObject(Object obj, Class<?> clazz, Map<String, Filter> fieldsSplitMap) {
        block12: for (Map.Entry<String, Filter> field : fieldsSplitMap.entrySet()) {
            try {
                Field valueClassField = this.getRequiredFieldFromAllFields(clazz, field.getKey());
                Object valueObject = valueClassField.get(obj);
                Filter fieldValue = field.getValue();
                if (valueObject == null) continue;
                if (fieldValue == null) {
                    this.err().println("Malformed filter. Check input");
                    throw new IOException("Invalid filter passed");
                }
                if (fieldValue.getNextLevel() == null) {
                    try {
                        switch (fieldValue.getOperator()) {
                            case EQUALS: {
                                if (String.valueOf(valueObject).equals(fieldValue.getValue())) continue block12;
                                return false;
                            }
                            case GREATER: {
                                if (!(Double.parseDouble(String.valueOf(valueObject)) < Double.parseDouble(String.valueOf(fieldValue.getValue())))) continue block12;
                                return false;
                            }
                            case LESSER: {
                                if (!(Double.parseDouble(String.valueOf(valueObject)) > Double.parseDouble(String.valueOf(fieldValue.getValue())))) continue block12;
                                return false;
                            }
                            case REGEX: {
                                Pattern p = Pattern.compile(String.valueOf(fieldValue.getValue()));
                                Matcher m = p.matcher(String.valueOf(valueObject));
                                if (m.find()) continue block12;
                                return false;
                            }
                            default: {
                                this.err().println("Only EQUALS/LESSER/GREATER/REGEX operator is supported currently.");
                                throw new IOException("Invalid filter passed");
                            }
                        }
                    }
                    catch (NumberFormatException ex) {
                        this.err().println("LESSER or GREATER operation can be performed only on numeric values.");
                        throw new IOException("Invalid filter passed");
                    }
                }
                Map<String, Filter> subfields = fieldValue.getNextLevel();
                if (Collection.class.isAssignableFrom(valueObject.getClass())) {
                    if (this.checkFilteredObjectCollection((Collection)valueObject, subfields)) continue;
                    return false;
                }
                if (Map.class.isAssignableFrom(valueObject.getClass())) {
                    Map valueObjectMap = (Map)valueObject;
                    boolean flag = false;
                    for (Map.Entry ob : valueObjectMap.entrySet()) {
                        boolean subflag = Collection.class.isAssignableFrom(ob.getValue().getClass()) ? this.checkFilteredObjectCollection((Collection)ob.getValue(), subfields) : this.checkFilteredObject(ob.getValue(), ob.getValue().getClass(), subfields);
                        if (!subflag) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    return false;
                }
                if (this.checkFilteredObject(valueObject, valueClassField.getType(), subfields)) continue;
                return false;
            }
            catch (NoSuchFieldException ex) {
                this.err().println("ERROR: no such field: " + field);
                exception = true;
                return false;
            }
            catch (IllegalAccessException e) {
                this.err().println("ERROR: Cannot get field \"" + field + "\" from record.");
                exception = true;
                return false;
            }
            catch (Exception ex) {
                this.err().println("ERROR: field: " + field + ", ex: " + ex);
                exception = true;
                return false;
            }
        }
        return true;
    }

    private boolean checkFilteredObjectCollection(Collection<?> valueObject, Map<String, Filter> fields) throws NoSuchFieldException, IllegalAccessException, IOException {
        for (Object ob : valueObject) {
            if (!this.checkFilteredObject(ob, ob.getClass(), fields)) continue;
            return true;
        }
        return false;
    }

    Field getRequiredFieldFromAllFields(Class clazz, String fieldName) throws NoSuchFieldException {
        List<Field> classFieldList = ValueSchema.getAllFields(clazz);
        Field classField = null;
        for (Field f : classFieldList) {
            if (!f.getName().equals(fieldName)) continue;
            classField = f;
            break;
        }
        if (classField == null) {
            this.err().println("Error: Invalid field \"" + fieldName + "\" passed for filter");
            throw new NoSuchFieldException();
        }
        classField.setAccessible(true);
        return classField;
    }

    private boolean withinLimit(long i) {
        return this.limit == -1L || i < this.limit;
    }

    private ColumnFamilyHandle getColumnFamilyHandle(byte[] name, List<ColumnFamilyHandle> columnFamilyHandles) {
        return columnFamilyHandles.stream().filter(handle -> {
            try {
                return Arrays.equals(handle.getName(), name);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }).findAny().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean printTable(List<ColumnFamilyHandle> columnFamilyHandleList, ManagedRocksDB rocksDB, String dbPath, boolean schemaV3) throws IOException, RocksDBException {
        boolean bl;
        if (this.limit < 1L && this.limit != -1L) {
            throw new IllegalArgumentException("List length should be a positive number. Only allowed negative number is -1 which is to dump entire table");
        }
        dbPath = this.removeTrailingSlashIfNeeded(dbPath);
        DBDefinitionFactory.setDnDBSchemaVersion(this.dnDBSchemaVersion);
        DBDefinition dbDefinition = DBDefinitionFactory.getDefinition(Paths.get(dbPath, new String[0]), (ConfigurationSource)new OzoneConfiguration());
        if (dbDefinition == null) {
            this.err().println("Error: Incorrect DB Path");
            return false;
        }
        DBColumnFamilyDefinition columnFamilyDefinition = dbDefinition.getColumnFamily(this.tableName);
        if (columnFamilyDefinition == null) {
            this.err().print("Error: Table with name '" + this.tableName + "' not found");
            return false;
        }
        ColumnFamilyHandle columnFamilyHandle = this.getColumnFamilyHandle(columnFamilyDefinition.getName().getBytes(StandardCharsets.UTF_8), columnFamilyHandleList);
        if (columnFamilyHandle == null) {
            throw new IllegalStateException("columnFamilyHandle is null");
        }
        if (this.showCount) {
            long keyCount = ((RocksDB)rocksDB.get()).getLongProperty(columnFamilyHandle, "rocksdb.estimate-num-keys");
            this.out().println(keyCount);
            return true;
        }
        ManagedRocksIterator iterator = null;
        ManagedReadOptions readOptions = null;
        ManagedSlice slice = null;
        try {
            if (this.containerId > 0L && schemaV3) {
                readOptions = new ManagedReadOptions();
                slice = new ManagedSlice(DatanodeSchemaThreeDBDefinition.getContainerKeyPrefixBytes((long)(this.containerId + 1L)));
                readOptions.setIterateUpperBound((AbstractSlice)slice);
                iterator = new ManagedRocksIterator(((RocksDB)rocksDB.get()).newIterator(columnFamilyHandle, (ReadOptions)readOptions));
                ((RocksIterator)iterator.get()).seek(DatanodeSchemaThreeDBDefinition.getContainerKeyPrefixBytes((long)this.containerId));
            } else {
                iterator = new ManagedRocksIterator(((RocksDB)rocksDB.get()).newIterator(columnFamilyHandle));
                ((RocksIterator)iterator.get()).seekToFirst();
            }
            bl = this.displayTable(iterator, columnFamilyDefinition, schemaV3);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{iterator, readOptions, slice});
            throw throwable;
        }
        IOUtils.closeQuietly((AutoCloseable[])new AutoCloseable[]{iterator, readOptions, slice});
        return bl;
    }

    private String removeTrailingSlashIfNeeded(String dbPath) {
        if (dbPath.endsWith("/")) {
            dbPath = dbPath.substring(0, dbPath.length() - 1);
        }
        return dbPath;
    }

    static /* synthetic */ boolean access$000() {
        return compact;
    }

    static {
        KEY_SEPARATOR_SCHEMA_V3 = ((DatanodeConfiguration)new OzoneConfiguration().getObject(DatanodeConfiguration.class)).getContainerSchemaV3KeySeparator();
    }

    private static class LogWriter {
        private final Map<Long, ArrayList<String>> logs;
        private final PrintWriter printWriter;
        private final Thread writerThread;
        private volatile boolean stop = false;
        private long expectedSequenceId = 0L;
        private final Object lock = new Object();
        private final AtomicLong inflightLogCount = new AtomicLong();

        LogWriter(PrintWriter printWriter) {
            this.logs = new HashMap<Long, ArrayList<String>>();
            this.printWriter = printWriter;
            this.writerThread = new Thread(new WriterTask());
        }

        void start() {
            this.writerThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void log(ArrayList<String> msg, long sequenceId) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.stop) {
                    this.logs.put(sequenceId, msg);
                    this.inflightLogCount.incrementAndGet();
                    this.lock.notify();
                }
            }
        }

        private void drainRemainingMessages() {
            ArrayList<String> results;
            while ((results = this.logs.get(this.expectedSequenceId)) != null) {
                for (String result : results) {
                    this.printWriter.println(result);
                }
                ++this.expectedSequenceId;
            }
        }

        public void stop() {
            if (!this.stop) {
                this.stop = true;
                this.writerThread.interrupt();
            }
        }

        public void join() {
            try {
                this.writerThread.join();
            }
            catch (InterruptedException e) {
                LOG.error("InterruptedException while output", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }

        public long getInflightLogCount() {
            return this.inflightLogCount.get();
        }

        private final class WriterTask
        implements Runnable {
            private WriterTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (!LogWriter.this.stop) {
                        Object object = LogWriter.this.lock;
                        synchronized (object) {
                            ArrayList results = (ArrayList)LogWriter.this.logs.get(LogWriter.this.expectedSequenceId);
                            if (results != null) {
                                for (String result : results) {
                                    LogWriter.this.printWriter.println(result);
                                }
                                LogWriter.this.inflightLogCount.decrementAndGet();
                                LogWriter.this.logs.remove(LogWriter.this.expectedSequenceId);
                                LogWriter.this.expectedSequenceId++;
                            } else {
                                LogWriter.this.lock.wait(1000L);
                            }
                        }
                    }
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (Exception e) {
                    LOG.error("Exception while output", (Throwable)e);
                    return;
                }
                finally {
                    LogWriter.this.stop = true;
                    Object e = LogWriter.this.lock;
                    synchronized (e) {
                        LogWriter.this.drainRemainingMessages();
                    }
                }
            }
        }
    }

    private static class ByteArrayKeyValue {
        private final byte[] key;
        private final byte[] value;

        ByteArrayKeyValue(byte[] key, byte[] value) {
            this.key = key;
            this.value = value;
        }

        public byte[] getKey() {
            return this.key;
        }

        public byte[] getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteArrayKeyValue that = (ByteArrayKeyValue)o;
            return Arrays.equals(this.key, that.key);
        }

        public int hashCode() {
            return Arrays.hashCode(this.key);
        }

        public String toString() {
            return "ByteArrayKeyValue{key=" + Arrays.toString(this.key) + ", value=" + Arrays.toString(this.value) + '}';
        }
    }

    private class Task
    implements Callable<Void> {
        private final DBColumnFamilyDefinition dbColumnFamilyDefinition;
        private final ArrayList<ByteArrayKeyValue> batch;
        private final LogWriter logWriter;
        private final ObjectWriter writer = JsonSerializationHelper.getWriter();
        private final long sequenceId;
        private final boolean withKey;
        private final boolean schemaV3;
        private String valueFields;

        Task(DBColumnFamilyDefinition dbColumnFamilyDefinition, ArrayList<ByteArrayKeyValue> batch, LogWriter logWriter, long sequenceId, boolean withKey, boolean schemaV3, String valueFields) {
            this.dbColumnFamilyDefinition = dbColumnFamilyDefinition;
            this.batch = batch;
            this.logWriter = logWriter;
            this.sequenceId = sequenceId;
            this.withKey = withKey;
            this.schemaV3 = schemaV3;
            this.valueFields = valueFields;
        }

        Map<String, Object> getFieldSplit(List<String> fields, Map<String, Object> fieldMap) {
            int len = fields.size();
            if (fieldMap == null) {
                fieldMap = new HashMap<String, Object>();
            }
            if (len == 1) {
                fieldMap.putIfAbsent(fields.get(0), null);
            } else {
                Map fieldMapGet = (Map)fieldMap.get(fields.get(0));
                if (fieldMapGet == null) {
                    fieldMap.put(fields.get(0), this.getFieldSplit(fields.subList(1, len), null));
                } else {
                    fieldMap.put(fields.get(0), this.getFieldSplit(fields.subList(1, len), fieldMapGet));
                }
            }
            return fieldMap;
        }

        @Override
        public Void call() {
            try {
                ArrayList<String> results = new ArrayList<String>(this.batch.size());
                Map<String, Object> fieldsSplitMap = new HashMap<String, Object>();
                if (this.valueFields != null) {
                    for (String field : this.valueFields.split(",")) {
                        String[] subfields = field.split("\\.");
                        fieldsSplitMap = this.getFieldSplit(Arrays.asList(subfields), fieldsSplitMap);
                    }
                }
                for (ByteArrayKeyValue byteArrayKeyValue : this.batch) {
                    StringBuilder sb = new StringBuilder();
                    if (this.sequenceId != 0L || !results.isEmpty()) {
                        sb.append(", ");
                    }
                    if (this.withKey) {
                        Object key = this.dbColumnFamilyDefinition.getKeyCodec().fromPersistedFormat(byteArrayKeyValue.getKey());
                        if (this.schemaV3) {
                            String keyStr;
                            int index = DatanodeSchemaThreeDBDefinition.getContainerKeyPrefixLength();
                            if (index > (keyStr = key.toString()).length()) {
                                DBScanner.this.err().println("Error: Invalid SchemaV3 table key length. Is this a V2 table? Try again with --dn-schema=V2");
                                exception = true;
                                break;
                            }
                            String cid = key.toString().substring(0, index);
                            String blockId = key.toString().substring(index);
                            sb.append(this.writer.writeValueAsString((Object)(LongCodec.get().fromPersistedFormat(FixedLengthStringCodec.string2Bytes((String)cid)) + KEY_SEPARATOR_SCHEMA_V3 + blockId)));
                        } else {
                            sb.append(this.writer.writeValueAsString(key));
                        }
                        sb.append(": ");
                    }
                    Object o = this.dbColumnFamilyDefinition.getValueCodec().fromPersistedFormat(byteArrayKeyValue.getValue());
                    if (this.valueFields != null) {
                        HashMap<String, Object> filteredValue = new HashMap<String, Object>();
                        filteredValue.putAll(this.getFieldsFilteredObject(o, this.dbColumnFamilyDefinition.getValueType(), fieldsSplitMap));
                        sb.append(this.writer.writeValueAsString(filteredValue));
                    } else {
                        sb.append(this.writer.writeValueAsString(o));
                    }
                    results.add(sb.toString());
                }
                this.logWriter.log(results, this.sequenceId);
            }
            catch (IOException e) {
                exception = true;
                LOG.error("Exception parse Object", (Throwable)e);
            }
            return null;
        }

        Map<String, Object> getFieldsFilteredObject(Object obj, Class<?> clazz, Map<String, Object> fieldsSplitMap) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> field : fieldsSplitMap.entrySet()) {
                try {
                    Field valueClassField = DBScanner.this.getRequiredFieldFromAllFields(clazz, field.getKey());
                    Object valueObject = valueClassField.get(obj);
                    Map subfields = (Map)field.getValue();
                    if (subfields == null) {
                        valueMap.put(field.getKey(), valueObject);
                        continue;
                    }
                    if (Collection.class.isAssignableFrom(valueObject.getClass())) {
                        List<Object> subfieldObjectsList = this.getFieldsFilteredObjectCollection((Collection)valueObject, subfields);
                        valueMap.put(field.getKey(), subfieldObjectsList);
                        continue;
                    }
                    if (Map.class.isAssignableFrom(valueObject.getClass())) {
                        HashMap subfieldObjectsMap = new HashMap();
                        Map valueObjectMap = (Map)valueObject;
                        for (Map.Entry ob : valueObjectMap.entrySet()) {
                            Object subfieldValue = Collection.class.isAssignableFrom(ob.getValue().getClass()) ? this.getFieldsFilteredObjectCollection((Collection)ob.getValue(), subfields) : this.getFieldsFilteredObject(ob.getValue(), ob.getValue().getClass(), subfields);
                            subfieldObjectsMap.put(ob.getKey(), subfieldValue);
                        }
                        valueMap.put(field.getKey(), subfieldObjectsMap);
                        continue;
                    }
                    valueMap.put(field.getKey(), this.getFieldsFilteredObject(valueObject, valueClassField.getType(), subfields));
                }
                catch (NoSuchFieldException ex) {
                    DBScanner.this.err().println("ERROR: no such field: " + field);
                }
                catch (IllegalAccessException e) {
                    DBScanner.this.err().println("ERROR: Cannot get field from object: " + field);
                }
            }
            return valueMap;
        }

        List<Object> getFieldsFilteredObjectCollection(Collection<?> valueObject, Map<String, Object> fields) throws NoSuchFieldException, IllegalAccessException {
            ArrayList<Object> subfieldObjectsList = new ArrayList<Object>();
            for (Object ob : valueObject) {
                Map<String, Object> subfieldValue = this.getFieldsFilteredObject(ob, ob.getClass(), fields);
                subfieldObjectsList.add(subfieldValue);
            }
            return subfieldObjectsList;
        }
    }

    @VisibleForTesting
    public static class JsonSerializationHelper {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).setVisibility(PropertyAccessor.GETTER, JsonAutoDetect.Visibility.NONE).setVisibility(PropertyAccessor.IS_GETTER, JsonAutoDetect.Visibility.NONE).setSerializationInclusion(JsonInclude.Include.NON_NULL).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        public static final ObjectWriter WRITER = DBScanner.access$000() ? OBJECT_MAPPER.writer() : OBJECT_MAPPER.writerWithDefaultPrettyPrinter();

        public static ObjectWriter getWriter() {
            return WRITER;
        }
    }
}

