/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.freon;

import com.codahale.metrics.Timer;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.StorageSize;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneClient;
import org.apache.hadoop.ozone.client.io.OzoneDataStreamOutput;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.freon.BaseFreonGenerator;
import org.apache.hadoop.ozone.freon.ContentGenerator;
import org.apache.hadoop.ozone.freon.FreonReplicationOptions;
import org.apache.hadoop.ozone.freon.StorageSizeConverter;
import picocli.CommandLine;

@CommandLine.Command(name="ockg", aliases={"ozone-client-key-generator"}, description={"Generate keys with the help of the ozone clients."}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true, showDefaultValues=true)
public class OzoneClientKeyGenerator
extends BaseFreonGenerator
implements Callable<Void> {
    @CommandLine.Option(names={"-v", "--volume"}, description={"Name of the volume which contains the test data. Will be created if missing."}, defaultValue="vol1")
    private String volumeName;
    @CommandLine.Option(names={"-b", "--bucket"}, description={"Name of the bucket which contains the test data. Will be created if missing."}, defaultValue="bucket1")
    private String bucketName;
    @CommandLine.Option(names={"-s", "--size"}, description={"Size of the generated key. You can specify the size using data units like 'GB', 'MB', 'KB', etc. Size is in base 2 binary."}, defaultValue="10KB", converter={StorageSizeConverter.class})
    private StorageSize keySize;
    @CommandLine.Option(names={"--buffer"}, description={"Size of buffer used to generated the key content."}, defaultValue="4096")
    private int bufferSize;
    @CommandLine.Option(names={"--om-service-id"}, description={"OM Service ID"})
    private String omServiceID;
    @CommandLine.Mixin
    private FreonReplicationOptions replication;
    @CommandLine.Option(names={"--enable-streaming", "--stream"}, description={"Specify whether the write will be through ratis streaming"})
    private boolean enableRatisStreaming = false;
    private Timer timer;
    private OzoneBucket bucket;
    private ContentGenerator contentGenerator;
    private Map<String, String> metadata;
    private ReplicationConfig replicationConfig;

    @Override
    public Void call() throws Exception {
        this.init();
        OzoneConfiguration ozoneConfiguration = this.createOzoneConfiguration();
        this.contentGenerator = new ContentGenerator(this.keySize.toBytes(), this.bufferSize);
        this.metadata = new HashMap<String, String>();
        this.replicationConfig = this.replication.fromParamsOrConfig((ConfigurationSource)ozoneConfiguration);
        try (OzoneClient rpcClient = this.createOzoneClient(this.omServiceID, ozoneConfiguration);){
            this.ensureVolumeAndBucketExist(rpcClient, this.volumeName, this.bucketName);
            this.bucket = rpcClient.getObjectStore().getVolume(this.volumeName).getBucket(this.bucketName);
            this.timer = this.getMetrics().timer("key-create");
            if (this.enableRatisStreaming) {
                this.runTests(this::createStreamKey);
            } else {
                this.runTests(this::createKey);
            }
        }
        return null;
    }

    private void createKey(long counter) throws Exception {
        String key = this.generateObjectName(counter);
        this.timer.time(() -> {
            try (OzoneOutputStream stream = this.bucket.createKey(key, this.keySize.toBytes(), this.replicationConfig, this.metadata);){
                this.contentGenerator.write((OutputStream)stream);
                stream.flush();
            }
            return null;
        });
    }

    private void createStreamKey(long counter) throws Exception {
        ReplicationConfig conf = ReplicationConfig.fromProtoTypeAndFactor((HddsProtos.ReplicationType)HddsProtos.ReplicationType.RATIS, (HddsProtos.ReplicationFactor)HddsProtos.ReplicationFactor.THREE);
        String key = this.generateObjectName(counter);
        this.timer.time(() -> {
            try (OzoneDataStreamOutput stream = this.bucket.createStreamKey(key, this.keySize.toBytes(), conf, this.metadata);){
                this.contentGenerator.write(stream);
            }
            return null;
        });
    }
}

