/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ByteBufferReadable;
import org.apache.hadoop.hdds.scm.storage.ByteReaderStrategy;

public class ByteBufferReader
implements ByteReaderStrategy {
    private final ByteBuffer readBuf;
    private int targetLen;

    public ByteBufferReader(ByteBuffer buf) {
        if (buf == null) {
            throw new NullPointerException();
        }
        this.readBuf = buf;
        this.targetLen = buf.remaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readFromBlock(InputStream is, int numBytesToRead) throws IOException {
        int numBytesRead;
        Preconditions.checkArgument((is != null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)(is instanceof ByteBufferReadable));
        int bufferLimit = this.readBuf.limit();
        if (numBytesToRead < this.targetLen) {
            this.readBuf.limit(this.readBuf.position() + numBytesToRead);
        }
        try {
            numBytesRead = ((ByteBufferReadable)is).read(this.readBuf);
        }
        finally {
            if (numBytesToRead < this.targetLen) {
                this.readBuf.limit(bufferLimit);
            }
        }
        this.targetLen -= numBytesRead;
        return numBytesRead;
    }

    @Override
    public int getTargetLength() {
        return this.targetLen;
    }
}

