/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.storage.AbstractCommitWatcher;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.ozone.common.ChunkBuffer;

class CommitWatcher
extends AbstractCommitWatcher<ChunkBuffer> {
    private final BufferPool bufferPool;

    CommitWatcher(BufferPool bufferPool, XceiverClientSpi xceiverClient) {
        super(xceiverClient);
        this.bufferPool = bufferPool;
    }

    @Override
    void releaseBuffers(long index) {
        long acked = 0L;
        for (ChunkBuffer buffer : this.remove(index)) {
            acked += (long)buffer.position();
            this.bufferPool.releaseBuffer(buffer);
        }
        this.addAckDataLength(acked);
    }

    @Override
    public void cleanup() {
        super.cleanup();
    }
}

