/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.ComponentVersion;

public enum DatanodeVersion implements ComponentVersion
{
    DEFAULT_VERSION(0, "Initial version"),
    SEPARATE_RATIS_PORTS_AVAILABLE(1, "Version with separated Ratis port."),
    COMBINED_PUTBLOCK_WRITECHUNK_RPC(2, "WriteChunk can optionally support a PutBlock request"),
    FUTURE_VERSION(-1, "Used internally in the client when the server side is  newer and an unknown server version has arrived to the client.");

    public static final DatanodeVersion CURRENT;
    public static final int CURRENT_VERSION;
    private static final Map<Integer, DatanodeVersion> BY_PROTO_VALUE;
    private final int version;
    private final String description;

    private DatanodeVersion(int version, String description) {
        this.version = version;
        this.description = description;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public int toProtoValue() {
        return this.version;
    }

    public static DatanodeVersion fromProtoValue(int value) {
        return BY_PROTO_VALUE.getOrDefault(value, FUTURE_VERSION);
    }

    private static DatanodeVersion latest() {
        DatanodeVersion[] versions = DatanodeVersion.values();
        return versions[versions.length - 2];
    }

    static {
        CURRENT = DatanodeVersion.latest();
        CURRENT_VERSION = DatanodeVersion.CURRENT.version;
        BY_PROTO_VALUE = Arrays.stream(DatanodeVersion.values()).collect(Collectors.toMap(DatanodeVersion::toProtoValue, Function.identity()));
    }
}

