/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.CodecBuffer;
import org.apache.ratis.util.function.CheckedFunction;

public final class Proto2Codec<M extends MessageLite>
implements Codec<M> {
    private static final ConcurrentMap<Class<? extends MessageLite>, Codec<? extends MessageLite>> CODECS = new ConcurrentHashMap<Class<? extends MessageLite>, Codec<? extends MessageLite>>();
    private final Class<M> clazz;
    private final Parser<M> parser;

    public static <T extends MessageLite> Codec<T> get(T t) {
        Codec codec = CODECS.computeIfAbsent(t.getClass(), key -> new Proto2Codec<MessageLite>(t));
        return codec;
    }

    private Proto2Codec(M m) {
        this.clazz = m.getClass();
        this.parser = m.getParserForType();
    }

    @Override
    public Class<M> getTypeClass() {
        return this.clazz;
    }

    @Override
    public boolean supportCodecBuffer() {
        return true;
    }

    @Override
    public CodecBuffer toCodecBuffer(@Nonnull M message, CodecBuffer.Allocator allocator) throws IOException {
        int size = message.getSerializedSize();
        return ((CodecBuffer)allocator.apply(size)).put(this.writeTo(message, size));
    }

    private CheckedFunction<OutputStream, Integer, IOException> writeTo(M message, int size) {
        return out -> {
            message.writeTo(out);
            return size;
        };
    }

    @Override
    public M fromCodecBuffer(@Nonnull CodecBuffer buffer) throws IOException {
        try (InputStream in = buffer.getInputStream();){
            MessageLite messageLite = (MessageLite)this.parser.parseFrom(in);
            return (M)messageLite;
        }
    }

    @Override
    public byte[] toPersistedFormat(M message) {
        return message.toByteArray();
    }

    @Override
    public M fromPersistedFormat(byte[] bytes) throws InvalidProtocolBufferException {
        return (M)((MessageLite)this.parser.parseFrom(bytes));
    }

    @Override
    public M copyObject(M message) {
        return message;
    }
}

