/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;

@InterfaceAudience.Private
public final class OzoneConsts {
    public static final String STORAGE_DIR = "scm";
    public static final String SCM_ID = "scmUuid";
    public static final String SCM_HA = "scmHA";
    public static final String CLUSTER_ID_PREFIX = "CID-";
    public static final String SCM_CERT_SERIAL_ID = "scmCertSerialId";
    public static final String PRIMARY_SCM_NODE_ID = "primaryScmNodeId";
    public static final String OZONE_SIMPLE_HDFS_USER = "hdfs";
    public static final String STORAGE_ID = "storageID";
    public static final String DATANODE_UUID = "datanodeUuid";
    public static final String DATANODE_LAYOUT_VERSION_DIR = "dnlayoutversion";
    public static final String CLUSTER_ID = "clusterID";
    public static final String LAYOUTVERSION = "layOutVersion";
    public static final String CTIME = "ctime";
    public static final int OZONE_MIN_BUCKET_NAME_LENGTH = 3;
    public static final int OZONE_MAX_BUCKET_NAME_LENGTH = 63;
    public static final String OZONE_ACL_USER_TYPE = "user";
    public static final String OZONE_ACL_GROUP_TYPE = "group";
    public static final String OZONE_ACL_WORLD_TYPE = "world";
    public static final String OZONE_ACL_ANONYMOUS_TYPE = "anonymous";
    public static final String OZONE_ACL_IP_TYPE = "ip";
    public static final String OZONE_ACL_READ = "r";
    public static final String OZONE_ACL_WRITE = "w";
    public static final String OZONE_ACL_DELETE = "d";
    public static final String OZONE_ACL_LIST = "l";
    public static final String OZONE_ACL_ALL = "a";
    public static final String OZONE_ACL_NONE = "n";
    public static final String OZONE_ACL_CREATE = "c";
    public static final String OZONE_ACL_READ_ACL = "x";
    public static final String OZONE_ACL_WRITE_ACL = "y";
    public static final String OZONE_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String OZONE_TIME_ZONE = "GMT";
    public static final String OZONE_OM_SERVICE_LIST_HTTP_ENDPOINT = "/serviceList";
    public static final String OZONE_DB_CHECKPOINT_HTTP_ENDPOINT = "/dbCheckpoint";
    public static final String OZONE_URI_SCHEME = "o3fs";
    public static final String OZONE_OFS_URI_SCHEME = "ofs";
    public static final String OZONE_RPC_SCHEME = "o3";
    public static final String OZONE_O3TRASH_URI_SCHEME = "o3trash";
    public static final String OZONE_HTTP_SCHEME = "http";
    public static final String OZONE_URI_DELIMITER = "/";
    public static final String OZONE_ROOT = "/";
    public static final Path ROOT_PATH = Paths.get("/", new String[0]);
    public static final String CONTAINER_EXTENSION = ".container";
    public static final String CONTAINER_META_PATH = "metadata";
    public static final String CONTAINER_TEMPORARY_CHUNK_PREFIX = "tmp";
    public static final String CONTAINER_CHUNK_NAME_DELIMITER = ".";
    public static final String FILE_HASH = "SHA-256";
    public static final String MD5_HASH = "MD5";
    public static final String CHUNK_OVERWRITE = "OverWriteRequested";
    public static final int CHUNK_SIZE = 0x100000;
    public static final String INCREMENTAL_CHUNK_LIST = "incremental";
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final long PB = 0x4000000000000L;
    public static final long EB = 0x1000000000000000L;
    public static final String CONTAINER_DB_SUFFIX = "container.db";
    public static final String DN_CONTAINER_DB = "-dn-container.db";
    public static final String OM_DB_NAME = "om.db";
    public static final String SCM_DB_NAME = "scm.db";
    public static final String OM_DB_BACKUP_PREFIX = "om.db.backup.";
    public static final String SCM_DB_BACKUP_PREFIX = "scm.db.backup.";
    public static final String CONTAINER_DB_NAME = "container.db";
    public static final String WITNESSED_CONTAINER_DB_NAME = "witnessed_container.db";
    public static final String STORAGE_DIR_CHUNKS = "chunks";
    public static final String OZONE_DB_CHECKPOINT_REQUEST_FLUSH = "flushBeforeCheckpoint";
    public static final String OZONE_DB_CHECKPOINT_INCLUDE_SNAPSHOT_DATA = "includeSnapshotData";
    public static final String OZONE_DB_CHECKPOINT_REQUEST_TO_EXCLUDE_SST = "toExcludeSST";
    public static final String RANGER_OZONE_SERVICE_VERSION_KEY = "#RANGEROZONESERVICEVERSION";
    public static final String MULTIPART_FORM_DATA_BOUNDARY = "---XXX";
    public static final String DELETING_KEY_PREFIX = "#deleting#";
    public static final String DELETE_TRANSACTION_KEY = "#delTX";
    public static final String BLOCK_COMMIT_SEQUENCE_ID = "#BCSID";
    public static final String BLOCK_COUNT = "#BLOCKCOUNT";
    public static final String CONTAINER_BYTES_USED = "#BYTESUSED";
    public static final String PENDING_DELETE_BLOCK_COUNT = "#PENDINGDELETEBLOCKCOUNT";
    public static final String OM_KEY_PREFIX = "/";
    public static final String OM_USER_PREFIX = "$";
    public static final String OM_S3_PREFIX = "S3:";
    public static final String OM_S3_CALLER_CONTEXT_PREFIX = "S3Auth:S3G|";
    public static final String OM_S3_SECRET = "S3Secret:";
    public static final String OM_PREFIX = "Prefix:";
    public static final int OZONE_SCM_CHUNK_MAX_SIZE = 0x2000000;
    public static final long QUOTA_RESET = -1L;
    public static final long OLD_QUOTA_DEFAULT = -2L;
    public static final long OBJECT_ID_RECLAIM_BLOCKS = 0L;
    public static final String OZONE_SCM_DATANODE_ID_FILE_DEFAULT = "datanode.id";
    public static final String OM_CONTEXT_ATTRIBUTE = "ozone.om";
    public static final String SCM_CONTEXT_ATTRIBUTE = "ozone.scm";
    public static final String CONTAINER_ID = "containerID";
    public static final String CONTAINER_TYPE = "containerType";
    public static final String STATE = "state";
    public static final String METADATA = "metadata";
    public static final String MAX_SIZE = "maxSize";
    public static final String METADATA_PATH = "metadataPath";
    public static final String CHUNKS_PATH = "chunksPath";
    public static final String CONTAINER_DB_TYPE = "containerDBType";
    public static final String CHECKSUM = "checksum";
    public static final String DATA_SCAN_TIMESTAMP = "dataScanTimestamp";
    public static final String ORIGIN_PIPELINE_ID = "originPipelineId";
    public static final String ORIGIN_NODE_ID = "originNodeId";
    public static final String SCHEMA_VERSION = "schemaVersion";
    public static final String REPLICA_INDEX = "replicaIndex";
    public static final String SCHEMA_V1 = "1";
    public static final String SCHEMA_V2 = "2";
    public static final String SCHEMA_V3 = "3";
    public static final String OZONE = "ozone";
    public static final String S3 = "s3";
    public static final String VOLUME = "volume";
    public static final String BUCKET = "bucket";
    public static final String KEY = "key";
    public static final String SRC_KEY = "srcKey";
    public static final String DST_KEY = "dstKey";
    public static final String USED_BYTES = "usedBytes";
    public static final String USED_NAMESPACE = "usedNamespace";
    public static final String QUOTA_IN_BYTES = "quotaInBytes";
    public static final String QUOTA_IN_NAMESPACE = "quotaInNamespace";
    public static final String OBJECT_ID = "objectID";
    public static final String UPDATE_ID = "updateID";
    public static final String CLIENT_ID = "clientID";
    public static final String OWNER = "owner";
    public static final String ADMIN = "admin";
    public static final String USERNAME = "username";
    public static final String PREV_KEY = "prevKey";
    public static final String START_KEY = "startKey";
    public static final String MAX_KEYS = "maxKeys";
    public static final String PREFIX = "prefix";
    public static final String KEY_PREFIX = "keyPrefix";
    public static final String ACL = "acl";
    public static final String ACLS = "acls";
    public static final String MAX_NUM_OF_BUCKETS = "maxNumOfBuckets";
    public static final String HAS_SNAPSHOT = "hasSnapshot";
    public static final String STORAGE_TYPE = "storageType";
    public static final String RESOURCE_TYPE = "resourceType";
    public static final String IS_VERSION_ENABLED = "isVersionEnabled";
    public static final String CREATION_TIME = "creationTime";
    public static final String MODIFICATION_TIME = "modificationTime";
    public static final String DATA_SIZE = "dataSize";
    public static final String REPLICATION_TYPE = "replicationType";
    public static final String REPLICATION_FACTOR = "replicationFactor";
    public static final String REPLICATION_CONFIG = "replicationConfig";
    public static final String MULTIPART_LIST = "multipartList";
    public static final String UPLOAD_ID = "uploadID";
    public static final String PART_NUMBER_MARKER = "partNumberMarker";
    public static final String MAX_PARTS = "maxParts";
    public static final String S3_BUCKET = "s3Bucket";
    public static final String S3_GETSECRET_USER = "S3GetSecretUser";
    public static final String S3_SETSECRET_USER = "S3SetSecretUser";
    public static final String S3_REVOKESECRET_USER = "S3RevokeSecretUser";
    public static final String RENAMED_KEYS_MAP = "renamedKeysMap";
    public static final String UNRENAMED_KEYS_MAP = "unRenamedKeysMap";
    public static final String MULTIPART_UPLOAD_PART_NUMBER = "partNumber";
    public static final String MULTIPART_UPLOAD_PART_NAME = "partName";
    public static final String BUCKET_ENCRYPTION_KEY = "bucketEncryptionKey";
    public static final String DELETED_KEYS_LIST = "deletedKeysList";
    public static final String UNDELETED_KEYS_LIST = "unDeletedKeysList";
    public static final String SOURCE_VOLUME = "sourceVolume";
    public static final String SOURCE_BUCKET = "sourceBucket";
    public static final String BUCKET_LAYOUT = "bucketLayout";
    public static final String TENANT = "tenant";
    public static final String USER_PREFIX = "userPrefix";
    public static final String REWRITE_GENERATION = "rewriteGeneration";
    public static final String TENANT_ID_USERNAME_DELIMITER = "$";
    public static final String DEFAULT_TENANT_BUCKET_NAMESPACE_POLICY_SUFFIX = "-VolumeAccess";
    public static final String DEFAULT_TENANT_BUCKET_POLICY_SUFFIX = "-BucketAccess";
    public static final String DEFAULT_TENANT_ROLE_USER_SUFFIX = "-UserRole";
    public static final String DEFAULT_TENANT_ROLE_ADMIN_SUFFIX = "-AdminRole";
    public static final String OM_METRICS_FILE = "omMetrics";
    public static final String OM_METRICS_TEMP_FILE = "omMetrics.tmp";
    public static final int OM_MULTIPART_MIN_SIZE = 0x500000;
    public static final int MAXIMUM_NUMBER_OF_PARTS_PER_UPLOAD = 10000;
    public static final String RPC_PORT = "RPC";
    public static final String OM_SERVICE_ID_DEFAULT = "omServiceIdDefault";
    public static final String OM_DEFAULT_NODE_ID = "om1";
    public static final String JAVA_TMP_DIR = "java.io.tmpdir";
    public static final String LOCALHOST = "localhost";
    public static final int S3_SECRET_KEY_MIN_LENGTH = 8;
    public static final int S3_REQUEST_HEADER_METADATA_SIZE_LIMIT_KB = 2;
    public static final String HSYNC_CLIENT_ID = "hsyncClientId";
    public static final String LEASE_RECOVERY = "leaseRecovery";
    public static final String DELETED_HSYNC_KEY = "deletedHsyncKey";
    public static final String OVERWRITTEN_HSYNC_KEY = "overwrittenHsyncKey";
    public static final String FORCE_LEASE_RECOVERY_ENV = "OZONE.CLIENT.RECOVER.LEASE.FORCE";
    public static final String GDPR_FLAG = "gdprEnabled";
    public static final String GDPR_ALGORITHM_NAME = "AES";
    public static final int GDPR_DEFAULT_RANDOM_SECRET_LENGTH = 16;
    public static final Charset GDPR_CHARSET = StandardCharsets.UTF_8;
    public static final String GDPR_SECRET = "secret";
    public static final String GDPR_ALGORITHM = "algorithm";
    public static final Pattern KEYNAME_ILLEGAL_CHARACTER_CHECK_REGEX = Pattern.compile("^[^\\\\{}<>^%~#|`\\[\\]\"\\x80-\\xff]+$");
    public static final String FS_FILE_COPYING_TEMP_SUFFIX = "._COPYING_";
    public static final String TRANSACTION_INFO_KEY = "#TRANSACTIONINFO";
    public static final String TRANSACTION_INFO_SPLIT_KEY = "#";
    public static final String PREPARE_MARKER_KEY = "#PREPAREDINFO";
    public static final String CONTAINER_DB_TYPE_ROCKSDB = "RocksDB";
    public static final String DB_TRANSIENT_MARKER = "dbInconsistentMarker";
    public static final String PREPARE_MARKER = "prepareMarker";
    public static final String OZONE_RATIS_SNAPSHOT_DIR = "snapshot";
    public static final long DEFAULT_OM_UPDATE_ID = -1L;
    public static final String SNAPSHOT_CANDIDATE_DIR = ".candidate";
    public static final String ROCKSDB_SST_SUFFIX = ".sst";
    public static final String SCM_DUMMY_NODEID = "scmNodeId";
    public static final String SCM_DUMMY_SERVICE_ID = "scmServiceId";
    public static final String SCM_CA_PATH = "ca";
    public static final String SCM_CA_CERT_STORAGE_DIR = "scm";
    public static final String SCM_SUB_CA_PATH = "sub-ca";
    public static final String SCM_ROOT_CA_COMPONENT_NAME = Paths.get("scm", "ca").toString();
    public static final String SCM_SUB_CA = "scm-sub";
    public static final String SCM_SUB_CA_PREFIX = "scm-sub@";
    public static final String SCM_ROOT_CA = "scm";
    public static final String SCM_ROOT_CA_PREFIX = "scm@";
    public static final String LAYOUT_VERSION_KEY = "#LAYOUTVERSION";
    public static final String FINALIZING_KEY = "#FINALIZING";
    public static final String KERBEROS_CONFIG_VALUE = "kerberos";
    public static final String HTTP_AUTH_TYPE_SUFFIX = "http.auth.type";
    public static final String OZONE_SECURITY_ENABLED_SECURE = "true";
    public static final String OZONE_HTTP_SECURITY_ENABLED_SECURE = "true";
    public static final String OZONE_HTTP_FILTER_INITIALIZERS_SECURE = "org.apache.hadoop.security.AuthenticationFilterInitializer";
    public static final String DELEGATION_TOKEN_KIND = "kind";
    public static final String DELEGATION_TOKEN_SERVICE = "service";
    public static final String DELEGATION_TOKEN_RENEWER = "renewer";
    public static final String BLOCK_GROUP_LEN_KEY_IN_PUT_BLOCK = "blockGroupLen";
    public static final String OZONE_OM_RANGER_ADMIN_CREATE_USER_HTTP_ENDPOINT = "/service/xusers/secure/users";
    public static final String OZONE_OM_RANGER_ADMIN_ROLE_ADD_USER_HTTP_ENDPOINT = "/service/roles/roles/";
    public static final String OZONE_OM_RANGER_ADMIN_GET_USER_HTTP_ENDPOINT = "/service/xusers/users/?name=";
    public static final String OZONE_OM_RANGER_ADMIN_DELETE_USER_HTTP_ENDPOINT = "/service/xusers/secure/users/id/";
    public static final String OZONE_OM_RANGER_ADMIN_CREATE_ROLE_HTTP_ENDPOINT = "/service/roles/roles";
    public static final String OZONE_OM_RANGER_ADMIN_GET_ROLE_HTTP_ENDPOINT = "/service/roles/roles/name/";
    public static final String OZONE_OM_RANGER_ADMIN_DELETE_GROUP_HTTP_ENDPOINT = "/service/xusers/secure/groups/id/";
    public static final String OZONE_OM_RANGER_ADMIN_DELETE_ROLE_HTTP_ENDPOINT = "/service/roles/roles/";
    public static final String OZONE_OM_RANGER_ADMIN_CREATE_POLICY_HTTP_ENDPOINT = "/service/public/v2/api/policy";
    public static final String OZONE_OM_RANGER_ADMIN_GET_POLICY_HTTP_ENDPOINT = "/service/public/v2/api/policy/?policyName=";
    public static final String OZONE_OM_RANGER_ADMIN_GET_POLICY_ID_HTTP_ENDPOINT = "/service/public/v2/api/policy/?policyId=";
    public static final String OZONE_OM_RANGER_ADMIN_DELETE_POLICY_HTTP_ENDPOINT = "/service/plugins/policies/";
    public static final String OZONE_OM_RANGER_OZONE_SERVICE_ENDPOINT = "/service/plugins/services/";
    public static final String OZONE_OM_RANGER_DOWNLOAD_ENDPOINT = "/service/plugins/secure/policies/download/cm_ozone?supportsPolicyDeltas=true&lastKnownVersion=";
    public static final String OZONE_OM_RANGER_ALL_POLICIES_ENDPOINT = "/service/plugins/policies/service/";
    public static final String OZONE_TENANT_RANGER_POLICY_LABEL = "OzoneTenant";
    public static final long OZONE_TENANT_AUTHORIZER_LOCK_WAIT_MILLIS = 1000L;
    public static final int OZONE_MAXIMUM_ACCESS_ID_LENGTH = 100;
    public static final String OM_SNAPSHOT_NAME = "snapshotName";
    public static final String OM_CHECKPOINT_DIR = "db.checkpoints";
    public static final String OM_SNAPSHOT_DIR = "db.snapshots";
    public static final String OM_SNAPSHOT_CHECKPOINT_DIR = "db.snapshots/checkpointState";
    public static final String OM_SNAPSHOT_DIFF_DIR = "db.snapshots/diffState";
    public static final String OM_SNAPSHOT_INDICATOR = ".snapshot";
    public static final String OM_SNAPSHOT_DIFF_DB_NAME = "db.snapdiff";
    public static final String DB_COMPACTION_SST_BACKUP_DIR = "compaction-sst-backup";
    public static final String DB_COMPACTION_LOG_DIR = "compaction-log";
    public static final String SNAPSHOT_INFO_TABLE = "snapshotInfoTable";
    public static final String COMPACTION_LOG_TABLE = "compactionLogTable";
    public static final String ETAG = "ETag";

    private OzoneConsts() {
    }

    public static enum Units {
        TB,
        GB,
        MB,
        KB,
        B;

    }
}

