/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozone.lib.service.instrumentation;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.util.Time;
import org.apache.ozone.lib.server.BaseService;
import org.apache.ozone.lib.server.ServiceException;
import org.apache.ozone.lib.service.Instrumentation;
import org.apache.ozone.lib.service.Scheduler;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

@InterfaceAudience.Private
public class InstrumentationService
extends BaseService
implements Instrumentation {
    public static final String PREFIX = "instrumentation";
    public static final String CONF_TIMERS_SIZE = "timers.size";
    private int timersSize;
    private Lock counterLock;
    private Lock timerLock;
    private Lock variableLock;
    private Lock samplerLock;
    private Map<String, Map<String, AtomicLong>> counters;
    private Map<String, Map<String, Timer>> timers;
    private Map<String, Map<String, VariableHolder>> variables;
    private Map<String, Map<String, Sampler>> samplers;
    private List<Sampler> samplersList;
    private Map<String, Map<String, ?>> all;

    public InstrumentationService() {
        super(PREFIX);
    }

    @Override
    public void init() throws ServiceException {
        this.timersSize = this.getServiceConfig().getInt(CONF_TIMERS_SIZE, 10);
        this.counterLock = new ReentrantLock();
        this.timerLock = new ReentrantLock();
        this.variableLock = new ReentrantLock();
        this.samplerLock = new ReentrantLock();
        ConcurrentHashMap<String, VariableHolder<Long>> jvmVariables = new ConcurrentHashMap<String, VariableHolder<Long>>();
        this.counters = new ConcurrentHashMap<String, Map<String, AtomicLong>>();
        this.timers = new ConcurrentHashMap<String, Map<String, Timer>>();
        this.variables = new ConcurrentHashMap<String, Map<String, VariableHolder>>();
        this.samplers = new ConcurrentHashMap<String, Map<String, Sampler>>();
        this.samplersList = new ArrayList<Sampler>();
        this.all = new LinkedHashMap();
        this.all.put("os-env", System.getenv());
        this.all.put("sys-props", System.getProperties());
        this.all.put("jvm", jvmVariables);
        this.all.put("counters", this.counters);
        this.all.put("timers", this.timers);
        this.all.put("variables", this.variables);
        this.all.put("samplers", this.samplers);
        jvmVariables.put("free.memory", new VariableHolder<Long>(new Instrumentation.Variable<Long>(){

            @Override
            public Long getValue() {
                return Runtime.getRuntime().freeMemory();
            }
        }));
        jvmVariables.put("max.memory", new VariableHolder<Long>(new Instrumentation.Variable<Long>(){

            @Override
            public Long getValue() {
                return Runtime.getRuntime().maxMemory();
            }
        }));
        jvmVariables.put("total.memory", new VariableHolder<Long>(new Instrumentation.Variable<Long>(){

            @Override
            public Long getValue() {
                return Runtime.getRuntime().totalMemory();
            }
        }));
    }

    @Override
    public void postInit() throws ServiceException {
        Scheduler scheduler = this.getServer().get(Scheduler.class);
        if (scheduler != null) {
            scheduler.schedule(new SamplersRunnable(), 0L, 1L, TimeUnit.SECONDS);
        }
    }

    @Override
    public Class getInterface() {
        return Instrumentation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getToAdd(String group, String name, Class<T> klass, Lock lock, Map<String, Map<String, T>> map) {
        lock.lock();
        try {
            Object object = map.computeIfAbsent(group, k -> new ConcurrentHashMap()).computeIfAbsent(name, k -> {
                try {
                    if (klass == Timer.class) {
                        return new Timer(this.timersSize);
                    }
                    return klass.newInstance();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Cron createCron() {
        return new Cron();
    }

    @Override
    public void incr(String group, String name, long count) {
        AtomicLong counter = this.getToAdd(group, name, AtomicLong.class, this.counterLock, this.counters);
        counter.addAndGet(count);
    }

    @Override
    public void addCron(String group, String name, Instrumentation.Cron cron) {
        Timer timer = this.getToAdd(group, name, Timer.class, this.timerLock, this.timers);
        timer.addCron((Cron)cron);
    }

    @Override
    public void addVariable(String group, String name, Instrumentation.Variable<?> variable) {
        VariableHolder holder = this.getToAdd(group, name, VariableHolder.class, this.variableLock, this.variables);
        holder.var = variable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSampler(String group, String name, int samplingSize, Instrumentation.Variable<Long> variable) {
        Sampler sampler = this.getToAdd(group, name, Sampler.class, this.samplerLock, this.samplers);
        this.samplerLock.lock();
        try {
            sampler.init(samplingSize, variable);
            this.samplersList.add(sampler);
        }
        finally {
            this.samplerLock.unlock();
        }
    }

    @Override
    public Map<String, Map<String, ?>> getSnapshot() {
        return this.all;
    }

    class SamplersRunnable
    implements Runnable {
        SamplersRunnable() {
        }

        @Override
        public void run() {
            InstrumentationService.this.samplerLock.lock();
            try {
                for (Sampler sampler : InstrumentationService.this.samplersList) {
                    sampler.sample();
                }
            }
            finally {
                InstrumentationService.this.samplerLock.unlock();
            }
        }
    }

    static class Sampler
    implements JSONAware,
    JSONStreamAware {
        private Instrumentation.Variable<Long> variable;
        private long[] values;
        private AtomicLong sum;
        private int last;
        private boolean full;

        Sampler() {
        }

        void init(int size, Instrumentation.Variable<Long> var) {
            this.variable = var;
            this.values = new long[size];
            this.sum = new AtomicLong();
            this.last = 0;
        }

        void sample() {
            int index = this.last;
            long valueGoingOut = this.values[this.last];
            this.full = this.full || this.last == this.values.length - 1;
            this.last = (this.last + 1) % this.values.length;
            this.values[index] = this.variable.getValue();
            this.sum.addAndGet(-valueGoingOut + this.values[index]);
        }

        double getRate() {
            return (double)this.sum.get() / (double)(this.full ? this.values.length : (this.last == 0 ? 1 : this.last));
        }

        private JSONObject getJSON() {
            JSONObject json = new JSONObject();
            json.put((Object)"sampler", (Object)this.getRate());
            json.put((Object)"size", (Object)(this.full ? this.values.length : this.last));
            return json;
        }

        public String toJSONString() {
            return this.getJSON().toJSONString();
        }

        public void writeJSONString(Writer out) throws IOException {
            out.write(this.toJSONString());
        }
    }

    static class VariableHolder<E>
    implements JSONAware,
    JSONStreamAware {
        Instrumentation.Variable<E> var;

        VariableHolder() {
        }

        VariableHolder(Instrumentation.Variable<E> var) {
            this.var = var;
        }

        private JSONObject getJSON() {
            JSONObject json = new JSONObject();
            json.put((Object)"value", this.var.getValue());
            return json;
        }

        public String toJSONString() {
            return this.getJSON().toJSONString();
        }

        public void writeJSONString(Writer out) throws IOException {
            out.write(this.toJSONString());
        }
    }

    static class Timer
    implements JSONAware,
    JSONStreamAware {
        static final int LAST_TOTAL = 0;
        static final int LAST_OWN = 1;
        static final int AVG_TOTAL = 2;
        static final int AVG_OWN = 3;
        private Lock lock = new ReentrantLock();
        private long[] own;
        private long[] total;
        private int last;
        private boolean full;
        private int size;

        Timer(int size) {
            this.size = size;
            this.own = new long[size];
            this.total = new long[size];
            for (int i = 0; i < size; ++i) {
                this.own[i] = -1L;
                this.total[i] = -1L;
            }
            this.last = -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long[] getValues() {
            this.lock.lock();
            try {
                long[] values = new long[4];
                values[0] = this.total[this.last];
                values[1] = this.own[this.last];
                int limit = this.full ? this.size : this.last + 1;
                for (int i = 0; i < limit; ++i) {
                    values[2] = values[2] + this.total[i];
                    values[3] = values[3] + this.own[i];
                }
                values[2] = values[2] / (long)limit;
                values[3] = values[3] / (long)limit;
                long[] lArray = values;
                return lArray;
            }
            finally {
                this.lock.unlock();
            }
        }

        void addCron(Cron cron) {
            cron.end();
            this.lock.lock();
            try {
                this.last = (this.last + 1) % this.size;
                this.full = this.full || this.last == this.size - 1;
                this.total[this.last] = cron.total;
                this.own[this.last] = cron.own;
            }
            finally {
                this.lock.unlock();
            }
        }

        private JSONObject getJSON() {
            long[] values = this.getValues();
            JSONObject json = new JSONObject();
            json.put((Object)"lastTotal", (Object)values[0]);
            json.put((Object)"lastOwn", (Object)values[1]);
            json.put((Object)"avgTotal", (Object)values[2]);
            json.put((Object)"avgOwn", (Object)values[3]);
            return json;
        }

        public String toJSONString() {
            return this.getJSON().toJSONString();
        }

        public void writeJSONString(Writer out) throws IOException {
            this.getJSON().writeJSONString(out);
        }
    }

    static class Cron
    implements Instrumentation.Cron {
        long start;
        long lapStart;
        long own;
        long total;

        Cron() {
        }

        @Override
        public Cron start() {
            if (this.total != 0L) {
                throw new IllegalStateException("Cron already used");
            }
            if (this.start == 0L) {
                this.lapStart = this.start = Time.now();
            } else if (this.lapStart == 0L) {
                this.lapStart = Time.now();
            }
            return this;
        }

        @Override
        public Cron stop() {
            if (this.total != 0L) {
                throw new IllegalStateException("Cron already used");
            }
            if (this.lapStart > 0L) {
                this.own += Time.now() - this.lapStart;
                this.lapStart = 0L;
            }
            return this;
        }

        void end() {
            this.stop();
            this.total = Time.now() - this.start;
        }
    }
}

