/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.pipeline;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.hadoop.hdds.client.RatisReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import picocli.CommandLine;

public class FilterPipelineOptions {
    @CommandLine.Option(names={"-t", "--type"}, description={"Filter pipelines by replication type, RATIS or EC"}, defaultValue="")
    private String replicationType;
    @CommandLine.Option(names={"-r", "--replication"}, description={"Filter pipelines by replication, eg ONE, THREE or for EC rs-3-2-1024k"}, defaultValue="")
    private String replication;
    @CommandLine.Option(names={"-ffc", "--filterByFactor", "--filter-by-factor"}, description={"[deprecated] Filter pipelines by factor (e.g. ONE, THREE) (implies RATIS replication type)"})
    private ReplicationFactor factor;

    Optional<Predicate<? super Pipeline>> getReplicationFilter() {
        boolean hasReplicationType;
        boolean hasReplication = !Strings.isNullOrEmpty((String)this.replication);
        boolean hasFactor = this.factor != null;
        boolean bl = hasReplicationType = !Strings.isNullOrEmpty((String)this.replicationType);
        if (hasFactor) {
            if (hasReplication) {
                throw new IllegalArgumentException("Factor and replication are mutually exclusive");
            }
            RatisReplicationConfig replicationConfig = RatisReplicationConfig.getInstance((HddsProtos.ReplicationFactor)this.factor.toProto());
            return Optional.of(arg_0 -> FilterPipelineOptions.lambda$getReplicationFilter$0((ReplicationConfig)replicationConfig, arg_0));
        }
        if (hasReplication) {
            if (!hasReplicationType) {
                throw new IllegalArgumentException("Replication type is required if replication is set");
            }
            ReplicationConfig replicationConfig = ReplicationConfig.parse((ReplicationType)ReplicationType.valueOf((String)this.replicationType), (String)this.replication, (ConfigurationSource)new OzoneConfiguration());
            return Optional.of(p -> replicationConfig.equals(p.getReplicationConfig()));
        }
        if (hasReplicationType) {
            return Optional.of(p -> p.getReplicationConfig().getReplicationType().toString().compareToIgnoreCase(this.replicationType) == 0);
        }
        return Optional.empty();
    }

    private static /* synthetic */ boolean lambda$getReplicationFilter$0(ReplicationConfig replicationConfig, Pipeline p) {
        return replicationConfig.equals(p.getReplicationConfig());
    }
}

