/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.balancer;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.scm.PlacementPolicyValidateProxy;
import org.apache.hadoop.hdds.scm.container.ContainerManager;
import org.apache.hadoop.hdds.scm.container.balancer.AbstractFindTargetGreedy;
import org.apache.hadoop.hdds.scm.node.DatanodeUsageInfo;
import org.apache.hadoop.hdds.scm.node.NodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindTargetGreedyByUsageInfo
extends AbstractFindTargetGreedy {
    public static final Logger LOG = LoggerFactory.getLogger(FindTargetGreedyByUsageInfo.class);

    public FindTargetGreedyByUsageInfo(ContainerManager containerManager, PlacementPolicyValidateProxy placementPolicyValidateProxy, NodeManager nodeManager) {
        super(containerManager, placementPolicyValidateProxy, nodeManager);
        this.setLogger(LOG);
        this.setPotentialTargets(new TreeSet<DatanodeUsageInfo>((a, b) -> this.compareByUsage((DatanodeUsageInfo)a, (DatanodeUsageInfo)b)));
    }

    @Override
    @VisibleForTesting
    public void sortTargetForSource(DatanodeDetails source) {
    }

    @Override
    public void resetPotentialTargets(@Nonnull Collection<DatanodeDetails> targets) {
        ArrayList<DatanodeUsageInfo> usageInfos = new ArrayList<DatanodeUsageInfo>(targets.size());
        targets.forEach(datanodeDetails -> usageInfos.add(this.getNodeManager().getUsageInfo((DatanodeDetails)datanodeDetails)));
        super.resetTargets(usageInfos);
    }
}

