/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.ha;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.ExitManager;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SecretKeyProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.AddSCMRequest;
import org.apache.hadoop.hdds.scm.RemoveSCMRequest;
import org.apache.hadoop.hdds.scm.container.ContainerID;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.ha.BackgroundSCMService;
import org.apache.hadoop.hdds.scm.ha.InterSCMGrpcProtocolService;
import org.apache.hadoop.hdds.scm.ha.SCMHADBTransactionBuffer;
import org.apache.hadoop.hdds.scm.ha.SCMHADBTransactionBufferImpl;
import org.apache.hadoop.hdds.scm.ha.SCMHAManager;
import org.apache.hadoop.hdds.scm.ha.SCMHATransactionBufferMonitorTask;
import org.apache.hadoop.hdds.scm.ha.SCMNodeDetails;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServer;
import org.apache.hadoop.hdds.scm.ha.SCMRatisServerImpl;
import org.apache.hadoop.hdds.scm.ha.SCMSnapshotProvider;
import org.apache.hadoop.hdds.scm.metadata.DBTransactionBuffer;
import org.apache.hadoop.hdds.scm.metadata.SCMDBDefinition;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.scm.security.SecretKeyManagerService;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;
import org.apache.hadoop.hdds.security.SecurityConfig;
import org.apache.hadoop.hdds.security.symmetric.ManagedSecretKey;
import org.apache.hadoop.hdds.utils.HAUtils;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.IOUtils;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMHAManagerImpl
implements SCMHAManager {
    private static final Logger LOG = LoggerFactory.getLogger(SCMHAManagerImpl.class);
    private final SCMRatisServer ratisServer;
    private final ConfigurationSource conf;
    private final OzoneConfiguration ozoneConf;
    private final SecurityConfig securityConfig;
    private final SCMHADBTransactionBufferImpl transactionBuffer;
    private final SCMSnapshotProvider scmSnapshotProvider;
    private final StorageContainerManager scm;
    private ExitManager exitManager;
    private final InterSCMGrpcProtocolService grpcServer;
    private BackgroundSCMService trxBufferMonitorService = null;

    public SCMHAManagerImpl(ConfigurationSource conf, SecurityConfig securityConfig, StorageContainerManager scm) throws IOException {
        this.conf = conf;
        this.ozoneConf = OzoneConfiguration.of((ConfigurationSource)conf);
        this.securityConfig = securityConfig;
        this.scm = scm;
        this.exitManager = new ExitManager();
        this.transactionBuffer = new SCMHADBTransactionBufferImpl(scm);
        this.ratisServer = new SCMRatisServerImpl(conf, scm, this.transactionBuffer);
        this.scmSnapshotProvider = this.newScmSnapshotProvider(scm);
        this.grpcServer = new InterSCMGrpcProtocolService(conf, scm);
    }

    @VisibleForTesting
    protected SCMSnapshotProvider newScmSnapshotProvider(StorageContainerManager storageContainerManager) {
        return new SCMSnapshotProvider((ConfigurationSource)storageContainerManager.getConfiguration(), storageContainerManager.getSCMHANodeDetails().getPeerNodeDetails(), storageContainerManager.getScmCertificateClient());
    }

    @Override
    public void start() throws IOException {
        if (this.ratisServer == null) {
            return;
        }
        this.ratisServer.start();
        if (this.ratisServer.getDivision().getGroup().getPeers().isEmpty()) {
            SCMNodeDetails nodeDetails = this.scm.getSCMHANodeDetails().getLocalNodeDetails();
            boolean success = HAUtils.addSCM((OzoneConfiguration)this.ozoneConf, (AddSCMRequest)new AddSCMRequest.Builder().setClusterId(this.scm.getClusterId()).setScmId(this.scm.getScmId()).setRatisAddr(nodeDetails.getRatisHostPortStr()).build(), (String)this.scm.getSCMNodeId());
            if (!success) {
                throw new IOException("Adding SCM to existing HA group failed");
            }
            LOG.info("Successfully added SCM {} to group {}", (Object)nodeDetails.getNodeId(), (Object)this.ratisServer.getDivision().getGroup());
        } else {
            LOG.info(" scm role is {} peers {}", (Object)this.ratisServer.getDivision().getInfo().getCurrentRole(), (Object)this.ratisServer.getDivision().getGroup().getPeers());
        }
        this.grpcServer.start();
        this.createStartTransactionBufferMonitor();
    }

    private void createStartTransactionBufferMonitor() {
        long interval = this.conf.getTimeDuration("ozone.scm.ha.dbtransactionbuffer.flush.interval", 600000L, TimeUnit.MILLISECONDS);
        SCMHATransactionBufferMonitorTask monitorTask = new SCMHATransactionBufferMonitorTask(this.transactionBuffer, this.ratisServer, interval);
        this.trxBufferMonitorService = new BackgroundSCMService.Builder().setClock(this.scm.getSystemClock()).setScmContext(this.scm.getScmContext()).setServiceName("SCMHATransactionMonitor").setIntervalInMillis(interval).setWaitTimeInMillis(interval).setPeriodicalTask(monitorTask).build();
        this.scm.getSCMServiceManager().register(this.trxBufferMonitorService);
        this.trxBufferMonitorService.start();
    }

    @Override
    public SCMRatisServer getRatisServer() {
        return this.ratisServer;
    }

    @Override
    public DBTransactionBuffer getDBTransactionBuffer() {
        return this.transactionBuffer;
    }

    @Override
    public SCMSnapshotProvider getSCMSnapshotProvider() {
        return this.scmSnapshotProvider;
    }

    @Override
    public SCMHADBTransactionBuffer asSCMHADBTransactionBuffer() {
        return this.transactionBuffer;
    }

    @Override
    public DBCheckpoint downloadCheckpointFromLeader(String leaderId) {
        if (this.scmSnapshotProvider == null) {
            LOG.error("SCM Snapshot Provider is not configured as there are no peer nodes.");
            return null;
        }
        DBCheckpoint dBCheckpoint = this.getDBCheckpointFromLeader(leaderId);
        if (dBCheckpoint != null) {
            LOG.info("Downloaded checkpoint from Leader {} to the location {}", (Object)leaderId, (Object)dBCheckpoint.getCheckpointLocation());
        }
        return dBCheckpoint;
    }

    @Override
    public List<ManagedSecretKey> getSecretKeysFromLeader(String leaderID) throws IOException {
        if (!SecretKeyManagerService.isSecretKeyEnable(this.securityConfig)) {
            return null;
        }
        LOG.info("Getting secret keys from leader {}.", (Object)leaderID);
        try (SecretKeyProtocolClientSideTranslatorPB secretKeyProtocol = HddsServerUtil.getSecretKeyClientForScm((ConfigurationSource)this.conf, (String)leaderID, (UserGroupInformation)UserGroupInformation.getLoginUser());){
            List list = secretKeyProtocol.getAllSecretKeys();
            return list;
        }
    }

    private TransactionInfo getTransactionInfoFromCheckpoint(Path checkpointLocation) throws IOException {
        return HAUtils.getTrxnInfoFromCheckpoint((OzoneConfiguration)this.ozoneConf, (Path)checkpointLocation, (DBDefinition)SCMDBDefinition.get());
    }

    @Override
    public TermIndex verifyCheckpointFromLeader(String leaderId, DBCheckpoint checkpoint) {
        try {
            Path checkpointLocation = checkpoint.getCheckpointLocation();
            TransactionInfo checkpointTxnInfo = this.getTransactionInfoFromCheckpoint(checkpointLocation);
            LOG.info("{}: Verify checkpoint {} from leader {}", new Object[]{this.scm.getScmId(), checkpointTxnInfo, leaderId});
            TermIndex termIndex = this.getRatisServer().getSCMStateMachine().getLastAppliedTermIndex();
            long lastAppliedIndex = termIndex.getIndex();
            boolean canProceed = HAUtils.verifyTransactionInfo((TransactionInfo)checkpointTxnInfo, (long)lastAppliedIndex, (String)leaderId, (Path)checkpointLocation, (Logger)LOG);
            if (!canProceed) {
                LOG.warn("Cannot proceed with InstallSnapshot as SCM is at TermIndex {} and checkpoint has lower TermIndex {}. Reloading old state of SCM.", (Object)termIndex, (Object)checkpointTxnInfo.getTermIndex());
                return null;
            }
            return checkpointTxnInfo.getTermIndex();
        }
        catch (Exception ex) {
            LOG.error("Failed to install snapshot from Leader SCM.", (Throwable)ex);
            return null;
        }
    }

    private DBCheckpoint getDBCheckpointFromLeader(String leaderId) {
        LOG.info("Downloading checkpoint from leader SCM {} and reloading state from the checkpoint.", (Object)leaderId);
        try {
            return this.scmSnapshotProvider.getSCMDBSnapshot(leaderId);
        }
        catch (Exception e) {
            LOG.error("Failed to download checkpoint from SCM leader {}", (Object)leaderId, (Object)e);
            return null;
        }
    }

    @Override
    public TermIndex installCheckpoint(DBCheckpoint dbCheckpoint) throws Exception {
        Path checkpointLocation = dbCheckpoint.getCheckpointLocation();
        TransactionInfo checkpointTrxnInfo = this.getTransactionInfoFromCheckpoint(checkpointLocation);
        LOG.info("{}: Install checkpoint {}", (Object)this.scm.getScmId(), (Object)checkpointTrxnInfo);
        return this.installCheckpoint(checkpointLocation, checkpointTrxnInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TermIndex installCheckpoint(Path checkpointLocation, TransactionInfo checkpointTxnInfo) throws Exception {
        File dbBackup;
        TermIndex termIndex = this.getRatisServer().getSCMStateMachine().getLastAppliedTermIndex();
        if (checkpointTxnInfo.getTermIndex().compareTo(termIndex) < 0) {
            LOG.warn("Cannot proceed with InstallSnapshot as SCM is at TermIndex {} and checkpoint has lower TermIndex {}. Reloading old state of SCM.", (Object)termIndex, (Object)checkpointTxnInfo.getTermIndex());
            throw new IOException("checkpoint is too older to install.");
        }
        long term = checkpointTxnInfo.getTerm();
        long lastAppliedIndex = checkpointTxnInfo.getTransactionIndex();
        File oldDBLocation = this.scm.getScmMetadataStore().getStore().getDbLocation();
        try {
            this.stopServices();
        }
        catch (Exception e) {
            LOG.error("Failed to stop/ pause the services. Cannot proceed with installing the new checkpoint.");
            this.startServices();
            throw e;
        }
        try {
            dbBackup = HAUtils.replaceDBWithCheckpoint((long)lastAppliedIndex, (File)oldDBLocation, (Path)checkpointLocation, (String)"scm.db.backup.");
            LOG.info("Replaced DB with checkpoint, term: {}, index: {}", (Object)term, (Object)lastAppliedIndex);
        }
        catch (Exception e) {
            LOG.error("Failed to install Snapshot as SCM failed to replace DB with downloaded checkpoint. Checkpoint transaction {}", (Object)e, (Object)checkpointTxnInfo.getTransactionIndex());
            throw e;
        }
        try {
            this.reloadSCMState();
            LOG.info("Reloaded SCM state with Term: {} and Index: {}", (Object)term, (Object)lastAppliedIndex);
        }
        catch (Exception ex) {
            LOG.info("Failed to reload SCM state with Term: {} and Index: {}", (Object)term, (Object)lastAppliedIndex);
            try {
                if (dbBackup != null) {
                    dbBackup = HAUtils.replaceDBWithCheckpoint((long)lastAppliedIndex, (File)oldDBLocation, (Path)dbBackup.toPath(), (String)"scm.db.backup.");
                    LOG.error("Replacing SCM state with Term : {} and Index:", (Object)termIndex.getTerm(), (Object)termIndex.getTerm());
                    this.reloadSCMState();
                }
            }
            finally {
                String errorMsg = "Failed to reload SCM state and instantiate services.";
                this.exitManager.exitSystem(1, errorMsg, (Throwable)ex, LOG);
            }
        }
        try {
            if (dbBackup != null) {
                FileUtils.deleteFully((File)dbBackup);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to delete the backup of the original DB {}", (Object)dbBackup);
        }
        return checkpointTxnInfo.getTermIndex();
    }

    void reloadSCMState() throws IOException {
        this.startServices();
    }

    @Override
    public void stop() throws IOException {
        if (this.ratisServer != null) {
            this.ratisServer.stop();
            this.grpcServer.stop();
            this.close();
        }
        if (this.trxBufferMonitorService != null) {
            this.trxBufferMonitorService.stop();
        }
    }

    @Override
    public void close() {
        IOUtils.close((Logger)LOG, (AutoCloseable[])new AutoCloseable[]{this.transactionBuffer});
    }

    @Override
    public boolean addSCM(AddSCMRequest request) throws IOException {
        String clusterId = this.scm.getClusterId();
        if (!request.getClusterId().equals(this.scm.getClusterId())) {
            throw new IOException("SCM " + request.getScmId() + " with addr " + request.getRatisAddr() + " has cluster Id " + request.getClusterId() + " but leader SCM cluster id is " + clusterId);
        }
        Preconditions.checkNotNull((Object)this.getRatisServer().getDivision().getGroup().getGroupId());
        return this.getRatisServer().addSCM(request);
    }

    @Override
    public boolean removeSCM(RemoveSCMRequest request) throws IOException {
        String clusterId = this.scm.getClusterId();
        if (!request.getClusterId().equals(this.scm.getClusterId())) {
            throw new IOException("SCM " + request.getScmId() + " with address " + request.getRatisAddr() + " has cluster Id " + request.getClusterId() + " but leader SCM cluster id is " + clusterId);
        }
        Preconditions.checkNotNull((Object)this.ratisServer.getDivision().getGroup());
        return this.ratisServer.removeSCM(request);
    }

    void stopServices() throws Exception {
        this.scm.getScmMetadataStore().stop();
    }

    @VisibleForTesting
    public void startServices() throws IOException {
        SCMMetadataStore metadataStore = this.scm.getScmMetadataStore();
        metadataStore.start(this.ozoneConf);
        this.scm.getSequenceIdGen().reinitialize((Table<String, Long>)metadataStore.getSequenceIdTable());
        this.scm.getPipelineManager().reinitialize((Table<PipelineID, Pipeline>)metadataStore.getPipelineTable());
        this.scm.getContainerManager().reinitialize((Table<ContainerID, ContainerInfo>)metadataStore.getContainerTable());
        this.scm.getScmBlockManager().getDeletedBlockLog().reinitialize((Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>)metadataStore.getDeletedBlocksTXTable());
        this.scm.getStatefulServiceStateManager().reinitialize((Table<String, ByteString>)metadataStore.getStatefulServiceConfigTable());
        if (OzoneSecurityUtil.isSecurityEnabled((ConfigurationSource)this.conf)) {
            if (this.scm.getRootCertificateServer() != null) {
                this.scm.getRootCertificateServer().reinitialize(metadataStore);
            }
            this.scm.getScmCertificateServer().reinitialize(metadataStore);
        }
        this.scm.getFinalizationManager().reinitialize((Table<String, String>)metadataStore.getMetaTable());
    }

    @VisibleForTesting
    public void setExitManagerForTesting(ExitManager exitManagerForTesting) {
        this.exitManager = exitManagerForTesting;
    }

    @VisibleForTesting
    public void stopGrpcService() {
        this.grpcServer.stop();
    }

    @VisibleForTesting
    public static Logger getLogger() {
        return LOG;
    }
}

