/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.pipeline;

import java.io.IOException;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.conf.ReconfigurableConfig;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.scm.container.ContainerInfo;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.scm.pipeline.WritableContainerProvider;
import org.apache.hadoop.hdds.scm.pipeline.WritableECContainerProvider;
import org.apache.hadoop.hdds.scm.pipeline.WritableRatisContainerProvider;
import org.apache.hadoop.hdds.scm.server.StorageContainerManager;

public class WritableContainerFactory {
    private final WritableContainerProvider<ReplicationConfig> ratisProvider;
    private final WritableContainerProvider<ReplicationConfig> standaloneProvider;
    private final WritableContainerProvider<ECReplicationConfig> ecProvider;

    public WritableContainerFactory(StorageContainerManager scm) {
        OzoneConfiguration conf = scm.getConfiguration();
        this.ratisProvider = new WritableRatisContainerProvider(scm.getPipelineManager(), scm.getContainerManager(), scm.getPipelineChoosePolicy());
        this.standaloneProvider = this.ratisProvider;
        WritableECContainerProvider.WritableECContainerProviderConfig ecProviderConfig = (WritableECContainerProvider.WritableECContainerProviderConfig)((Object)conf.getObject(WritableECContainerProvider.WritableECContainerProviderConfig.class));
        this.ecProvider = new WritableECContainerProvider(ecProviderConfig, this.getConfiguredContainerSize((ConfigurationSource)conf), scm.getScmNodeManager(), scm.getPipelineManager(), scm.getContainerManager(), scm.getEcPipelineChoosePolicy());
        scm.getReconfigurationHandler().register((ReconfigurableConfig)ecProviderConfig);
    }

    public ContainerInfo getContainer(long size, ReplicationConfig repConfig, String owner, ExcludeList excludeList) throws IOException {
        switch (repConfig.getReplicationType()) {
            case STAND_ALONE: {
                return this.standaloneProvider.getContainer(size, repConfig, owner, excludeList);
            }
            case RATIS: {
                return this.ratisProvider.getContainer(size, repConfig, owner, excludeList);
            }
            case EC: {
                return this.ecProvider.getContainer(size, (ECReplicationConfig)repConfig, owner, excludeList);
            }
        }
        throw new IOException(repConfig.getReplicationType() + " is an invalid replication type");
    }

    private long getConfiguredContainerSize(ConfigurationSource conf) {
        return (long)conf.getStorageSize("ozone.scm.container.size", "5GB", StorageUnit.BYTES);
    }
}

