/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.protobuf.MessageLite;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.TableCacheMetrics;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.RDBCheckpointUtils;
import org.apache.hadoop.hdds.utils.db.RocksDBConfiguration;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.hdds.utils.db.cache.TableCache;
import org.apache.hadoop.ozone.ClientVersion;
import org.apache.hadoop.ozone.OmUtils;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.ExpiredOpenKeys;
import org.apache.hadoop.ozone.om.ListIterator;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMPerformanceMetrics;
import org.apache.hadoop.ozone.om.OMStorage;
import org.apache.hadoop.ozone.om.OmSnapshot;
import org.apache.hadoop.ozone.om.OmSnapshotManager;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PendingKeysDeletion;
import org.apache.hadoop.ozone.om.S3Batcher;
import org.apache.hadoop.ozone.om.S3SecretStore;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.codec.TokenIdentifierCodec;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.ListKeysResult;
import org.apache.hadoop.ozone.om.helpers.ListOpenFilesResult;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDBAccessIdInfo;
import org.apache.hadoop.ozone.om.helpers.OmDBTenantState;
import org.apache.hadoop.ozone.om.helpers.OmDBUserPrincipalInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfoGroup;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUpload;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.OzoneFSUtils;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.helpers.WithMetadata;
import org.apache.hadoop.ozone.om.lock.IOzoneManagerLock;
import org.apache.hadoop.ozone.om.lock.OmReadOnlyLock;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.protocolPB.OzoneManagerProtocolClientSideTranslatorPB;
import org.apache.hadoop.ozone.om.request.file.OMFileRequest;
import org.apache.hadoop.ozone.om.request.util.OMMultipartUploadUtils;
import org.apache.hadoop.ozone.om.service.SnapshotDeletingService;
import org.apache.hadoop.ozone.om.snapshot.ReferenceCounted;
import org.apache.hadoop.ozone.om.snapshot.SnapshotUtils;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.snapshot.ListSnapshotResponse;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;
import org.apache.hadoop.util.Time;
import org.apache.ozone.compaction.log.CompactionLogEntry;
import org.apache.ratis.util.ExitUtils;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmMetadataManagerImpl
implements OMMetadataManager,
S3SecretStore {
    private static final Logger LOG = LoggerFactory.getLogger(OmMetadataManagerImpl.class);
    public static final String USER_TABLE = "userTable";
    public static final String VOLUME_TABLE = "volumeTable";
    public static final String BUCKET_TABLE = "bucketTable";
    public static final String KEY_TABLE = "keyTable";
    public static final String DELETED_TABLE = "deletedTable";
    public static final String OPEN_KEY_TABLE = "openKeyTable";
    public static final String MULTIPARTINFO_TABLE = "multipartInfoTable";
    public static final String S3_SECRET_TABLE = "s3SecretTable";
    public static final String DELEGATION_TOKEN_TABLE = "dTokenTable";
    public static final String PREFIX_TABLE = "prefixTable";
    public static final String DIRECTORY_TABLE = "directoryTable";
    public static final String FILE_TABLE = "fileTable";
    public static final String OPEN_FILE_TABLE = "openFileTable";
    public static final String DELETED_DIR_TABLE = "deletedDirectoryTable";
    public static final String TRANSACTION_INFO_TABLE = "transactionInfoTable";
    public static final String META_TABLE = "metaTable";
    public static final String TENANT_ACCESS_ID_TABLE = "tenantAccessIdTable";
    public static final String PRINCIPAL_TO_ACCESS_IDS_TABLE = "principalToAccessIdsTable";
    public static final String TENANT_STATE_TABLE = "tenantStateTable";
    public static final String SNAPSHOT_INFO_TABLE = "snapshotInfoTable";
    public static final String SNAPSHOT_RENAMED_TABLE = "snapshotRenamedTable";
    public static final String COMPACTION_LOG_TABLE = "compactionLogTable";
    static final String[] ALL_TABLES = new String[]{"userTable", "volumeTable", "bucketTable", "keyTable", "deletedTable", "openKeyTable", "multipartInfoTable", "s3SecretTable", "dTokenTable", "prefixTable", "transactionInfoTable", "directoryTable", "fileTable", "deletedDirectoryTable", "openFileTable", "metaTable", "tenantAccessIdTable", "principalToAccessIdsTable", "tenantStateTable", "snapshotInfoTable", "snapshotRenamedTable", "compactionLogTable"};
    private DBStore store;
    private final IOzoneManagerLock lock;
    private Table userTable;
    private Table volumeTable;
    private Table bucketTable;
    private Table<String, OmKeyInfo> keyTable;
    private Table deletedTable;
    private Table<String, OmKeyInfo> openKeyTable;
    private Table<String, OmMultipartKeyInfo> multipartInfoTable;
    private Table<String, S3SecretValue> s3SecretTable;
    private Table dTokenTable;
    private Table prefixTable;
    private Table<String, OmDirectoryInfo> dirTable;
    private Table<String, OmKeyInfo> fileTable;
    private Table<String, OmKeyInfo> openFileTable;
    private Table transactionInfoTable;
    private Table metaTable;
    private Table tenantAccessIdTable;
    private Table principalToAccessIdsTable;
    private Table tenantStateTable;
    private Table snapshotInfoTable;
    private Table snapshotRenamedTable;
    private Table compactionLogTable;
    private Table deletedDirTable;
    private OzoneManager ozoneManager;
    private final long omEpoch;
    private Map<String, Table> tableMap = new HashMap<String, Table>();
    private final Map<String, TableCacheMetrics> tableCacheMetricsMap = new HashMap<String, TableCacheMetrics>();
    private SnapshotChainManager snapshotChainManager;
    private final OMPerformanceMetrics perfMetrics;
    private final S3Batcher s3Batcher = new S3SecretBatcher();

    public OmMetadataManagerImpl(OzoneConfiguration conf, OzoneManager ozoneManager) throws IOException {
        this.ozoneManager = ozoneManager;
        this.perfMetrics = this.ozoneManager == null ? null : this.ozoneManager.getPerfMetrics();
        this.lock = new OzoneManagerLock((ConfigurationSource)conf);
        this.omEpoch = OmUtils.getOMEpoch();
        this.start(conf);
    }

    protected OmMetadataManagerImpl() {
        OzoneConfiguration conf = new OzoneConfiguration();
        this.lock = new OzoneManagerLock((ConfigurationSource)conf);
        this.omEpoch = 0L;
        this.perfMetrics = null;
    }

    public static OmMetadataManagerImpl createCheckpointMetadataManager(OzoneConfiguration conf, DBCheckpoint checkpoint) throws IOException {
        Path path = checkpoint.getCheckpointLocation();
        Path parent = path.getParent();
        if (parent == null) {
            throw new IllegalStateException("DB checkpoint parent path should not have been null. Checkpoint path is " + path);
        }
        File dir = parent.toFile();
        Path name = path.getFileName();
        if (name == null) {
            throw new IllegalStateException("DB checkpoint dir name should not have been null. Checkpoint path is " + path);
        }
        return new OmMetadataManagerImpl(conf, dir, name.toString());
    }

    private OmMetadataManagerImpl(OzoneConfiguration conf, File dir, String name) throws IOException {
        this.lock = new OmReadOnlyLock();
        this.omEpoch = 0L;
        int maxOpenFiles = conf.getInt("ozone.om.snapshot.db.max.open.files", 100);
        this.setStore(OmMetadataManagerImpl.loadDB(conf, dir, name, true, Optional.of(Boolean.TRUE), maxOpenFiles, false, false, true));
        this.initializeOmTables(TableCache.CacheType.PARTIAL_CACHE, false);
        this.perfMetrics = null;
    }

    OmMetadataManagerImpl(OzoneConfiguration conf, String snapshotDirName, boolean isSnapshotInCache, int maxOpenFiles) throws IOException {
        try {
            this.lock = new OmReadOnlyLock();
            this.omEpoch = 0L;
            String snapshotDir = OMStorage.getOmDbDir((ConfigurationSource)conf) + "/" + "db.snapshots/checkpointState";
            File metaDir = new File(snapshotDir);
            String dbName = "om.db" + snapshotDirName;
            Duration maxPollDuration = Duration.ofMillis(conf.getTimeDuration("ozone.om.snapshot.checkpoint.dir.creation.poll.timeout", "20s", TimeUnit.MILLISECONDS));
            if (isSnapshotInCache) {
                File checkpoint = Paths.get(metaDir.toPath().toString(), dbName).toFile();
                RDBCheckpointUtils.waitForCheckpointDirectoryExist((File)checkpoint, (Duration)maxPollDuration);
                SnapshotUtils.checkSnapshotDirExist(checkpoint);
            }
            this.setStore(OmMetadataManagerImpl.loadDB(conf, metaDir, dbName, false, Optional.of(Boolean.TRUE), maxOpenFiles, false, false, conf.getBoolean("ozone.om.snapshot.rocksdb.metrics.enabled", false)));
            this.initializeOmTables(TableCache.CacheType.PARTIAL_CACHE, false);
        }
        catch (IOException e) {
            this.stop();
            throw e;
        }
        this.perfMetrics = null;
    }

    public OzoneManager getOzoneManager() {
        return this.ozoneManager;
    }

    public Table<String, OzoneManagerStorageProtos.PersistedUserVolumeInfo> getUserTable() {
        return this.userTable;
    }

    public Table<OzoneTokenIdentifier, Long> getDelegationTokenTable() {
        return this.dTokenTable;
    }

    public Table<String, OmVolumeArgs> getVolumeTable() {
        return this.volumeTable;
    }

    public Table<String, OmBucketInfo> getBucketTable() {
        return this.bucketTable;
    }

    public Table<String, OmKeyInfo> getKeyTable(BucketLayout bucketLayout) {
        if (bucketLayout.isFileSystemOptimized()) {
            return this.fileTable;
        }
        return this.keyTable;
    }

    public Table<String, OmKeyInfo> getFileTable() {
        return this.fileTable;
    }

    public Table<String, RepeatedOmKeyInfo> getDeletedTable() {
        return this.deletedTable;
    }

    public Table<String, OmKeyInfo> getDeletedDirTable() {
        return this.deletedDirTable;
    }

    public Table<String, OmKeyInfo> getOpenKeyTable(BucketLayout bucketLayout) {
        if (bucketLayout.isFileSystemOptimized()) {
            return this.openFileTable;
        }
        return this.openKeyTable;
    }

    public Table<String, OmPrefixInfo> getPrefixTable() {
        return this.prefixTable;
    }

    public Table<String, OmDirectoryInfo> getDirectoryTable() {
        return this.dirTable;
    }

    public Table<String, OmMultipartKeyInfo> getMultipartInfoTable() {
        return this.multipartInfoTable;
    }

    private void checkTableStatus(Table table, String name, boolean addCacheMetrics) throws IOException {
        String logMessage = "Unable to get a reference to %s table. Cannot continue.";
        String errMsg = "Inconsistent DB state, Table - %s. Please check the logsfor more info.";
        if (table == null) {
            LOG.error(String.format(logMessage, name));
            throw new IOException(String.format(errMsg, name));
        }
        this.tableMap.put(name, table);
        if (addCacheMetrics) {
            if (this.tableCacheMetricsMap.containsKey(name)) {
                this.tableCacheMetricsMap.get(name).unregister();
            }
            this.tableCacheMetricsMap.put(name, table.createCacheMetrics());
        }
    }

    public void start(OzoneConfiguration configuration) throws IOException {
        if (this.store == null) {
            File metaDir = OMStorage.getOmDbDir((ConfigurationSource)configuration);
            File markerFile = new File(metaDir, "dbInconsistentMarker");
            if (markerFile.exists()) {
                LOG.error("File {} marks that OM DB is in an inconsistent state.", (Object)markerFile);
                String errorMsg = "Cannot load OM DB as it is in an inconsistent state.";
                ExitUtils.terminate((int)1, (String)errorMsg, (Logger)LOG);
            }
            RocksDBConfiguration cfr_ignored_0 = (RocksDBConfiguration)configuration.getObject(RocksDBConfiguration.class);
            int maxOpenFiles = configuration.getInt("ozone.om.db.max.open.files", -1);
            this.store = OmMetadataManagerImpl.loadDB(configuration, metaDir, maxOpenFiles);
            this.initializeOmTables(TableCache.CacheType.FULL_CACHE, true);
        }
        this.snapshotChainManager = new SnapshotChainManager(this);
    }

    public static DBStore loadDB(OzoneConfiguration configuration, File metaDir, int maxOpenFiles) throws IOException {
        return OmMetadataManagerImpl.loadDB(configuration, metaDir, "om.db", false, Optional.empty(), maxOpenFiles, true, true, true);
    }

    public static DBStore loadDB(OzoneConfiguration configuration, File metaDir, String dbName, boolean readOnly, Optional<Boolean> disableAutoCompaction, int maxOpenFiles, boolean enableCompactionDag, boolean createCheckpointDirs, boolean enableRocksDBMetrics) throws IOException {
        int maxFSSnapshots = configuration.getInt("ozone.om.fs.snapshot.max.limit", 1000);
        RocksDBConfiguration rocksDBConfiguration = (RocksDBConfiguration)configuration.getObject(RocksDBConfiguration.class);
        DBStoreBuilder dbStoreBuilder = DBStoreBuilder.newBuilder((ConfigurationSource)configuration, (RocksDBConfiguration)rocksDBConfiguration).setName(dbName).setOpenReadOnly(readOnly).setPath(Paths.get(metaDir.getPath(), new String[0])).setMaxFSSnapshots(maxFSSnapshots).setEnableCompactionDag(enableCompactionDag).setCreateCheckpointDirs(createCheckpointDirs).setMaxNumberOfOpenFiles(Integer.valueOf(maxOpenFiles)).setEnableRocksDbMetrics(enableRocksDBMetrics);
        disableAutoCompaction.ifPresent(arg_0 -> ((DBStoreBuilder)dbStoreBuilder).disableDefaultCFAutoCompaction(arg_0));
        return OmMetadataManagerImpl.addOMTablesAndCodecs(dbStoreBuilder).build();
    }

    public static DBStoreBuilder addOMTablesAndCodecs(DBStoreBuilder builder) {
        return builder.addTable(USER_TABLE).addTable(VOLUME_TABLE).addTable(BUCKET_TABLE).addTable(KEY_TABLE).addTable(DELETED_TABLE).addTable(OPEN_KEY_TABLE).addTable(MULTIPARTINFO_TABLE).addTable(DELEGATION_TOKEN_TABLE).addTable(S3_SECRET_TABLE).addTable(PREFIX_TABLE).addTable(DIRECTORY_TABLE).addTable(FILE_TABLE).addTable(OPEN_FILE_TABLE).addTable(DELETED_DIR_TABLE).addTable(TRANSACTION_INFO_TABLE).addTable(META_TABLE).addTable(TENANT_ACCESS_ID_TABLE).addTable(PRINCIPAL_TO_ACCESS_IDS_TABLE).addTable(TENANT_STATE_TABLE).addTable(SNAPSHOT_INFO_TABLE).addTable(SNAPSHOT_RENAMED_TABLE).addTable(COMPACTION_LOG_TABLE).addCodec(OzoneTokenIdentifier.class, TokenIdentifierCodec.get()).addCodec(OmKeyInfo.class, OmKeyInfo.getCodec((boolean)true)).addCodec(RepeatedOmKeyInfo.class, RepeatedOmKeyInfo.getCodec((boolean)true)).addCodec(OmBucketInfo.class, OmBucketInfo.getCodec()).addCodec(OmVolumeArgs.class, OmVolumeArgs.getCodec()).addProto2Codec((MessageLite)OzoneManagerStorageProtos.PersistedUserVolumeInfo.getDefaultInstance()).addCodec(OmMultipartKeyInfo.class, OmMultipartKeyInfo.getCodec()).addCodec(S3SecretValue.class, S3SecretValue.getCodec()).addCodec(OmPrefixInfo.class, OmPrefixInfo.getCodec()).addCodec(TransactionInfo.class, TransactionInfo.getCodec()).addCodec(OmDirectoryInfo.class, OmDirectoryInfo.getCodec()).addCodec(OmDBTenantState.class, OmDBTenantState.getCodec()).addCodec(OmDBAccessIdInfo.class, OmDBAccessIdInfo.getCodec()).addCodec(OmDBUserPrincipalInfo.class, OmDBUserPrincipalInfo.getCodec()).addCodec(SnapshotInfo.class, SnapshotInfo.getCodec()).addCodec(CompactionLogEntry.class, CompactionLogEntry.getCodec());
    }

    protected void initializeOmTables(TableCache.CacheType cacheType, boolean addCacheMetrics) throws IOException {
        this.userTable = this.store.getTable(USER_TABLE, String.class, OzoneManagerStorageProtos.PersistedUserVolumeInfo.class);
        this.checkTableStatus(this.userTable, USER_TABLE, addCacheMetrics);
        this.volumeTable = this.store.getTable(VOLUME_TABLE, String.class, OmVolumeArgs.class, cacheType);
        this.checkTableStatus(this.volumeTable, VOLUME_TABLE, addCacheMetrics);
        this.bucketTable = this.store.getTable(BUCKET_TABLE, String.class, OmBucketInfo.class, cacheType);
        this.checkTableStatus(this.bucketTable, BUCKET_TABLE, addCacheMetrics);
        this.keyTable = this.store.getTable(KEY_TABLE, String.class, OmKeyInfo.class);
        this.checkTableStatus(this.keyTable, KEY_TABLE, addCacheMetrics);
        this.deletedTable = this.store.getTable(DELETED_TABLE, String.class, RepeatedOmKeyInfo.class);
        this.checkTableStatus(this.deletedTable, DELETED_TABLE, addCacheMetrics);
        this.openKeyTable = this.store.getTable(OPEN_KEY_TABLE, String.class, OmKeyInfo.class);
        this.checkTableStatus(this.openKeyTable, OPEN_KEY_TABLE, addCacheMetrics);
        this.multipartInfoTable = this.store.getTable(MULTIPARTINFO_TABLE, String.class, OmMultipartKeyInfo.class);
        this.checkTableStatus(this.multipartInfoTable, MULTIPARTINFO_TABLE, addCacheMetrics);
        this.dTokenTable = this.store.getTable(DELEGATION_TOKEN_TABLE, OzoneTokenIdentifier.class, Long.class);
        this.checkTableStatus(this.dTokenTable, DELEGATION_TOKEN_TABLE, addCacheMetrics);
        this.s3SecretTable = this.store.getTable(S3_SECRET_TABLE, String.class, S3SecretValue.class);
        this.checkTableStatus(this.s3SecretTable, S3_SECRET_TABLE, addCacheMetrics);
        this.prefixTable = this.store.getTable(PREFIX_TABLE, String.class, OmPrefixInfo.class);
        this.checkTableStatus(this.prefixTable, PREFIX_TABLE, addCacheMetrics);
        this.dirTable = this.store.getTable(DIRECTORY_TABLE, String.class, OmDirectoryInfo.class);
        this.checkTableStatus(this.dirTable, DIRECTORY_TABLE, addCacheMetrics);
        this.fileTable = this.store.getTable(FILE_TABLE, String.class, OmKeyInfo.class);
        this.checkTableStatus(this.fileTable, FILE_TABLE, addCacheMetrics);
        this.openFileTable = this.store.getTable(OPEN_FILE_TABLE, String.class, OmKeyInfo.class);
        this.checkTableStatus(this.openFileTable, OPEN_FILE_TABLE, addCacheMetrics);
        this.deletedDirTable = this.store.getTable(DELETED_DIR_TABLE, String.class, OmKeyInfo.class);
        this.checkTableStatus(this.deletedDirTable, DELETED_DIR_TABLE, addCacheMetrics);
        this.transactionInfoTable = this.store.getTable(TRANSACTION_INFO_TABLE, String.class, TransactionInfo.class);
        this.checkTableStatus(this.transactionInfoTable, TRANSACTION_INFO_TABLE, addCacheMetrics);
        this.metaTable = this.store.getTable(META_TABLE, String.class, String.class);
        this.checkTableStatus(this.metaTable, META_TABLE, addCacheMetrics);
        this.tenantAccessIdTable = this.store.getTable(TENANT_ACCESS_ID_TABLE, String.class, OmDBAccessIdInfo.class);
        this.checkTableStatus(this.tenantAccessIdTable, TENANT_ACCESS_ID_TABLE, addCacheMetrics);
        this.principalToAccessIdsTable = this.store.getTable(PRINCIPAL_TO_ACCESS_IDS_TABLE, String.class, OmDBUserPrincipalInfo.class);
        this.checkTableStatus(this.principalToAccessIdsTable, PRINCIPAL_TO_ACCESS_IDS_TABLE, addCacheMetrics);
        this.tenantStateTable = this.store.getTable(TENANT_STATE_TABLE, String.class, OmDBTenantState.class);
        this.checkTableStatus(this.tenantStateTable, TENANT_STATE_TABLE, addCacheMetrics);
        this.snapshotInfoTable = this.store.getTable(SNAPSHOT_INFO_TABLE, String.class, SnapshotInfo.class);
        this.checkTableStatus(this.snapshotInfoTable, SNAPSHOT_INFO_TABLE, addCacheMetrics);
        this.snapshotRenamedTable = this.store.getTable(SNAPSHOT_RENAMED_TABLE, String.class, String.class);
        this.checkTableStatus(this.snapshotRenamedTable, SNAPSHOT_RENAMED_TABLE, addCacheMetrics);
        this.compactionLogTable = this.store.getTable(COMPACTION_LOG_TABLE, String.class, CompactionLogEntry.class);
        this.checkTableStatus(this.compactionLogTable, COMPACTION_LOG_TABLE, addCacheMetrics);
    }

    public void stop() throws IOException {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        this.tableCacheMetricsMap.values().forEach(TableCacheMetrics::unregister);
        this.lock.cleanup();
    }

    @VisibleForTesting
    public DBStore getStore() {
        return this.store;
    }

    public String getVolumeKey(String volume) {
        return "/" + volume;
    }

    public String getUserKey(String user) {
        return user;
    }

    public String getBucketKey(String volume, String bucket) {
        StringBuilder builder = new StringBuilder().append("/").append(volume);
        if (StringUtils.isNotBlank((CharSequence)bucket)) {
            builder.append("/").append(bucket);
        }
        return builder.toString();
    }

    public String getBucketKeyPrefix(String volume, String bucket) {
        return this.getOzoneKey(volume, bucket, "/");
    }

    public String getBucketKeyPrefixFSO(String volume, String bucket) throws IOException {
        return this.getOzoneKeyFSO(volume, bucket, "/");
    }

    public String getOzoneKey(String volume, String bucket, String key) {
        StringBuilder builder = new StringBuilder().append("/").append(volume);
        builder.append("/").append(bucket);
        if (StringUtil.isNotBlank((String)key)) {
            builder.append("/");
            if (!key.equals("/")) {
                builder.append(key);
            }
        }
        return builder.toString();
    }

    public String getOzoneKeyFSO(String volumeName, String bucketName, String keyPrefix) throws IOException {
        long volumeId = this.getVolumeId(volumeName);
        long bucketId = this.getBucketId(volumeName, bucketName);
        return this.getOzoneKey(Long.toString(volumeId), Long.toString(bucketId), keyPrefix);
    }

    public String getOzoneDirKey(String volume, String bucket, String key) {
        key = OzoneFSUtils.addTrailingSlashIfNeeded((String)key);
        return this.getOzoneKey(volume, bucket, key);
    }

    public String getOpenKey(String volume, String bucket, String key, String clientId) {
        String openKey = "/" + volume + "/" + bucket + "/" + key + "/" + clientId;
        return openKey;
    }

    public String getMultipartKey(String volume, String bucket, String key, String uploadId) {
        return OmMultipartUpload.getDbKey((String)volume, (String)bucket, (String)key, (String)uploadId);
    }

    public String getMultipartKeyFSO(String volume, String bucket, String key, String uploadId) throws IOException {
        long parentId;
        long volumeId = this.getVolumeId(volume);
        long bucketId = this.getBucketId(volume, bucket);
        try {
            parentId = OMFileRequest.getParentID(volumeId, bucketId, key, this);
        }
        catch (Exception e) {
            LOG.warn("Got exception when finding parent id for {}/{}/{}. Use another way to get it", new Object[]{volumeId, bucketId, key, e});
            String multipartKey = this.getMultipartKey(volume, bucket, key, uploadId);
            OmMultipartKeyInfo multipartKeyInfo = (OmMultipartKeyInfo)this.getMultipartInfoTable().get((Object)multipartKey);
            if (multipartKeyInfo == null) {
                LOG.error("Could not find multipartKeyInfo for {}", (Object)multipartKey);
                throw new OMException(OMException.ResultCodes.NO_SUCH_MULTIPART_UPLOAD_ERROR);
            }
            parentId = multipartKeyInfo.getParentID();
        }
        String fileName = OzoneFSUtils.getFileName((String)key);
        return this.getMultipartKey(volumeId, bucketId, parentId, fileName, uploadId);
    }

    public IOzoneManagerLock getLock() {
        return this.lock;
    }

    public long getOmEpoch() {
        return this.omEpoch;
    }

    public boolean isVolumeEmpty(String volume) throws IOException {
        String volumePrefix = this.getVolumeKey(String.valueOf(volume) + "/");
        if (this.isKeyPresentInTableCache(volumePrefix, this.bucketTable)) {
            return false;
        }
        return !this.isKeyPresentInTable(volumePrefix, this.bucketTable);
    }

    public boolean isBucketEmpty(String volume, String bucket) throws IOException {
        Table<String, OmKeyInfo> table;
        String bucketKey = this.getBucketKey(volume, bucket);
        OmBucketInfo omBucketInfo = (OmBucketInfo)this.getBucketTable().get((Object)bucketKey);
        String volumeId = String.valueOf(this.getVolumeId(omBucketInfo.getVolumeName()));
        String bucketId = String.valueOf(omBucketInfo.getObjectID());
        BucketLayout bucketLayout = omBucketInfo.getBucketLayout();
        String keyPrefix = bucketLayout.isFileSystemOptimized() ? "/" + volumeId + "/" + bucketId + "/" + bucketId + "/" : OzoneFSUtils.addTrailingSlashIfNeeded((String)bucketKey);
        if (this.isKeyPresentInTableCache(keyPrefix, table = this.getKeyTable(bucketLayout))) {
            return false;
        }
        if (this.isKeyPresentInTable(keyPrefix, table)) {
            return false;
        }
        if (bucketLayout.isFileSystemOptimized()) {
            if (this.isKeyPresentInTableCache(keyPrefix, this.dirTable)) {
                return false;
            }
            return !this.isKeyPresentInTable(keyPrefix, this.dirTable);
        }
        return true;
    }

    private <T> boolean isKeyPresentInTableCache(String keyPrefix, Table<String, T> table) {
        Iterator iterator = table.cacheIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)((CacheKey)entry.getKey()).getCacheKey();
            Object value = ((CacheValue)entry.getValue()).getCacheValue();
            if (!key.startsWith(keyPrefix) || value == null) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> boolean isKeyPresentInTable(String keyPrefix, Table<String, T> table) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TableIterator keyIter = table.iterator((Object)keyPrefix);){
            Table.KeyValue kv = null;
            if (keyIter.hasNext()) {
                kv = (Table.KeyValue)keyIter.next();
            }
            while (kv != null) {
                if (!((String)kv.getKey()).startsWith(keyPrefix)) {
                    return false;
                }
                CacheValue cacheValue = table.getCacheValue(new CacheKey((Object)((String)kv.getKey())));
                if (cacheValue == null ? table.getIfExist((Object)((String)kv.getKey())) != null : cacheValue.getCacheValue() != null) {
                    return true;
                }
                if (!keyIter.hasNext()) {
                    return false;
                }
                kv = (Table.KeyValue)keyIter.next();
            }
            return false;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public List<OmBucketInfo> listBuckets(String volumeName, String startBucket, String bucketPrefix, int maxNumOfBuckets, boolean hasSnapshot) throws IOException {
        String startKey;
        ArrayList<OmBucketInfo> result = new ArrayList<OmBucketInfo>();
        if (Strings.isNullOrEmpty((String)volumeName)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        String volumeNameBytes = this.getVolumeKey(volumeName);
        if (this.volumeTable.get((Object)volumeNameBytes) == null) {
            throw new OMException("Volume " + volumeName + " not found.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        boolean skipStartKey = false;
        if (StringUtil.isNotBlank((String)startBucket)) {
            startKey = this.getBucketKey(volumeName, startBucket);
            skipStartKey = true;
        } else {
            startKey = this.getBucketKey(volumeName, bucketPrefix);
        }
        String seekPrefix = StringUtil.isNotBlank((String)bucketPrefix) ? this.getBucketKey(volumeName, bucketPrefix) : this.getVolumeKey(String.valueOf(volumeName) + "/");
        int currentCount = 0;
        Iterator iterator = this.bucketTable.cacheIterator();
        while (currentCount < maxNumOfBuckets && iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)((CacheKey)entry.getKey()).getCacheKey();
            OmBucketInfo omBucketInfo = (OmBucketInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (omBucketInfo == null || key.equals(startKey) && skipStartKey || !key.startsWith(seekPrefix) || key.compareTo(startKey) < 0) continue;
            if (!hasSnapshot) {
                result.add(omBucketInfo);
                ++currentCount;
                continue;
            }
            if (!Objects.nonNull(this.snapshotChainManager.getLatestPathSnapshotId(String.valueOf(volumeName) + "/" + omBucketInfo.getBucketName()))) continue;
            result.add(omBucketInfo);
            ++currentCount;
        }
        return result;
    }

    public Iterator<Map.Entry<CacheKey<String>, CacheValue<OmBucketInfo>>> getBucketIterator() {
        return this.bucketTable.cacheIterator();
    }

    public TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> getKeyIterator() throws IOException {
        return this.keyTable.iterator();
    }

    public ListOpenFilesResult listOpenFiles(BucketLayout bucketLayout, int maxKeys, String dbOpenKeyPrefix, boolean hasContToken, String dbContTokenPrefix) throws IOException {
        String retContToken;
        boolean hasMore;
        ArrayList<OpenKeySession> openKeySessionList = new ArrayList<OpenKeySession>();
        int currentCount = 0;
        Table<String, OmKeyInfo> okTable = this.getOpenKeyTable(bucketLayout);
        Throwable throwable = null;
        Object var12_11 = null;
        try (TableIterator openKeyIter = okTable.iterator();){
            Table.KeyValue nextKv;
            Table.KeyValue kv = (Table.KeyValue)openKeyIter.seek((Object)dbContTokenPrefix);
            if (hasContToken && ((String)kv.getKey()).equals(dbContTokenPrefix)) {
                openKeyIter.next();
            }
            while (currentCount < maxKeys && openKeyIter.hasNext()) {
                kv = (Table.KeyValue)openKeyIter.next();
                if (kv == null || !((String)kv.getKey()).startsWith(dbOpenKeyPrefix)) continue;
                String dbKey = (String)kv.getKey();
                long clientID = OMMetadataManager.getClientIDFromOpenKeyDBKey((String)dbKey);
                OmKeyInfo omKeyInfo = (OmKeyInfo)kv.getValue();
                openKeySessionList.add(new OpenKeySession(clientID, omKeyInfo, omKeyInfo.getLatestVersionLocations().getVersion()));
                ++currentCount;
            }
            hasMore = openKeyIter.hasNext() ? (nextKv = (Table.KeyValue)openKeyIter.next()) != null && ((String)nextKv.getKey()).startsWith(dbOpenKeyPrefix) : false;
            retContToken = hasMore ? (String)kv.getKey() : null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new ListOpenFilesResult(this.getTotalOpenKeyCount(), hasMore, retContToken, openKeySessionList);
    }

    public ListKeysResult listKeys(String volumeName, String bucketName, String startKey, String keyPrefix, int maxKeys) throws IOException {
        boolean isTruncated;
        long readFromRDbStartNs;
        String seekKey;
        long startNanos = Time.monotonicNowNanos();
        ArrayList<OmKeyInfo> result = new ArrayList<OmKeyInfo>();
        if (maxKeys <= 0) {
            return new ListKeysResult(result, false);
        }
        if (Strings.isNullOrEmpty((String)volumeName)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)bucketName)) {
            throw new OMException("Bucket name is required.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        String bucketNameBytes = this.getBucketKey(volumeName, bucketName);
        if (this.getBucketTable().get((Object)bucketNameBytes) == null) {
            throw new OMException("Bucket " + bucketName + " not found.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        boolean skipStartKey = false;
        if (StringUtil.isNotBlank((String)startKey)) {
            seekKey = this.getOzoneKey(volumeName, bucketName, startKey);
            skipStartKey = true;
        } else {
            seekKey = this.getOzoneKey(volumeName, bucketName, StringUtil.isNotBlank((String)keyPrefix) ? keyPrefix : "/");
        }
        String seekPrefix = StringUtil.isNotBlank((String)keyPrefix) ? this.getOzoneKey(volumeName, bucketName, keyPrefix) : String.valueOf(this.getBucketKey(volumeName, bucketName)) + "/";
        int currentCount = 0;
        TreeMap<String, OmKeyInfo> cacheKeyMap = new TreeMap<String, OmKeyInfo>();
        Iterator iterator = this.keyTable.cacheIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)((CacheKey)entry.getKey()).getCacheKey();
            OmKeyInfo omKeyInfo = (OmKeyInfo)((CacheValue)entry.getValue()).getCacheValue();
            if (omKeyInfo == null || !key.startsWith(seekPrefix) || key.compareTo(seekKey) < 0) continue;
            cacheKeyMap.put(key, omKeyInfo);
        }
        long readFromRDbStopNs = 0L;
        Throwable throwable = null;
        Object var21_23 = null;
        try (TableIterator keyIter = this.getKeyTable(this.getBucketLayout()).iterator();){
            readFromRDbStartNs = Time.monotonicNowNanos();
            keyIter.seek((Object)seekKey);
            while (currentCount < maxKeys + 1 && keyIter.hasNext()) {
                Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                if (kv == null || !((String)kv.getKey()).startsWith(seekPrefix)) break;
                CacheValue cacheValue = this.keyTable.getCacheValue(new CacheKey((Object)((String)kv.getKey())));
                if (cacheValue != null && cacheValue.getCacheValue() == null) continue;
                cacheKeyMap.put((String)kv.getKey(), (OmKeyInfo)kv.getValue());
                ++currentCount;
            }
            readFromRDbStopNs = Time.monotonicNowNanos();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        boolean bl = isTruncated = cacheKeyMap.size() > maxKeys;
        if (this.perfMetrics != null) {
            long keyCount = isTruncated ? (long)maxKeys : (long)cacheKeyMap.size();
            this.perfMetrics.setListKeysAveragePagination(keyCount);
            float opsPerSec = (float)keyCount / ((float)(Time.monotonicNowNanos() - startNanos) / 1.0E9f);
            this.perfMetrics.setListKeysOpsPerSec(opsPerSec);
            this.perfMetrics.addListKeysReadFromRocksDbLatencyNs(readFromRDbStopNs - readFromRDbStartNs);
        }
        currentCount = 0;
        for (Map.Entry cacheKey : cacheKeyMap.entrySet()) {
            if (((String)cacheKey.getKey()).equals(seekKey) && skipStartKey) continue;
            result.add((OmKeyInfo)cacheKey.getValue());
            if (++currentCount == maxKeys) break;
        }
        cacheKeyMap.clear();
        return new ListKeysResult(result, isTruncated);
    }

    public SnapshotInfo getSnapshotInfo(String volumeName, String bucketName, String snapshotName) throws IOException {
        if (Strings.isNullOrEmpty((String)volumeName)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)bucketName)) {
            throw new OMException("Bucket name is required.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)snapshotName)) {
            throw new OMException("Snapshot name is required.", OMException.ResultCodes.FILE_NOT_FOUND);
        }
        return SnapshotUtils.getSnapshotInfo(this.ozoneManager, volumeName, bucketName, snapshotName);
    }

    public ListSnapshotResponse listSnapshot(String volumeName, String bucketName, String snapshotPrefix, String prevSnapshot, int maxListResult) throws IOException {
        if (Strings.isNullOrEmpty((String)volumeName)) {
            throw new OMException("Volume name is required.", OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        if (Strings.isNullOrEmpty((String)bucketName)) {
            throw new OMException("Bucket name is required.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        String bucketNameBytes = this.getBucketKey(volumeName, bucketName);
        if (this.getBucketTable().get((Object)bucketNameBytes) == null) {
            throw new OMException("Bucket " + bucketName + " not found.", OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        String prefix = StringUtil.isNotBlank((String)snapshotPrefix) ? this.getOzoneKey(volumeName, bucketName, snapshotPrefix) : this.getBucketKey(volumeName, String.valueOf(bucketName) + "/");
        String seek = StringUtil.isNotBlank((String)prevSnapshot) ? this.getOzoneKey(volumeName, bucketName, prevSnapshot) : this.getOzoneKey(volumeName, bucketName, StringUtil.isNotBlank((String)snapshotPrefix) ? snapshotPrefix : "/");
        ArrayList snapshotInfos = Lists.newArrayList();
        String lastSnapshot = null;
        try {
            Throwable throwable = null;
            Object var12_15 = null;
            try (ListIterator.MinHeapIterator snapshotIterator = new ListIterator.MinHeapIterator((OMMetadataManager)this, prefix, seek, volumeName, bucketName, this.snapshotInfoTable);){
                SnapshotInfo snapshotInfo = null;
                while (snapshotIterator.hasNext() && maxListResult > 0) {
                    snapshotInfo = (SnapshotInfo)snapshotIterator.next().getValue();
                    if (Objects.equals(snapshotInfo.getName(), prevSnapshot)) continue;
                    snapshotInfos.add(snapshotInfo);
                    --maxListResult;
                }
                if (snapshotIterator.hasNext() && maxListResult == 0 && snapshotInfo != null) {
                    lastSnapshot = snapshotInfo.getName();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchElementException e) {
            throw new IOException(e);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        return new ListSnapshotResponse((List)snapshotInfos, lastSnapshot);
    }

    public List<OmVolumeArgs> listVolumes(String userName, String prefix, String startKey, int maxKeys) throws IOException {
        if (StringUtil.isBlank((String)userName)) {
            return this.listAllVolumes(prefix, startKey, maxKeys);
        }
        ArrayList result = Lists.newArrayList();
        List volumes = this.getVolumesByUser(userName).getVolumeNamesList();
        int index = 0;
        if (!Strings.isNullOrEmpty((String)startKey)) {
            index = volumes.indexOf(startKey.startsWith("/") ? startKey.substring(1) : startKey);
            index = index != -1 ? index + 1 : index;
        }
        String startChar = prefix == null ? "" : prefix;
        while (index != -1 && index < volumes.size() && result.size() < maxKeys) {
            String volumeName = (String)volumes.get(index);
            if (volumeName.startsWith(startChar)) {
                OmVolumeArgs volumeArgs = (OmVolumeArgs)this.getVolumeTable().get((Object)this.getVolumeKey(volumeName));
                if (volumeArgs == null) {
                    throw new OMException("Volume info not found for " + volumeName, OMException.ResultCodes.VOLUME_NOT_FOUND);
                }
                result.add(volumeArgs);
            }
            ++index;
        }
        return result;
    }

    private List<OmVolumeArgs> listAllVolumes(String prefix, String startKey, int maxKeys) {
        ArrayList result = Lists.newArrayList();
        Iterator cacheIterator = this.getVolumeTable().cacheIterator();
        boolean prefixIsEmpty = Strings.isNullOrEmpty((String)prefix);
        boolean startKeyIsEmpty = Strings.isNullOrEmpty((String)startKey);
        while (cacheIterator.hasNext() && result.size() < maxKeys) {
            Map.Entry entry = (Map.Entry)cacheIterator.next();
            OmVolumeArgs omVolumeArgs = (OmVolumeArgs)((CacheValue)entry.getValue()).getCacheValue();
            if (omVolumeArgs == null) continue;
            String volumeName = omVolumeArgs.getVolume();
            if (!prefixIsEmpty && !volumeName.startsWith(prefix)) continue;
            if (!startKeyIsEmpty) {
                if (!volumeName.equals(startKey)) continue;
                startKeyIsEmpty = true;
                continue;
            }
            result.add(omVolumeArgs);
        }
        return result;
    }

    private OzoneManagerStorageProtos.PersistedUserVolumeInfo getVolumesByUser(String userNameKey) throws OMException {
        try {
            OzoneManagerStorageProtos.PersistedUserVolumeInfo userVolInfo = (OzoneManagerStorageProtos.PersistedUserVolumeInfo)this.getUserTable().get((Object)userNameKey);
            if (userVolInfo == null) {
                return OzoneManagerStorageProtos.PersistedUserVolumeInfo.newBuilder().build();
            }
            return userVolInfo;
        }
        catch (IOException e) {
            throw new OMException("Unable to get volumes info by the given user, metadata might be corrupted", (Throwable)e, OMException.ResultCodes.METADATA_ERROR);
        }
    }

    public PendingKeysDeletion getPendingDeletionKeys(int keyCount, OmSnapshotManager omSnapshotManager) throws IOException {
        ArrayList keyBlocksList = Lists.newArrayList();
        HashMap<String, RepeatedOmKeyInfo> keysToModify = new HashMap<String, RepeatedOmKeyInfo>();
        Throwable throwable = null;
        Object var6_7 = null;
        try (TableIterator keyIter = this.getDeletedTable().iterator();){
            int currentCount = 0;
            while (keyIter.hasNext() && currentCount < keyCount) {
                SnapshotInfo previousSnapshotInfo;
                RepeatedOmKeyInfo notReclaimableKeyInfo = new RepeatedOmKeyInfo();
                Table.KeyValue kv = (Table.KeyValue)keyIter.next();
                if (kv == null) continue;
                ArrayList blockGroupList = Lists.newArrayList();
                String[] keySplit = ((String)kv.getKey()).split("/");
                String bucketKey = this.getBucketKey(keySplit[1], keySplit[2]);
                OmBucketInfo bucketInfo = (OmBucketInfo)this.getBucketTable().get((Object)bucketKey);
                SnapshotInfo snapshotInfo = previousSnapshotInfo = bucketInfo == null ? null : SnapshotUtils.getLatestSnapshotInfo(bucketInfo.getVolumeName(), bucketInfo.getBucketName(), this.ozoneManager, this.snapshotChainManager);
                if (previousSnapshotInfo != null && (previousSnapshotInfo.getSnapshotStatus() != SnapshotInfo.SnapshotStatus.SNAPSHOT_ACTIVE || !OmSnapshotManager.areSnapshotChangesFlushedToDB(this.ozoneManager.getMetadataManager(), previousSnapshotInfo))) continue;
                Throwable throwable2 = null;
                Object var17_20 = null;
                try (ReferenceCounted<OmSnapshot> rcLatestSnapshot = previousSnapshotInfo == null ? null : omSnapshotManager.getSnapshot(previousSnapshotInfo.getVolumeName(), previousSnapshotInfo.getBucketName(), previousSnapshotInfo.getName());){
                    SnapshotInfo newPreviousSnapshotInfo;
                    RepeatedOmKeyInfo infoList = (RepeatedOmKeyInfo)kv.getValue();
                    for (OmKeyInfo info : infoList.cloneOmKeyInfoList()) {
                        String dbRenameKey = this.getRenameKey(info.getVolumeName(), info.getBucketName(), info.getObjectID());
                        if (rcLatestSnapshot != null) {
                            Table prevKeyTable = rcLatestSnapshot.get().getMetadataManager().getKeyTable(bucketInfo.getBucketLayout());
                            Table prevDeletedTable = rcLatestSnapshot.get().getMetadataManager().getDeletedTable();
                            String prevKeyTableDBKey = (String)this.getSnapshotRenamedTable().get((Object)dbRenameKey);
                            String prevDelTableDBKey = this.getOzoneKey(info.getVolumeName(), info.getBucketName(), info.getKeyName());
                            prevDelTableDBKey = this.getOzoneDeletePathKey(info.getObjectID(), prevDelTableDBKey);
                            if (prevKeyTableDBKey == null && bucketInfo.getBucketLayout().isFileSystemOptimized()) {
                                long volumeId = this.getVolumeId(info.getVolumeName());
                                prevKeyTableDBKey = this.getOzonePathKey(volumeId, bucketInfo.getObjectID(), info.getParentObjectID(), info.getFileName());
                            } else if (prevKeyTableDBKey == null) {
                                prevKeyTableDBKey = this.getOzoneKey(info.getVolumeName(), info.getBucketName(), info.getKeyName());
                            }
                            OmKeyInfo omKeyInfo = (OmKeyInfo)prevKeyTable.get((Object)prevKeyTableDBKey);
                            RepeatedOmKeyInfo delOmKeyInfo = (RepeatedOmKeyInfo)prevDeletedTable.get((Object)prevDelTableDBKey);
                            if (this.versionExistsInPreviousSnapshot(omKeyInfo, info, delOmKeyInfo)) {
                                if (infoList.getOmKeyInfoList().size() == 1) continue;
                                notReclaimableKeyInfo.addOmKeyInfo(info);
                                continue;
                            }
                        }
                        for (OmKeyLocationInfoGroup keyLocations : info.getKeyLocationVersions()) {
                            List item = keyLocations.getLocationList().stream().map(b -> new BlockID(b.getContainerID(), b.getLocalID())).collect(Collectors.toList());
                            BlockGroup keyBlocks = BlockGroup.newBuilder().setKeyName((String)kv.getKey()).addAllBlockIDs(item).build();
                            blockGroupList.add(keyBlocks);
                        }
                        ++currentCount;
                    }
                    List notReclaimableKeyInfoList = notReclaimableKeyInfo.getOmKeyInfoList();
                    SnapshotInfo snapshotInfo2 = newPreviousSnapshotInfo = bucketInfo == null ? null : SnapshotUtils.getLatestSnapshotInfo(bucketInfo.getVolumeName(), bucketInfo.getBucketName(), this.ozoneManager, this.snapshotChainManager);
                    if (!Objects.equals(Optional.ofNullable(newPreviousSnapshotInfo).map(SnapshotInfo::getSnapshotId), Optional.ofNullable(previousSnapshotInfo).map(SnapshotInfo::getSnapshotId))) continue;
                    if (!notReclaimableKeyInfoList.isEmpty() && notReclaimableKeyInfoList.size() != infoList.getOmKeyInfoList().size()) {
                        keysToModify.put((String)kv.getKey(), notReclaimableKeyInfo);
                    }
                    if (notReclaimableKeyInfoList.size() == infoList.getOmKeyInfoList().size()) continue;
                    keyBlocksList.addAll(blockGroupList);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        return new PendingKeysDeletion(keyBlocksList, keysToModify);
    }

    private boolean versionExistsInPreviousSnapshot(OmKeyInfo omKeyInfo, OmKeyInfo info, RepeatedOmKeyInfo delOmKeyInfo) {
        return omKeyInfo != null && info.getObjectID() == omKeyInfo.getObjectID() && SnapshotDeletingService.isBlockLocationInfoSame(omKeyInfo, info) || delOmKeyInfo != null;
    }

    private boolean isOpenMultipartKey(OmKeyInfo openKeyInfo, String openDbKey) throws IOException {
        if (OMMultipartUploadUtils.isMultipartKeySet(openKeyInfo)) {
            return true;
        }
        String multipartUploadId = OMMultipartUploadUtils.getUploadIdFromDbKey(openDbKey);
        if (StringUtils.isEmpty((CharSequence)multipartUploadId)) {
            return false;
        }
        String multipartInfoDbKey = this.getMultipartKey(openKeyInfo.getVolumeName(), openKeyInfo.getBucketName(), openKeyInfo.getKeyName(), multipartUploadId);
        return this.getMultipartInfoTable().isExist((Object)multipartInfoDbKey);
    }

    public long getTotalOpenKeyCount() throws IOException {
        return this.openKeyTable.getEstimatedKeyCount() + this.openFileTable.getEstimatedKeyCount();
    }

    public ExpiredOpenKeys getExpiredOpenKeys(Duration expireThreshold, int count, BucketLayout bucketLayout, Duration leaseThreshold) throws IOException {
        ExpiredOpenKeys expiredKeys = new ExpiredOpenKeys();
        Table<String, OmKeyInfo> kt = this.getKeyTable(bucketLayout);
        Throwable throwable = null;
        Object var8_9 = null;
        try (TableIterator keyValueTableIterator = this.getOpenKeyTable(bucketLayout).iterator();){
            long expiredCreationTimestamp = expireThreshold.negated().plusMillis(Time.now()).toMillis();
            long expiredLeaseTimestamp = leaseThreshold.negated().plusMillis(Time.now()).toMillis();
            int num = 0;
            while (num < count && keyValueTableIterator.hasNext()) {
                Table.KeyValue openKeyValue = (Table.KeyValue)keyValueTableIterator.next();
                String dbOpenKeyName = (String)openKeyValue.getKey();
                int lastPrefix = dbOpenKeyName.lastIndexOf("/");
                String dbKeyName = dbOpenKeyName.substring(0, lastPrefix);
                OmKeyInfo openKeyInfo = (OmKeyInfo)openKeyValue.getValue();
                if (this.isOpenMultipartKey(openKeyInfo, dbOpenKeyName) || openKeyInfo.getCreationTime() > expiredCreationTimestamp && openKeyInfo.getModificationTime() > expiredLeaseTimestamp) continue;
                String clientIdString = dbOpenKeyName.substring(lastPrefix + 1);
                boolean isHsync = Optional.of(openKeyInfo).map(WithMetadata::getMetadata).map(meta -> (String)meta.get("hsyncClientId")).filter(id -> id.equals(clientIdString)).isPresent();
                if (!isHsync && openKeyInfo.getCreationTime() <= expiredCreationTimestamp || openKeyInfo.getMetadata().containsKey("deletedHsyncKey") || openKeyInfo.getMetadata().containsKey("overwrittenHsyncKey")) {
                    expiredKeys.addOpenKey(openKeyInfo, dbOpenKeyName);
                    ++num;
                    continue;
                }
                if (!isHsync || openKeyInfo.getModificationTime() > expiredLeaseTimestamp || openKeyInfo.getMetadata().containsKey("leaseRecovery")) continue;
                OmKeyInfo info = (OmKeyInfo)kt.get((Object)dbKeyName);
                OzoneManagerProtocolProtos.KeyArgs.Builder keyArgs = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(info.getVolumeName()).setBucketName(info.getBucketName()).setKeyName(openKeyInfo.getKeyName()).setDataSize(info.getDataSize());
                Optional.ofNullable(info.getLatestVersionLocations()).map(OmKeyLocationInfoGroup::getLocationList).map(Collection::stream).orElseGet(Stream::empty).map(loc -> loc.getProtobuf(ClientVersion.CURRENT_VERSION)).forEach(arg_0 -> ((OzoneManagerProtocolProtos.KeyArgs.Builder)keyArgs).addKeyLocations(arg_0));
                OzoneManagerProtocolClientSideTranslatorPB.setReplicationConfig((ReplicationConfig)info.getReplicationConfig(), (OzoneManagerProtocolProtos.KeyArgs.Builder)keyArgs);
                expiredKeys.addHsyncKey(keyArgs, Long.parseLong(clientIdString));
                ++num;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return expiredKeys;
    }

    public List<OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket> getExpiredMultipartUploads(Duration expireThreshold, int maxParts) throws IOException {
        HashMap<String, OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket.Builder> expiredMPUs = new HashMap<String, OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket.Builder>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (TableIterator mpuInfoTableIterator = this.getMultipartInfoTable().iterator();){
            long expiredCreationTimestamp = expireThreshold.negated().plusMillis(Time.now()).toMillis();
            OzoneManagerProtocolProtos.ExpiredMultipartUploadInfo.Builder builder = OzoneManagerProtocolProtos.ExpiredMultipartUploadInfo.newBuilder();
            int numParts = 0;
            while (numParts < maxParts && mpuInfoTableIterator.hasNext()) {
                Table.KeyValue mpuInfoValue = (Table.KeyValue)mpuInfoTableIterator.next();
                String dbMultipartInfoKey = (String)mpuInfoValue.getKey();
                OmMultipartKeyInfo omMultipartKeyInfo = (OmMultipartKeyInfo)mpuInfoValue.getValue();
                if (omMultipartKeyInfo.getCreationTime() > expiredCreationTimestamp) continue;
                OmMultipartUpload expiredMultipartUpload = OmMultipartUpload.from((String)dbMultipartInfoKey);
                String volume = expiredMultipartUpload.getVolumeName();
                String bucket = expiredMultipartUpload.getBucketName();
                String mapKey = String.valueOf(volume) + "/" + bucket;
                expiredMPUs.computeIfAbsent(mapKey, k -> OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket.newBuilder().setVolumeName(volume).setBucketName(bucket));
                ((OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket.Builder)expiredMPUs.get(mapKey)).addMultipartUploads(builder.setName(dbMultipartInfoKey).build());
                numParts += omMultipartKeyInfo.getPartKeyInfoMap().size();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return expiredMPUs.values().stream().map(OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket.Builder::build).collect(Collectors.toList());
    }

    public <KEY, VALUE> long countRowsInTable(Table<KEY, VALUE> table) throws IOException {
        long count = 0L;
        if (table != null) {
            Throwable throwable = null;
            Object var5_5 = null;
            try (TableIterator keyValueTableIterator = table.iterator();){
                while (keyValueTableIterator.hasNext()) {
                    keyValueTableIterator.next();
                    ++count;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return count;
    }

    public <KEY, VALUE> long countEstimatedRowsInTable(Table<KEY, VALUE> table) throws IOException {
        long count = 0L;
        if (table != null) {
            count = table.getEstimatedKeyCount();
        }
        return count;
    }

    public List<OmMultipartUpload> getMultipartUploadKeys(String volumeName, String bucketName, String prefix, String keyMarker, String uploadIdMarker, int maxUploads, boolean noPagination) throws IOException {
        OmMultipartKeyInfo multipartKeyInfo22;
        Object cacheKey;
        TreeMap<Object, OmMultipartKeyInfo> responseKeys = new TreeMap<Object, OmMultipartKeyInfo>();
        HashSet<Object> aborted = new HashSet<Object>();
        String prefixKey = OmMultipartUpload.getDbKey((String)volumeName, (String)bucketName, (String)prefix);
        if (StringUtil.isNotBlank((String)keyMarker)) {
            prefix = keyMarker;
            if (StringUtil.isNotBlank((String)uploadIdMarker)) {
                prefix = String.valueOf(prefix) + "/" + uploadIdMarker;
            }
        }
        String seekKey = OmMultipartUpload.getDbKey((String)volumeName, (String)bucketName, (String)prefix);
        Iterator cacheIterator = this.getMultipartInfoTable().cacheIterator();
        while (cacheIterator.hasNext()) {
            Map.Entry cacheEntry = (Map.Entry)cacheIterator.next();
            cacheKey = (String)((CacheKey)cacheEntry.getKey()).getCacheKey();
            if (!((String)cacheKey).startsWith(prefixKey)) continue;
            multipartKeyInfo22 = (OmMultipartKeyInfo)((CacheValue)cacheEntry.getValue()).getCacheValue();
            if (multipartKeyInfo22 != null && ((String)cacheKey).compareTo(seekKey) >= 0) {
                responseKeys.put(cacheKey, multipartKeyInfo22);
                continue;
            }
            aborted.add(cacheKey);
        }
        int dbKeysCount = 0;
        cacheKey = null;
        multipartKeyInfo22 = null;
        try (TableIterator iterator = this.getMultipartInfoTable().iterator((Object)prefixKey);){
            iterator.seek((Object)seekKey);
            while (iterator.hasNext() && (noPagination || dbKeysCount < maxUploads + 1)) {
                Table.KeyValue entry = (Table.KeyValue)iterator.next();
                if (aborted.contains(entry.getKey())) continue;
                responseKeys.put((String)entry.getKey(), (OmMultipartKeyInfo)entry.getValue());
                ++dbKeysCount;
            }
        }
        catch (Throwable multipartKeyInfo22) {
            if (cacheKey == null) {
                cacheKey = multipartKeyInfo22;
            } else if (cacheKey != multipartKeyInfo22) {
                ((Throwable)cacheKey).addSuppressed(multipartKeyInfo22);
            }
            throw cacheKey;
        }
        ArrayList<OmMultipartUpload> result = new ArrayList<OmMultipartUpload>(responseKeys.size());
        for (Map.Entry entry : responseKeys.entrySet()) {
            OmMultipartUpload multipartUpload = OmMultipartUpload.from((String)((String)entry.getKey()));
            multipartUpload.setCreationTime(Instant.ofEpochMilli(((OmMultipartKeyInfo)entry.getValue()).getCreationTime()));
            multipartUpload.setReplicationConfig(((OmMultipartKeyInfo)entry.getValue()).getReplicationConfig());
            result.add(multipartUpload);
        }
        return noPagination || result.size() <= maxUploads ? result : result.subList(0, maxUploads + 1);
    }

    public void storeSecret(String kerberosId, S3SecretValue secret) throws IOException {
        this.s3SecretTable.put((Object)kerberosId, (Object)secret);
    }

    public S3SecretValue getSecret(String kerberosID) throws IOException {
        return (S3SecretValue)this.s3SecretTable.get((Object)kerberosID);
    }

    public void revokeSecret(String kerberosId) throws IOException {
        this.s3SecretTable.delete((Object)kerberosId);
    }

    public S3Batcher batcher() {
        return this.s3Batcher;
    }

    public Table<String, TransactionInfo> getTransactionInfoTable() {
        return this.transactionInfoTable;
    }

    public Table<String, String> getMetaTable() {
        return this.metaTable;
    }

    public Table<String, OmDBAccessIdInfo> getTenantAccessIdTable() {
        return this.tenantAccessIdTable;
    }

    public Table<String, OmDBUserPrincipalInfo> getPrincipalToAccessIdsTable() {
        return this.principalToAccessIdsTable;
    }

    public Table<String, OmDBTenantState> getTenantStateTable() {
        return this.tenantStateTable;
    }

    public Table<String, SnapshotInfo> getSnapshotInfoTable() {
        return this.snapshotInfoTable;
    }

    public Table<String, String> getSnapshotRenamedTable() {
        return this.snapshotRenamedTable;
    }

    public Table<String, CompactionLogEntry> getCompactionLogTable() {
        return this.compactionLogTable;
    }

    public SnapshotChainManager getSnapshotChainManager() {
        return this.snapshotChainManager;
    }

    protected void setStore(DBStore store) {
        this.store = store;
    }

    public Map<String, Table> listTables() {
        return this.tableMap;
    }

    public Table getTable(String tableName) {
        Table table = this.tableMap.get(tableName);
        if (table == null) {
            throw new IllegalArgumentException("Unknown table " + tableName);
        }
        return table;
    }

    public Set<String> listTableNames() {
        return this.tableMap.keySet();
    }

    public String getOzonePathKey(long volumeId, long bucketId, long parentObjectId, String pathComponentName) {
        StringBuilder builder = new StringBuilder();
        builder.append("/").append(volumeId).append("/").append(bucketId).append("/").append(parentObjectId).append("/").append(pathComponentName);
        return builder.toString();
    }

    public String getOzoneDeletePathKey(long objectId, String pathKey) {
        return String.valueOf(pathKey) + "/" + objectId;
    }

    public String getOzoneDeletePathDirKey(String ozoneDeletePath) {
        return ozoneDeletePath.substring(0, ozoneDeletePath.lastIndexOf("/"));
    }

    public String getOpenFileName(long volumeId, long bucketId, long parentID, String fileName, String clientId) {
        StringBuilder openKey = new StringBuilder();
        openKey.append("/").append(volumeId);
        openKey.append("/").append(bucketId);
        openKey.append("/").append(parentID);
        openKey.append("/").append(fileName);
        openKey.append("/").append(clientId);
        return openKey.toString();
    }

    public String getRenameKey(String volumeName, String bucketName, long objectID) {
        StringBuilder renameKey = new StringBuilder();
        renameKey.append("/").append(volumeName);
        renameKey.append("/").append(bucketName);
        renameKey.append("/").append(objectID);
        return renameKey.toString();
    }

    public String getMultipartKey(long volumeId, long bucketId, long parentID, String fileName, String uploadId) {
        StringBuilder openKey = new StringBuilder();
        openKey.append("/").append(volumeId);
        openKey.append("/").append(bucketId);
        openKey.append("/").append(parentID);
        openKey.append("/").append(fileName);
        openKey.append("/").append(uploadId);
        return openKey.toString();
    }

    public BucketLayout getBucketLayout() {
        return BucketLayout.DEFAULT;
    }

    public long getVolumeId(String volume) throws IOException {
        OmVolumeArgs omVolumeArgs = (OmVolumeArgs)this.getVolumeTable().get((Object)this.getVolumeKey(volume));
        if (omVolumeArgs == null) {
            throw new OMException("Volume not found " + volume, OMException.ResultCodes.VOLUME_NOT_FOUND);
        }
        return omVolumeArgs.getObjectID();
    }

    public long getBucketId(String volume, String bucket) throws IOException {
        OmBucketInfo omBucketInfo = (OmBucketInfo)this.getBucketTable().get((Object)this.getBucketKey(volume, bucket));
        if (omBucketInfo == null) {
            throw new OMException("Bucket not found " + bucket + ", volume name: " + volume, OMException.ResultCodes.BUCKET_NOT_FOUND);
        }
        return omBucketInfo.getObjectID();
    }

    public List<BlockGroup> getBlocksForKeyDelete(String deletedKey) throws IOException {
        RepeatedOmKeyInfo omKeyInfo = (RepeatedOmKeyInfo)this.getDeletedTable().get((Object)deletedKey);
        if (omKeyInfo == null) {
            return null;
        }
        ArrayList<BlockGroup> result = new ArrayList<BlockGroup>();
        for (OmKeyInfo info : omKeyInfo.cloneOmKeyInfoList()) {
            for (OmKeyLocationInfoGroup keyLocations : info.getKeyLocationVersions()) {
                List item = keyLocations.getLocationList().stream().map(b -> new BlockID(b.getContainerID(), b.getLocalID())).collect(Collectors.toList());
                BlockGroup keyBlocks = BlockGroup.newBuilder().setKeyName(deletedKey).addAllBlockIDs(item).build();
                result.add(keyBlocks);
            }
        }
        return result;
    }

    public boolean containsIncompleteMPUs(String volume, String bucket) throws IOException {
        String keyPrefix = OmMultipartUpload.getDbKey((String)volume, (String)bucket, (String)"");
        if (this.isKeyPresentInTableCache(keyPrefix, this.multipartInfoTable)) {
            return true;
        }
        return this.isKeyPresentInTable(keyPrefix, this.multipartInfoTable);
    }

    private final class S3SecretBatcher
    implements S3Batcher {
        private S3SecretBatcher() {
        }

        public void addWithBatch(AutoCloseable batchOperator, String id, S3SecretValue s3SecretValue) throws IOException {
            if (batchOperator instanceof BatchOperation) {
                OmMetadataManagerImpl.this.s3SecretTable.putWithBatch((BatchOperation)batchOperator, (Object)id, (Object)s3SecretValue);
            }
        }

        public void deleteWithBatch(AutoCloseable batchOperator, String id) throws IOException {
            if (batchOperator instanceof BatchOperation) {
                OmMetadataManagerImpl.this.s3SecretTable.deleteWithBatch((BatchOperation)batchOperator, (Object)id);
            }
        }
    }
}

