/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.key;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.ExcludeList;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.AuditLogger;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.QuotaUtil;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.key.OMAllocateBlockResponse;
import org.apache.hadoop.ozone.om.upgrade.BelongsToLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.util.Time;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OMAllocateBlockRequest
extends OMKeyRequest {
    private static final Logger LOG;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        OMAllocateBlockRequest.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OMAllocateBlockRequest.class);
    }

    public OMAllocateBlockRequest(OzoneManagerProtocolProtos.OMRequest omRequest, BucketLayout bucketLayout) {
        super(omRequest, bucketLayout);
    }

    @Override
    public OzoneManagerProtocolProtos.OMRequest preExecute(OzoneManager ozoneManager) throws IOException {
        OzoneManager ozoneManager2 = ozoneManager;
        if (this != null && this.getClass().isAnnotationPresent(BelongsToLayoutVersion.class)) {
            OMLayoutFeatureAspect.aspectOf().beforeRequestApplyTxn(Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)ozoneManager2));
        }
        OzoneManagerProtocolProtos.AllocateBlockRequest allocateBlockRequest = super.preExecute(ozoneManager).getAllocateBlockRequest();
        Preconditions.checkNotNull((Object)allocateBlockRequest);
        OzoneManagerProtocolProtos.KeyArgs keyArgs = allocateBlockRequest.getKeyArgs();
        String keyPath = keyArgs.getKeyName();
        keyPath = OMAllocateBlockRequest.validateAndNormalizeKey(ozoneManager.getEnableFileSystemPaths(), keyPath, this.getBucketLayout());
        ExcludeList excludeList = new ExcludeList();
        if (allocateBlockRequest.hasExcludeList()) {
            excludeList = ExcludeList.getFromProtoBuf((HddsProtos.ExcludeListProto)allocateBlockRequest.getExcludeList());
        }
        OzoneManagerProtocolProtos.UserInfo userInfo = this.getUserIfNotExists(ozoneManager);
        ReplicationConfig repConfig = ReplicationConfig.fromProto((HddsProtos.ReplicationType)keyArgs.getType(), (HddsProtos.ReplicationFactor)keyArgs.getFactor(), (HddsProtos.ECReplicationConfig)keyArgs.getEcReplicationConfig());
        List<OmKeyLocationInfo> omKeyLocationInfoList = this.allocateBlock(ozoneManager.getScmClient(), ozoneManager.getBlockTokenSecretManager(), repConfig, excludeList, ozoneManager.getScmBlockSize(), ozoneManager.getScmBlockSize(), ozoneManager.getPreallocateBlocksMax(), ozoneManager.isGrpcBlockTokenEnabled(), ozoneManager.getOMServiceId(), ozoneManager.getMetrics(), keyArgs.getSortDatanodes(), userInfo);
        OzoneManagerProtocolProtos.KeyArgs.Builder newKeyArgs = keyArgs.toBuilder().setModificationTime(Time.now()).setKeyName(keyPath);
        OzoneManagerProtocolProtos.KeyArgs resolvedKeyArgs = this.resolveBucketAndCheckOpenKeyAcls(newKeyArgs.build(), ozoneManager, IAccessAuthorizer.ACLType.WRITE, allocateBlockRequest.getClientID());
        OzoneManagerProtocolProtos.AllocateBlockRequest.Builder newAllocatedBlockRequest = OzoneManagerProtocolProtos.AllocateBlockRequest.newBuilder().setClientID(allocateBlockRequest.getClientID()).setKeyArgs(resolvedKeyArgs);
        if (allocateBlockRequest.hasExcludeList()) {
            newAllocatedBlockRequest.setExcludeList(allocateBlockRequest.getExcludeList());
        }
        newAllocatedBlockRequest.setKeyLocation(omKeyLocationInfoList.get(0).getProtobuf(this.getOmRequest().getVersion()));
        return this.getOmRequest().toBuilder().setUserInfo(userInfo).setAllocateBlockRequest(newAllocatedBlockRequest).build();
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        Exception exception;
        OMClientResponse omClientResponse;
        Map<String, String> auditMap;
        AuditLogger auditLogger;
        block14: {
            long trxnLogIndex = context.getIndex();
            OzoneManagerProtocolProtos.AllocateBlockRequest allocateBlockRequest = this.getOmRequest().getAllocateBlockRequest();
            OzoneManagerProtocolProtos.KeyArgs keyArgs = allocateBlockRequest.getKeyArgs();
            OzoneManagerProtocolProtos.KeyLocation blockLocation = allocateBlockRequest.getKeyLocation();
            Preconditions.checkNotNull((Object)blockLocation);
            String volumeName = keyArgs.getVolumeName();
            String bucketName = keyArgs.getBucketName();
            String keyName = keyArgs.getKeyName();
            long clientID = allocateBlockRequest.getClientID();
            OMMetrics omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumBlockAllocateCalls();
            auditLogger = ozoneManager.getAuditLogger();
            auditMap = this.buildKeyArgsAuditMap(keyArgs);
            auditMap.put("clientID", String.valueOf(clientID));
            OMMetadataManager omMetadataManager = ozoneManager.getMetadataManager();
            String openKeyName = null;
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            omClientResponse = null;
            OmKeyInfo openKeyInfo = null;
            exception = null;
            OmBucketInfo omBucketInfo = null;
            boolean acquiredLock = false;
            try {
                try {
                    this.validateBucketAndVolume(omMetadataManager, volumeName, bucketName);
                    openKeyName = omMetadataManager.getOpenKey(volumeName, bucketName, keyName, clientID);
                    openKeyInfo = (OmKeyInfo)omMetadataManager.getOpenKeyTable(this.getBucketLayout()).get((Object)openKeyName);
                    if (openKeyInfo == null) {
                        throw new OMException("Open Key not found " + openKeyName, OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    if (openKeyInfo.getMetadata().containsKey("leaseRecovery")) {
                        throw new OMException("Open Key " + openKeyName + " is under lease recovery", OMException.ResultCodes.KEY_UNDER_LEASE_RECOVERY);
                    }
                    if (openKeyInfo.getMetadata().containsKey("deletedHsyncKey") || openKeyInfo.getMetadata().containsKey("overwrittenHsyncKey")) {
                        throw new OMException("Open Key " + openKeyName + " is already deleted/overwritten", OMException.ResultCodes.KEY_NOT_FOUND);
                    }
                    List<OmKeyLocationInfo> newLocationList = Collections.singletonList(OmKeyLocationInfo.getFromProtobuf((OzoneManagerProtocolProtos.KeyLocation)blockLocation));
                    this.mergeOmLockDetails(omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    acquiredLock = this.getOmLockDetails().isLockAcquired();
                    omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                    long preAllocatedKeySize = (long)newLocationList.size() * ozoneManager.getScmBlockSize();
                    long hadAllocatedKeySize = (long)openKeyInfo.getLatestVersionLocations().getLocationList().size() * ozoneManager.getScmBlockSize();
                    ReplicationConfig repConfig = openKeyInfo.getReplicationConfig();
                    long totalAllocatedSpace = QuotaUtil.getReplicatedSize((long)preAllocatedKeySize, (ReplicationConfig)repConfig) + QuotaUtil.getReplicatedSize((long)hadAllocatedKeySize, (ReplicationConfig)repConfig);
                    this.checkBucketQuotaInBytes(omMetadataManager, omBucketInfo, totalAllocatedSpace);
                    openKeyInfo.appendNewBlocks(newLocationList, false);
                    openKeyInfo.setModificationTime(keyArgs.getModificationTime());
                    openKeyInfo.setUpdateID(trxnLogIndex);
                    omMetadataManager.getOpenKeyTable(this.getBucketLayout()).addCacheEntry(new CacheKey((Object)openKeyName), CacheValue.get((long)trxnLogIndex, (Object)openKeyInfo));
                    omResponse.setAllocateBlockResponse(OzoneManagerProtocolProtos.AllocateBlockResponse.newBuilder().setKeyLocation(blockLocation).build());
                    omClientResponse = new OMAllocateBlockResponse(omResponse.build(), openKeyInfo, clientID, this.getBucketLayout());
                    LOG.debug("Allocated block for Volume:{}, Bucket:{}, OpenKey:{}", new Object[]{volumeName, bucketName, openKeyName});
                }
                catch (IOException | InvalidPathException ex) {
                    omMetrics.incNumBlockAllocateCallFails();
                    exception = ex;
                    omClientResponse = new OMAllocateBlockResponse(this.createErrorOMResponse(omResponse, exception), this.getBucketLayout());
                    LOG.error("Allocate Block failed. Volume:{}, Bucket:{}, OpenKey:{}. Exception:{}", new Object[]{volumeName, bucketName, openKeyName, exception});
                    if (acquiredLock) {
                        this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                    }
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (acquiredLock) {
                    this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
                }
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.markForAudit(auditLogger, this.buildAuditMessage(OMAction.ALLOCATE_BLOCK, auditMap, exception, this.getOmRequest().getUserInfo()));
        return omClientResponse;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.CLUSTER_NEEDS_FINALIZATION}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.AllocateBlock)
    public static OzoneManagerProtocolProtos.OMRequest disallowAllocateBlockWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws OMException {
        if (!ctx.versionManager().isAllowed((LayoutFeature)OMLayoutFeature.ERASURE_CODED_STORAGE_SUPPORT) && req.getAllocateBlockRequest().getKeyArgs().hasEcReplicationConfig()) {
            throw new OMException("Cluster does not have the Erasure Coded Storage support feature finalized yet, but the request contains an Erasure Coded replication type. Rejecting the request, please finalize the cluster upgrade and then try again.", OMException.ResultCodes.NOT_SUPPORTED_OPERATION_PRIOR_FINALIZATION);
        }
        return req;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.PRE_PROCESS, requestType=OzoneManagerProtocolProtos.Type.AllocateBlock)
    public static OzoneManagerProtocolProtos.OMRequest blockAllocateBlockWithBucketLayoutFromOldClient(OzoneManagerProtocolProtos.OMRequest req, ValidationContext ctx) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs;
        if (req.getAllocateBlockRequest().hasKeyArgs() && (keyArgs = req.getAllocateBlockRequest().getKeyArgs()).hasVolumeName() && keyArgs.hasBucketName()) {
            BucketLayout bucketLayout = ctx.getBucketLayout(keyArgs.getVolumeName(), keyArgs.getBucketName());
            bucketLayout.validateSupportedOperation();
        }
        return req;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OMAllocateBlockRequest.java", OMAllocateBlockRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "preExecute", "org.apache.hadoop.ozone.om.request.key.OMAllocateBlockRequest", "org.apache.hadoop.ozone.om.OzoneManager", "ozoneManager", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$OMRequest"), 82);
    }
}

