/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.s3.multipart;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.audit.OMAction;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.OMMetrics;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartAbortInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUpload;
import org.apache.hadoop.ozone.om.lock.OMLockDetails;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.key.OMKeyRequest;
import org.apache.hadoop.ozone.om.request.util.OMMultipartUploadUtils;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.response.s3.multipart.S3ExpiredMultipartUploadsAbortResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3ExpiredMultipartUploadsAbortRequest
extends OMKeyRequest {
    private static final Logger LOG = LoggerFactory.getLogger(S3ExpiredMultipartUploadsAbortRequest.class);

    public S3ExpiredMultipartUploadsAbortRequest(OzoneManagerProtocolProtos.OMRequest omRequest) {
        super(omRequest);
    }

    @Override
    public OMClientResponse validateAndUpdateCache(OzoneManager ozoneManager, ExecutionContext context) {
        HashMap<OmBucketInfo, List<OmMultipartAbortInfo>> abortedMultipartUploads;
        OMClientRequest.Result result;
        OMClientResponse omClientResponse;
        long numSubmittedMPUs;
        OzoneManagerProtocolProtos.MultipartUploadsExpiredAbortRequest multipartUploadsExpiredAbortRequest;
        OMMetrics omMetrics;
        block10: {
            long trxnLogIndex = context.getIndex();
            omMetrics = ozoneManager.getMetrics();
            omMetrics.incNumExpiredMPUAbortRequests();
            multipartUploadsExpiredAbortRequest = this.getOmRequest().getMultipartUploadsExpiredAbortRequest();
            List submittedExpiredMPUsPerBucket = multipartUploadsExpiredAbortRequest.getExpiredMultipartUploadsPerBucketList();
            numSubmittedMPUs = 0L;
            for (OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket mpuByBucket : submittedExpiredMPUsPerBucket) {
                numSubmittedMPUs += (long)mpuByBucket.getMultipartUploadsCount();
            }
            LOG.debug("{} expired multi-uploads submitted for deletion.", (Object)numSubmittedMPUs);
            omMetrics.incNumExpiredMPUSubmittedForAbort(numSubmittedMPUs);
            OzoneManagerProtocolProtos.OMResponse.Builder omResponse = OmResponseUtil.getOMResponseBuilder(this.getOmRequest());
            IOException exception = null;
            omClientResponse = null;
            result = null;
            abortedMultipartUploads = new HashMap<OmBucketInfo, List<OmMultipartAbortInfo>>();
            try {
                try {
                    for (OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket mpuByBucket : submittedExpiredMPUsPerBucket) {
                        this.updateTableCache(ozoneManager, trxnLogIndex, mpuByBucket, abortedMultipartUploads);
                    }
                    omClientResponse = new S3ExpiredMultipartUploadsAbortResponse(omResponse.build(), abortedMultipartUploads);
                    result = OMClientRequest.Result.SUCCESS;
                }
                catch (IOException ex) {
                    result = OMClientRequest.Result.FAILURE;
                    exception = ex;
                    omClientResponse = new S3ExpiredMultipartUploadsAbortResponse(this.createErrorOMResponse(omResponse, exception));
                    if (omClientResponse != null) {
                        omClientResponse.setOmLockDetails(this.getOmLockDetails());
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (omClientResponse != null) {
                    omClientResponse.setOmLockDetails(this.getOmLockDetails());
                }
                throw throwable;
            }
            if (omClientResponse != null) {
                omClientResponse.setOmLockDetails(this.getOmLockDetails());
            }
        }
        this.auditAbortedMPUs(ozoneManager, abortedMultipartUploads);
        this.processResults(omMetrics, numSubmittedMPUs, abortedMultipartUploads.size(), multipartUploadsExpiredAbortRequest, result);
        return omClientResponse;
    }

    private void auditAbortedMPUs(OzoneManager ozoneManager, Map<OmBucketInfo, List<OmMultipartAbortInfo>> abortedMultipartUploads) {
        for (Map.Entry<OmBucketInfo, List<OmMultipartAbortInfo>> entry : abortedMultipartUploads.entrySet()) {
            OzoneManagerProtocolProtos.KeyArgs.Builder keyArgsAuditBuilder = OzoneManagerProtocolProtos.KeyArgs.newBuilder().setVolumeName(entry.getKey().getVolumeName()).setBucketName(entry.getKey().getBucketName());
            for (OmMultipartAbortInfo abortInfo : entry.getValue()) {
                OzoneManagerProtocolProtos.KeyArgs keyArgsForAudit = keyArgsAuditBuilder.setKeyName(abortInfo.getMultipartKey()).setMultipartUploadID(abortInfo.getOmMultipartKeyInfo().getUploadID()).build();
                Map<String, String> auditMap = this.buildKeyArgsAuditMap(keyArgsForAudit);
                auditMap.put("uploadID", abortInfo.getOmMultipartKeyInfo().getUploadID());
                this.markForAudit(ozoneManager.getAuditLogger(), this.buildAuditMessage(OMAction.ABORT_EXPIRED_MULTIPART_UPLOAD, auditMap, null, this.getOmRequest().getUserInfo()));
            }
        }
    }

    private void processResults(OMMetrics omMetrics, long numSubmittedExpiredMPUs, long numAbortedMPUs, OzoneManagerProtocolProtos.MultipartUploadsExpiredAbortRequest request, OMClientRequest.Result result) {
        switch (result) {
            case SUCCESS: {
                LOG.debug("Aborted {} expired MPUs out of {} submitted MPus.", (Object)numAbortedMPUs, (Object)numSubmittedExpiredMPUs);
                break;
            }
            case FAILURE: {
                omMetrics.incNumExpiredMpuAbortRequestFails();
                LOG.error("Failure occurred while trying to abort {} submitted expired MPUs.", (Object)numAbortedMPUs);
                break;
            }
            default: {
                LOG.error("Unrecognized result for MultipartUploadsExpiredAbortRequest: {}", (Object)request);
            }
        }
    }

    private void updateTableCache(OzoneManager ozoneManager, long trxnLogIndex, OzoneManagerProtocolProtos.ExpiredMultipartUploadsBucket mpusPerBucket, Map<OmBucketInfo, List<OmMultipartAbortInfo>> abortedMultipartUploads) throws IOException {
        BucketLayout bucketLayout;
        OmBucketInfo omBucketInfo;
        OMMetadataManager omMetadataManager;
        String bucketName;
        String volumeName;
        boolean acquiredLock;
        block14: {
            block15: {
                acquiredLock = false;
                volumeName = mpusPerBucket.getVolumeName();
                bucketName = mpusPerBucket.getBucketName();
                omMetadataManager = ozoneManager.getMetadataManager();
                omBucketInfo = null;
                bucketLayout = null;
                OMLockDetails omLockDetails = null;
                omLockDetails = omMetadataManager.getLock().acquireWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName});
                acquiredLock = omLockDetails.isLockAcquired();
                omBucketInfo = this.getBucketInfo(omMetadataManager, volumeName, bucketName);
                if (omBucketInfo != null) break block14;
                LOG.warn("Volume: {}, Bucket: {} does not exist, skipping deletion.", (Object)volumeName, (Object)bucketName);
                if (!acquiredLock) break block15;
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            return;
        }
        try {
            bucketLayout = omBucketInfo.getBucketLayout();
            for (OzoneManagerProtocolProtos.ExpiredMultipartUploadInfo expiredMPU : mpusPerBucket.getMultipartUploadsList()) {
                String expiredMPUKeyName = expiredMPU.getName();
                OmMultipartKeyInfo omMultipartKeyInfo = (OmMultipartKeyInfo)omMetadataManager.getMultipartInfoTable().get((Object)expiredMPUKeyName);
                if (omMultipartKeyInfo != null) {
                    String multipartOpenKey;
                    OmMultipartUpload multipartUpload;
                    if (trxnLogIndex < omMultipartKeyInfo.getUpdateID()) {
                        LOG.warn("Transaction log index {} is smaller than the current updateID {} of MPU key {}, skipping deletion.", new Object[]{trxnLogIndex, omMultipartKeyInfo.getUpdateID(), expiredMPUKeyName});
                        continue;
                    }
                    omMultipartKeyInfo.setUpdateID(trxnLogIndex);
                    try {
                        multipartUpload = OmMultipartUpload.from((String)expiredMPUKeyName);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        LOG.warn("Aborting expired MPU failed: MPU key: " + expiredMPUKeyName + " has invalid structure, " + "skipping this MPU.");
                        continue;
                    }
                    try {
                        multipartOpenKey = OMMultipartUploadUtils.getMultipartOpenKey(multipartUpload.getVolumeName(), multipartUpload.getBucketName(), multipartUpload.getKeyName(), multipartUpload.getUploadId(), omMetadataManager, bucketLayout);
                    }
                    catch (OMException oMException) {
                        LOG.warn("Aborting expired MPU Failed: volume: " + multipartUpload.getVolumeName() + ", bucket: " + multipartUpload.getBucketName() + ", key: " + multipartUpload.getKeyName() + ". Cannot parse the open key" + "for this MPU, skipping this MPU.");
                        continue;
                    }
                    long quotaReleased = 0L;
                    int keyFactor = omMultipartKeyInfo.getReplicationConfig().getRequiredNodes();
                    for (OzoneManagerProtocolProtos.PartKeyInfo iterPartKeyInfo : omMultipartKeyInfo.getPartKeyInfoMap()) {
                        quotaReleased += iterPartKeyInfo.getPartKeyInfo().getDataSize() * (long)keyFactor;
                    }
                    omBucketInfo.incrUsedBytes(-quotaReleased);
                    OmMultipartAbortInfo omMultipartAbortInfo = new OmMultipartAbortInfo.Builder().setMultipartKey(expiredMPUKeyName).setMultipartOpenKey(multipartOpenKey).setMultipartKeyInfo(omMultipartKeyInfo).setBucketLayout(omBucketInfo.getBucketLayout()).build();
                    abortedMultipartUploads.computeIfAbsent(omBucketInfo, k -> new ArrayList()).add(omMultipartAbortInfo);
                    if (omMetadataManager.getOpenKeyTable(bucketLayout).isExist((Object)multipartOpenKey)) {
                        omMetadataManager.getOpenKeyTable(bucketLayout).addCacheEntry(new CacheKey((Object)multipartOpenKey), CacheValue.get((long)trxnLogIndex));
                    }
                    omMetadataManager.getMultipartInfoTable().addCacheEntry(new CacheKey((Object)expiredMPUKeyName), CacheValue.get((long)trxnLogIndex));
                    long numParts = omMultipartKeyInfo.getPartKeyInfoMap().size();
                    ozoneManager.getMetrics().incNumExpiredMPUAborted();
                    ozoneManager.getMetrics().incNumExpiredMPUPartsAborted(numParts);
                    LOG.debug("Expired MPU {} aborted containing {} parts.", (Object)expiredMPUKeyName, (Object)numParts);
                    continue;
                }
                LOG.debug("MPU key {} was not aborted, as it was not found in the multipart info table", (Object)expiredMPUKeyName);
            }
        }
        catch (Throwable throwable) {
            if (acquiredLock) {
                this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
            }
            throw throwable;
        }
        if (acquiredLock) {
            this.mergeOmLockDetails(omMetadataManager.getLock().releaseWriteLock(OzoneManagerLock.Resource.BUCKET_LOCK, new String[]{volumeName, bucketName}));
        }
    }
}

