/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.request.util;

import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OmKeyHSyncUtil {
    public static final Logger LOG = LoggerFactory.getLogger(OmKeyHSyncUtil.class);

    private OmKeyHSyncUtil() {
    }

    public static boolean isHSyncedPreviously(OmKeyInfo omKeyInfo, String clientIdString, String dbOpenKey) {
        String previousHsyncClientId = (String)omKeyInfo.getMetadata().get("hsyncClientId");
        if (previousHsyncClientId != null) {
            if (clientIdString.equals(previousHsyncClientId)) {
                return true;
            }
            LOG.warn("Client ID '{}' currently hsync'ing key does not match previous hsync client ID '{}'. dbOpenKey='{}'", new Object[]{clientIdString, previousHsyncClientId, dbOpenKey});
        }
        return false;
    }
}

