/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.key;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.key.AbstractOMKeyDeleteResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

@CleanupTableInfo(cleanupTables={"keyTable", "openKeyTable", "deletedTable", "bucketTable"})
public class OMKeysDeleteResponse
extends AbstractOMKeyDeleteResponse {
    private List<OmKeyInfo> omKeyInfoList;
    private OmBucketInfo omBucketInfo;
    private Map<String, OmKeyInfo> openKeyInfoMap = new HashMap<String, OmKeyInfo>();

    public OMKeysDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull List<OmKeyInfo> keyDeleteList, @Nonnull OmBucketInfo omBucketInfo, @Nonnull Map<String, OmKeyInfo> openKeyInfoMap) {
        super(omResponse);
        this.omKeyInfoList = keyDeleteList;
        this.omBucketInfo = omBucketInfo;
        this.openKeyInfoMap = openKeyInfoMap;
    }

    public OMKeysDeleteResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull BucketLayout bucketLayout) {
        super(omResponse, bucketLayout);
        this.checkStatusNotOK();
    }

    @Override
    public void checkAndUpdateDB(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        if (this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.OK || this.getOMResponse().getStatus() == OzoneManagerProtocolProtos.Status.PARTIAL_DELETE) {
            this.addToDBBatch(omMetadataManager, batchOperation);
        }
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String volumeName = "";
        String bucketName = "";
        String keyName = "";
        Table keyTable = omMetadataManager.getKeyTable(this.getBucketLayout());
        for (OmKeyInfo omKeyInfo : this.omKeyInfoList) {
            volumeName = omKeyInfo.getVolumeName();
            bucketName = omKeyInfo.getBucketName();
            keyName = omKeyInfo.getKeyName();
            String deleteKey = omMetadataManager.getOzoneKey(volumeName, bucketName, keyName);
            this.addDeletionToBatch(omMetadataManager, batchOperation, keyTable, deleteKey, omKeyInfo);
        }
        omMetadataManager.getBucketTable().putWithBatch(batchOperation, (Object)omMetadataManager.getBucketKey(this.omBucketInfo.getVolumeName(), this.omBucketInfo.getBucketName()), (Object)this.omBucketInfo);
        if (!this.openKeyInfoMap.isEmpty()) {
            for (Map.Entry entry : this.openKeyInfoMap.entrySet()) {
                omMetadataManager.getOpenKeyTable(this.getBucketLayout()).putWithBatch(batchOperation, (Object)((String)entry.getKey()), (Object)((OmKeyInfo)entry.getValue()));
            }
        }
    }

    public List<OmKeyInfo> getOmKeyInfoList() {
        return this.omKeyInfoList;
    }

    public OmBucketInfo getOmBucketInfo() {
        return this.omBucketInfo;
    }

    protected Map<String, OmKeyInfo> getOpenKeyInfoMap() {
        return this.openKeyInfoMap;
    }
}

