/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.response.s3.tenant;

import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.ozone.om.OMMetadataManager;
import org.apache.hadoop.ozone.om.helpers.OmDBTenantState;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.response.CleanupTableInfo;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;

@CleanupTableInfo(cleanupTables={"tenantStateTable", "volumeTable"})
public class OMTenantCreateResponse
extends OMClientResponse {
    private OzoneManagerStorageProtos.PersistedUserVolumeInfo userVolumeInfo;
    private OmVolumeArgs omVolumeArgs;
    private OmDBTenantState omTenantState;

    public OMTenantCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse, @Nonnull OmVolumeArgs omVolumeArgs, OzoneManagerStorageProtos.PersistedUserVolumeInfo userVolumeInfo, @Nonnull OmDBTenantState omTenantState) {
        super(omResponse);
        this.omVolumeArgs = omVolumeArgs;
        this.userVolumeInfo = userVolumeInfo;
        this.omTenantState = omTenantState;
    }

    public OMTenantCreateResponse(@Nonnull OzoneManagerProtocolProtos.OMResponse omResponse) {
        super(omResponse);
        this.checkStatusNotOK();
    }

    @Override
    public void addToDBBatch(OMMetadataManager omMetadataManager, BatchOperation batchOperation) throws IOException {
        String tenantId = this.omTenantState.getTenantId();
        omMetadataManager.getTenantStateTable().putWithBatch(batchOperation, (Object)tenantId, (Object)this.omTenantState);
        String dbVolumeKey = omMetadataManager.getVolumeKey(this.omVolumeArgs.getVolume());
        omMetadataManager.getVolumeTable().putWithBatch(batchOperation, (Object)dbVolumeKey, (Object)this.omVolumeArgs);
        if (this.userVolumeInfo != null) {
            String dbUserKey = omMetadataManager.getUserKey(this.omVolumeArgs.getOwnerName());
            omMetadataManager.getUserTable().putWithBatch(batchOperation, (Object)dbUserKey, (Object)this.userVolumeInfo);
        }
    }

    @VisibleForTesting
    public OmDBTenantState getOmDBTenantState() {
        return this.omTenantState;
    }
}

