/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.DeletingServiceMetrics;
import org.apache.hadoop.ozone.om.KeyManager;
import org.apache.hadoop.ozone.om.OmMetadataManagerImpl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.PendingKeysDeletion;
import org.apache.hadoop.ozone.om.SnapshotChainManager;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.service.AbstractKeyDeletingService;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.ratis.protocol.ClientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyDeletingService
extends AbstractKeyDeletingService {
    private static final Logger LOG = LoggerFactory.getLogger(KeyDeletingService.class);
    private static final int KEY_DELETING_CORE_POOL_SIZE = 1;
    private final KeyManager manager;
    private int keyLimitPerTask;
    private final AtomicLong deletedKeyCount;
    private final AtomicBoolean suspended;
    private final Map<String, Long> exclusiveSizeMap;
    private final Map<String, Long> exclusiveReplicatedSizeMap;
    private final Set<String> completedExclusiveSizeSet;
    private final Map<String, String> snapshotSeekMap;
    private AtomicBoolean isRunningOnAOS;
    private final boolean deepCleanSnapshots;
    private final SnapshotChainManager snapshotChainManager;
    private DeletingServiceMetrics metrics;

    public KeyDeletingService(OzoneManager ozoneManager, ScmBlockLocationProtocol scmClient, KeyManager manager, long serviceInterval, long serviceTimeout, ConfigurationSource conf, boolean deepCleanSnapshots) {
        super(KeyDeletingService.class.getSimpleName(), serviceInterval, TimeUnit.MILLISECONDS, 1, serviceTimeout, ozoneManager, scmClient);
        this.manager = manager;
        this.keyLimitPerTask = conf.getInt("ozone.key.deleting.limit.per.task", 20000);
        Preconditions.checkArgument((this.keyLimitPerTask >= 0 ? 1 : 0) != 0, (Object)"ozone.key.deleting.limit.per.task cannot be negative.");
        this.deletedKeyCount = new AtomicLong(0L);
        this.suspended = new AtomicBoolean(false);
        this.exclusiveSizeMap = new HashMap<String, Long>();
        this.exclusiveReplicatedSizeMap = new HashMap<String, Long>();
        this.completedExclusiveSizeSet = new HashSet<String>();
        this.snapshotSeekMap = new HashMap<String, String>();
        this.isRunningOnAOS = new AtomicBoolean(false);
        this.deepCleanSnapshots = deepCleanSnapshots;
        this.snapshotChainManager = ((OmMetadataManagerImpl)manager.getMetadataManager()).getSnapshotChainManager();
        this.metrics = ozoneManager.getDeletionMetrics();
    }

    @VisibleForTesting
    public AtomicLong getDeletedKeyCount() {
        return this.deletedKeyCount;
    }

    public boolean isRunningOnAOS() {
        return this.isRunningOnAOS.get();
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue = new BackgroundTaskQueue();
        queue.add((BackgroundTask)new KeyDeletingTask(this));
        return queue;
    }

    private boolean shouldRun() {
        if (this.getOzoneManager() == null) {
            return true;
        }
        return !this.suspended.get() && this.getOzoneManager().isLeaderReady();
    }

    @VisibleForTesting
    public void suspend() {
        this.suspended.set(true);
    }

    @VisibleForTesting
    public void resume() {
        this.suspended.set(false);
    }

    public int getKeyLimitPerTask() {
        return this.keyLimitPerTask;
    }

    public void setKeyLimitPerTask(int keyLimitPerTask) {
        this.keyLimitPerTask = keyLimitPerTask;
    }

    static /* synthetic */ Map access$9(KeyDeletingService keyDeletingService) {
        return keyDeletingService.snapshotSeekMap;
    }

    private final class KeyDeletingTask
    implements BackgroundTask {
        private final KeyDeletingService deletingService;

        private KeyDeletingTask(KeyDeletingService service) {
            this.deletingService = service;
        }

        public int getPriority() {
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BackgroundTaskResult call() {
            if (KeyDeletingService.this.shouldRun()) {
                long run = KeyDeletingService.this.getRunCount().incrementAndGet();
                LOG.debug("Running KeyDeletingService {}", (Object)run);
                KeyDeletingService.this.isRunningOnAOS.set(true);
                int delCount = 0;
                try {
                    UUID expectedPreviousSnapshotId = KeyDeletingService.this.snapshotChainManager.getLatestGlobalSnapshotId();
                    PendingKeysDeletion pendingKeysDeletion = KeyDeletingService.this.manager.getPendingDeletionKeys(KeyDeletingService.this.getKeyLimitPerTask());
                    List<BlockGroup> keyBlocksList = pendingKeysDeletion.getKeyBlocksList();
                    if (keyBlocksList != null && !keyBlocksList.isEmpty()) {
                        delCount = KeyDeletingService.this.processKeyDeletes(keyBlocksList, KeyDeletingService.this.getOzoneManager().getKeyManager(), pendingKeysDeletion.getKeysToModify(), null, expectedPreviousSnapshotId);
                        KeyDeletingService.this.deletedKeyCount.addAndGet(delCount);
                        KeyDeletingService.this.metrics.incrNumKeysProcessed(keyBlocksList.size());
                        KeyDeletingService.this.metrics.incrNumKeysSentForPurge(delCount);
                    }
                }
                catch (IOException e) {
                    LOG.error("Error while running delete keys background task. Will retry at next run.", (Throwable)e);
                }
                try {
                    if (KeyDeletingService.this.deepCleanSnapshots && delCount < KeyDeletingService.this.keyLimitPerTask) {
                        this.processSnapshotDeepClean(delCount);
                    }
                }
                catch (Exception e) {
                    LOG.error("Error while running deep clean on snapshots. Will retry at next run.", (Throwable)e);
                }
            }
            KeyDeletingService.this.isRunningOnAOS.set(false);
            KeyDeletingService keyDeletingService = this.deletingService;
            synchronized (keyDeletingService) {
                ((Object)((Object)this.deletingService)).notify();
            }
            return BackgroundTaskResult.EmptyTaskResult.newResult();
        }

        /*
         * Exception decompiling
         */
        private void processSnapshotDeepClean(int delCount) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void updateSnapshotExclusiveSize() {
            if (KeyDeletingService.this.completedExclusiveSizeSet.isEmpty()) {
                return;
            }
            Iterator completedSnapshotIterator = KeyDeletingService.this.completedExclusiveSizeSet.iterator();
            while (completedSnapshotIterator.hasNext()) {
                ClientId clientId = ClientId.randomId();
                String dbKey = (String)completedSnapshotIterator.next();
                OzoneManagerProtocolProtos.SnapshotSize snapshotSize = OzoneManagerProtocolProtos.SnapshotSize.newBuilder().setExclusiveSize(KeyDeletingService.this.exclusiveSizeMap.getOrDefault(dbKey, 0L).longValue()).setExclusiveReplicatedSize(KeyDeletingService.this.exclusiveReplicatedSizeMap.getOrDefault(dbKey, 0L).longValue()).build();
                OzoneManagerProtocolProtos.SetSnapshotPropertyRequest setSnapshotPropertyRequest = OzoneManagerProtocolProtos.SetSnapshotPropertyRequest.newBuilder().setSnapshotKey(dbKey).setSnapshotSize(snapshotSize).build();
                OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SetSnapshotProperty).setSetSnapshotPropertyRequest(setSnapshotPropertyRequest).setClientId(clientId.toString()).build();
                this.submitRequest(omRequest, clientId);
                KeyDeletingService.this.exclusiveSizeMap.remove(dbKey);
                KeyDeletingService.this.exclusiveReplicatedSizeMap.remove(dbKey);
                completedSnapshotIterator.remove();
            }
        }

        private void updateDeepCleanedSnapshots(List<String> deepCleanedSnapshots) {
            for (String deepCleanedSnapshot : deepCleanedSnapshots) {
                ClientId clientId = ClientId.randomId();
                OzoneManagerProtocolProtos.SetSnapshotPropertyRequest setSnapshotPropertyRequest = OzoneManagerProtocolProtos.SetSnapshotPropertyRequest.newBuilder().setSnapshotKey(deepCleanedSnapshot).setDeepCleanedDeletedKey(true).build();
                OzoneManagerProtocolProtos.OMRequest omRequest = OzoneManagerProtocolProtos.OMRequest.newBuilder().setCmdType(OzoneManagerProtocolProtos.Type.SetSnapshotProperty).setSetSnapshotPropertyRequest(setSnapshotPropertyRequest).setClientId(clientId.toString()).build();
                this.submitRequest(omRequest, clientId);
            }
        }

        public void submitRequest(OzoneManagerProtocolProtos.OMRequest omRequest, ClientId clientId) {
            try {
                OzoneManagerRatisUtils.submitRequest(KeyDeletingService.this.getOzoneManager(), omRequest, clientId, KeyDeletingService.this.getRunCount().get());
            }
            catch (ServiceException e) {
                LOG.error("Snapshot deep cleaning request failed. Will retry at next run.", (Throwable)e);
            }
        }
    }
}

