/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.snapshot;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.OzoneConsts;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.snapshot.ObjectPathResolver;

public class FSODirectoryPathResolver
implements ObjectPathResolver {
    private final String prefix;
    private final long bucketId;
    private final Table<String, OmDirectoryInfo> dirInfoTable;

    public FSODirectoryPathResolver(String prefix, long bucketId, Table<String, OmDirectoryInfo> dirInfoTable) {
        this.prefix = prefix;
        this.dirInfoTable = dirInfoTable;
        this.bucketId = bucketId;
    }

    private void addToPathMap(Pair<Long, Path> objectIDPath, Set<Long> dirObjIds, Map<Long, Path> pathMap) {
        if (dirObjIds.contains(objectIDPath.getKey())) {
            pathMap.put((Long)objectIDPath.getKey(), (Path)objectIDPath.getValue());
            dirObjIds.remove(objectIDPath.getKey());
        }
    }

    @Override
    public Map<Long, Path> getAbsolutePathForObjectIDs(Optional<Set<Long>> dirObjIds, boolean skipUnresolvedObjs) throws IOException {
        if (!dirObjIds.isPresent() || dirObjIds.get().isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet objIds = Sets.newHashSet((Iterable)dirObjIds.get());
        HashMap<Long, Path> objectIdPathMap = new HashMap<Long, Path>();
        LinkedList<Pair> objectIdPathVals = new LinkedList<Pair>();
        Pair root = Pair.of((Object)this.bucketId, (Object)OzoneConsts.ROOT_PATH);
        objectIdPathVals.add(root);
        this.addToPathMap((Pair<Long, Path>)root, objIds, objectIdPathMap);
        while (!objectIdPathVals.isEmpty() && !objIds.isEmpty()) {
            Pair parent = (Pair)objectIdPathVals.poll();
            Throwable throwable = null;
            Object var9_10 = null;
            try (TableIterator subDirIter = this.dirInfoTable.iterator((Object)(String.valueOf(this.prefix) + parent.getKey() + "/"));){
                while (!objIds.isEmpty() && subDirIter.hasNext()) {
                    OmDirectoryInfo childDir = (OmDirectoryInfo)((Table.KeyValue)subDirIter.next()).getValue();
                    Pair pathVal = Pair.of((Object)childDir.getObjectID(), (Object)((Path)parent.getValue()).resolve(childDir.getName()));
                    this.addToPathMap((Pair<Long, Path>)pathVal, objIds, objectIdPathMap);
                    objectIdPathVals.add(pathVal);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (!objIds.isEmpty() && !skipUnresolvedObjs) {
            throw new IllegalArgumentException("Dir object Ids required but not found in bucket: " + objIds);
        }
        return objectIdPathMap;
    }
}

