/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocolPB;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.fs.SafeModeAction;
import org.apache.hadoop.hdds.client.ECReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.protocolPB.OzonePBHelper;
import org.apache.hadoop.hdds.utils.FaultInjector;
import org.apache.hadoop.metrics2.lib.MutableRate;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.om.OzoneManager;
import org.apache.hadoop.ozone.om.OzoneManagerPrepareState;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.om.execution.flowcontrol.ExecutionContext;
import org.apache.hadoop.ozone.om.helpers.BasicOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.DBUpdates;
import org.apache.hadoop.ozone.om.helpers.KeyInfoWithVolumeContext;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.ListKeysLightResult;
import org.apache.hadoop.ozone.om.helpers.ListKeysResult;
import org.apache.hadoop.ozone.om.helpers.ListOpenFilesResult;
import org.apache.hadoop.ozone.om.helpers.OMAuditLogger;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyArgs;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadList;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadListParts;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OpenKeySession;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatusLight;
import org.apache.hadoop.ozone.om.helpers.ServiceInfo;
import org.apache.hadoop.ozone.om.helpers.ServiceInfoEx;
import org.apache.hadoop.ozone.om.helpers.SnapshotDiffJob;
import org.apache.hadoop.ozone.om.helpers.SnapshotInfo;
import org.apache.hadoop.ozone.om.helpers.TenantStateList;
import org.apache.hadoop.ozone.om.helpers.TenantUserInfoValue;
import org.apache.hadoop.ozone.om.helpers.TenantUserList;
import org.apache.hadoop.ozone.om.ratis.utils.OzoneManagerRatisUtils;
import org.apache.hadoop.ozone.om.request.OMClientRequest;
import org.apache.hadoop.ozone.om.request.util.OmResponseUtil;
import org.apache.hadoop.ozone.om.request.validation.RequestFeatureValidator;
import org.apache.hadoop.ozone.om.request.validation.RequestProcessingPhase;
import org.apache.hadoop.ozone.om.request.validation.ValidationCondition;
import org.apache.hadoop.ozone.om.request.validation.ValidationContext;
import org.apache.hadoop.ozone.om.response.OMClientResponse;
import org.apache.hadoop.ozone.om.upgrade.DisallowedUntilLayoutVersion;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeature;
import org.apache.hadoop.ozone.om.upgrade.OMLayoutFeatureAspect;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.protocolPB.RequestHandler;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.snapshot.CancelSnapshotDiffResponse;
import org.apache.hadoop.ozone.snapshot.ListSnapshotResponse;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalization;
import org.apache.hadoop.ozone.util.MetricUtil;
import org.apache.hadoop.ozone.util.PayloadUtils;
import org.apache.hadoop.ozone.util.ProtobufUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OzoneManagerRequestHandler
implements RequestHandler {
    static final Logger LOG;
    private final OzoneManager impl;
    private FaultInjector injector;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        OzoneManagerRequestHandler.ajc$preClinit();
        LOG = LoggerFactory.getLogger(OzoneManagerRequestHandler.class);
    }

    public OzoneManagerRequestHandler(OzoneManager om) {
        this.impl = om;
    }

    @Override
    public OzoneManagerProtocolProtos.OMResponse handleReadRequest(OzoneManagerProtocolProtos.OMRequest request) {
        OzoneManagerProtocolProtos.OMResponse.Builder responseBuilder;
        block44: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received OMRequest: {}, ", (Object)request);
            }
            OzoneManagerProtocolProtos.Type cmdType = request.getCmdType();
            responseBuilder = OmResponseUtil.getOMResponseBuilder(request);
            try {
                switch (cmdType) {
                    case CheckVolumeAccess: {
                        OzoneManagerProtocolProtos.CheckVolumeAccessResponse checkVolumeAccessResponse = this.checkVolumeAccess(request.getCheckVolumeAccessRequest());
                        responseBuilder.setCheckVolumeAccessResponse(checkVolumeAccessResponse);
                        break;
                    }
                    case InfoVolume: {
                        OzoneManagerProtocolProtos.InfoVolumeResponse infoVolumeResponse = this.infoVolume(request.getInfoVolumeRequest());
                        responseBuilder.setInfoVolumeResponse(infoVolumeResponse);
                        break;
                    }
                    case ListVolume: {
                        OzoneManagerProtocolProtos.ListVolumeResponse listVolumeResponse = this.listVolumes(request.getListVolumeRequest());
                        responseBuilder.setListVolumeResponse(listVolumeResponse);
                        break;
                    }
                    case InfoBucket: {
                        OzoneManagerProtocolProtos.InfoBucketResponse infoBucketResponse = this.infoBucket(request.getInfoBucketRequest());
                        responseBuilder.setInfoBucketResponse(infoBucketResponse);
                        break;
                    }
                    case ListBuckets: {
                        OzoneManagerProtocolProtos.ListBucketsResponse listBucketsResponse = this.listBuckets(request.getListBucketsRequest());
                        responseBuilder.setListBucketsResponse(listBucketsResponse);
                        break;
                    }
                    case LookupKey: {
                        OzoneManagerProtocolProtos.LookupKeyResponse lookupKeyResponse = this.lookupKey(request.getLookupKeyRequest(), request.getVersion());
                        responseBuilder.setLookupKeyResponse(lookupKeyResponse);
                        break;
                    }
                    case ListKeys: {
                        OzoneManagerProtocolProtos.ListKeysResponse listKeysResponse = this.listKeys(request.getListKeysRequest(), request.getVersion());
                        responseBuilder.setListKeysResponse(listKeysResponse);
                        break;
                    }
                    case ListKeysLight: {
                        OzoneManagerProtocolProtos.ListKeysLightResponse listKeysLightResponse = this.listKeysLight(request.getListKeysRequest());
                        responseBuilder.setListKeysLightResponse(listKeysLightResponse);
                        break;
                    }
                    case ListMultiPartUploadParts: {
                        OzoneManagerProtocolProtos.MultipartUploadListPartsResponse listPartsResponse = this.listParts(request.getListMultipartUploadPartsRequest());
                        responseBuilder.setListMultipartUploadPartsResponse(listPartsResponse);
                        break;
                    }
                    case ListMultipartUploads: {
                        OzoneManagerProtocolProtos.ListMultipartUploadsResponse response = this.listMultipartUploads(request.getListMultipartUploadsRequest());
                        responseBuilder.setListMultipartUploadsResponse(response);
                        break;
                    }
                    case ListOpenFiles: {
                        OzoneManagerProtocolProtos.ListOpenFilesResponse listOpenFilesResponse = this.listOpenFiles(request.getListOpenFilesRequest(), request.getVersion());
                        responseBuilder.setListOpenFilesResponse(listOpenFilesResponse);
                        break;
                    }
                    case ServiceList: {
                        OzoneManagerProtocolProtos.ServiceListResponse serviceListResponse = this.getServiceList(request.getServiceListRequest());
                        responseBuilder.setServiceListResponse(serviceListResponse);
                        break;
                    }
                    case RangerBGSync: {
                        OzoneManagerProtocolProtos.RangerBGSyncResponse rangerBGSyncResponse = this.triggerRangerBGSync(request.getRangerBGSyncRequest());
                        responseBuilder.setRangerBGSyncResponse(rangerBGSyncResponse);
                        break;
                    }
                    case DBUpdates: {
                        OzoneManagerProtocolProtos.DBUpdatesResponse dbUpdatesResponse = this.getOMDBUpdates(request.getDbUpdatesRequest());
                        responseBuilder.setDbUpdatesResponse(dbUpdatesResponse);
                        break;
                    }
                    case GetFileStatus: {
                        OzoneManagerProtocolProtos.GetFileStatusResponse getFileStatusResponse = this.getOzoneFileStatus(request.getGetFileStatusRequest(), request.getVersion());
                        responseBuilder.setGetFileStatusResponse(getFileStatusResponse);
                        break;
                    }
                    case LookupFile: {
                        OzoneManagerProtocolProtos.LookupFileResponse lookupFileResponse = this.lookupFile(request.getLookupFileRequest(), request.getVersion());
                        responseBuilder.setLookupFileResponse(lookupFileResponse);
                        break;
                    }
                    case ListStatus: {
                        OzoneManagerProtocolProtos.ListStatusResponse listStatusResponse = this.listStatus(request.getListStatusRequest(), request.getVersion());
                        responseBuilder.setListStatusResponse(listStatusResponse);
                        break;
                    }
                    case ListStatusLight: {
                        OzoneManagerProtocolProtos.ListStatusLightResponse listStatusLightResponse = this.listStatusLight(request.getListStatusRequest(), request.getVersion());
                        responseBuilder.setListStatusLightResponse(listStatusLightResponse);
                        break;
                    }
                    case GetAcl: {
                        OzoneManagerProtocolProtos.GetAclResponse getAclResponse = this.getAcl(request.getGetAclRequest());
                        responseBuilder.setGetAclResponse(getAclResponse);
                        break;
                    }
                    case FinalizeUpgradeProgress: {
                        OzoneManagerProtocolProtos.FinalizeUpgradeProgressResponse upgradeProgressResponse = this.reportUpgradeProgress(request.getFinalizeUpgradeProgressRequest());
                        responseBuilder.setFinalizeUpgradeProgressResponse(upgradeProgressResponse);
                        break;
                    }
                    case PrepareStatus: {
                        OzoneManagerProtocolProtos.PrepareStatusResponse prepareStatusResponse = this.getPrepareStatus();
                        responseBuilder.setPrepareStatusResponse(prepareStatusResponse);
                        break;
                    }
                    case GetS3VolumeContext: {
                        OzoneManagerProtocolProtos.GetS3VolumeContextResponse s3VolumeContextResponse = this.getS3VolumeContext();
                        responseBuilder.setGetS3VolumeContextResponse(s3VolumeContextResponse);
                        break;
                    }
                    case TenantGetUserInfo: {
                        this.impl.checkS3MultiTenancyEnabled();
                        OzoneManagerProtocolProtos.TenantGetUserInfoResponse getUserInfoResponse = this.tenantGetUserInfo(request.getTenantGetUserInfoRequest());
                        responseBuilder.setTenantGetUserInfoResponse(getUserInfoResponse);
                        break;
                    }
                    case ListTenant: {
                        this.impl.checkS3MultiTenancyEnabled();
                        OzoneManagerProtocolProtos.ListTenantResponse listTenantResponse = this.listTenant(request.getListTenantRequest());
                        responseBuilder.setListTenantResponse(listTenantResponse);
                        break;
                    }
                    case TenantListUser: {
                        this.impl.checkS3MultiTenancyEnabled();
                        OzoneManagerProtocolProtos.TenantListUserResponse listUserResponse = this.tenantListUsers(request.getTenantListUserRequest());
                        responseBuilder.setTenantListUserResponse(listUserResponse);
                        break;
                    }
                    case GetKeyInfo: {
                        responseBuilder.setGetKeyInfoResponse(this.getKeyInfo(request.getGetKeyInfoRequest(), request.getVersion()));
                        break;
                    }
                    case ListSnapshot: {
                        OzoneManagerProtocolProtos.ListSnapshotResponse listSnapshotResponse = this.getSnapshots(request.getListSnapshotRequest());
                        responseBuilder.setListSnapshotResponse(listSnapshotResponse);
                        break;
                    }
                    case SnapshotDiff: {
                        OzoneManagerProtocolProtos.SnapshotDiffResponse snapshotDiffReport = this.snapshotDiff(request.getSnapshotDiffRequest());
                        responseBuilder.setSnapshotDiffResponse(snapshotDiffReport);
                        break;
                    }
                    case CancelSnapshotDiff: {
                        OzoneManagerProtocolProtos.CancelSnapshotDiffResponse cancelSnapshotDiff = this.cancelSnapshotDiff(request.getCancelSnapshotDiffRequest());
                        responseBuilder.setCancelSnapshotDiffResponse(cancelSnapshotDiff);
                        break;
                    }
                    case ListSnapshotDiffJobs: {
                        OzoneManagerProtocolProtos.ListSnapshotDiffJobResponse listSnapDiffResponse = this.listSnapshotDiffJobs(request.getListSnapshotDiffJobRequest());
                        responseBuilder.setListSnapshotDiffJobResponse(listSnapDiffResponse);
                        break;
                    }
                    case EchoRPC: {
                        OzoneManagerProtocolProtos.EchoRPCResponse echoRPCResponse = this.echoRPC(request.getEchoRPCRequest());
                        responseBuilder.setEchoRPCResponse(echoRPCResponse);
                        break;
                    }
                    case TransferLeadership: {
                        responseBuilder.setTransferOmLeadershipResponse(this.transferLeadership(request.getTransferOmLeadershipRequest()));
                        break;
                    }
                    case RefetchSecretKey: {
                        responseBuilder.setRefetchSecretKeyResponse(this.refetchSecretKey());
                        break;
                    }
                    case SetSafeMode: {
                        OzoneManagerProtocolProtos.SetSafeModeResponse setSafeModeResponse = this.setSafeMode(request.getSetSafeModeRequest());
                        responseBuilder.setSetSafeModeResponse(setSafeModeResponse);
                        break;
                    }
                    case PrintCompactionLogDag: {
                        OzoneManagerProtocolProtos.PrintCompactionLogDagResponse printCompactionLogDagResponse = this.printCompactionLogDag(request.getPrintCompactionLogDagRequest());
                        responseBuilder.setPrintCompactionLogDagResponse(printCompactionLogDagResponse);
                        break;
                    }
                    case GetSnapshotInfo: {
                        OzoneManagerProtocolProtos.SnapshotInfoResponse snapshotInfoResponse = this.getSnapshotInfo(request.getSnapshotInfoRequest());
                        responseBuilder.setSnapshotInfoResponse(snapshotInfoResponse);
                        break;
                    }
                    case GetQuotaRepairStatus: {
                        OzoneManagerProtocolProtos.GetQuotaRepairStatusResponse quotaRepairStatusRsp = this.getQuotaRepairStatus(request.getGetQuotaRepairStatusRequest());
                        responseBuilder.setGetQuotaRepairStatusResponse(quotaRepairStatusRsp);
                        break;
                    }
                    case StartQuotaRepair: {
                        OzoneManagerProtocolProtos.StartQuotaRepairResponse startQuotaRepairRsp = this.startQuotaRepair(request.getStartQuotaRepairRequest());
                        responseBuilder.setStartQuotaRepairResponse(startQuotaRepairRsp);
                        break;
                    }
                    case GetObjectTagging: {
                        OzoneManagerProtocolProtos.GetObjectTaggingResponse getObjectTaggingResponse = this.getObjectTagging(request.getGetObjectTaggingRequest());
                        responseBuilder.setGetObjectTaggingResponse(getObjectTaggingResponse);
                        break;
                    }
                    default: {
                        responseBuilder.setSuccess(false);
                        responseBuilder.setMessage("Unrecognized Command Type: " + cmdType);
                    }
                }
                responseBuilder.setSuccess(true);
            }
            catch (IOException ex) {
                responseBuilder.setSuccess(false);
                responseBuilder.setStatus(this.exceptionToResponseStatus(ex));
                if (ex.getMessage() == null) break block44;
                responseBuilder.setMessage(ex.getMessage());
            }
        }
        return responseBuilder.build();
    }

    @Override
    public OMClientResponse handleWriteRequestImpl(OzoneManagerProtocolProtos.OMRequest omRequest, ExecutionContext context) throws IOException {
        this.injectPause();
        OMClientRequest omClientRequest = OzoneManagerRatisUtils.createClientRequest(omRequest, this.impl);
        try {
            OMClientResponse omClientResponse = (OMClientResponse)MetricUtil.captureLatencyNs((MutableRate)this.impl.getPerfMetrics().getValidateAndUpdateCacheLatencyNs(), () -> Objects.requireNonNull(omClientRequest.validateAndUpdateCache(this.getOzoneManager(), context), "omClientResponse returned by validateAndUpdateCache cannot be null"));
            OMAuditLogger.log(omClientRequest.getAuditBuilder(), context.getTermIndex());
            return omClientResponse;
        }
        catch (Throwable th) {
            OMAuditLogger.log(omClientRequest.getAuditBuilder(), omClientRequest, this.getOzoneManager(), context.getTermIndex(), th);
            throw th;
        }
    }

    @VisibleForTesting
    public void setInjector(FaultInjector injector) {
        this.injector = injector;
    }

    @VisibleForTesting
    public FaultInjector getInjector() {
        return this.injector;
    }

    private void injectPause() throws IOException {
        if (this.injector != null) {
            this.injector.pause();
        }
    }

    private OzoneManagerProtocolProtos.DBUpdatesResponse getOMDBUpdates(OzoneManagerProtocolProtos.DBUpdatesRequest dbUpdatesRequest) throws IOException {
        OzoneManagerProtocolProtos.DBUpdatesResponse.Builder builder = OzoneManagerProtocolProtos.DBUpdatesResponse.newBuilder();
        DBUpdates dbUpdatesWrapper = this.impl.getDBUpdates(dbUpdatesRequest);
        int i = 0;
        while (i < dbUpdatesWrapper.getData().size()) {
            builder.addData(OzonePBHelper.getByteString((byte[])((byte[])dbUpdatesWrapper.getData().get(i))));
            ++i;
        }
        builder.setSequenceNumber(dbUpdatesWrapper.getCurrentSequenceNumber());
        builder.setLatestSequenceNumber(dbUpdatesWrapper.getLatestSequenceNumber());
        builder.setDbUpdateSuccess(dbUpdatesWrapper.isDBUpdateSuccess());
        return builder.build();
    }

    private OzoneManagerProtocolProtos.GetAclResponse getAcl(OzoneManagerProtocolProtos.GetAclRequest req) throws IOException {
        ArrayList acls = new ArrayList();
        List<OzoneAcl> aclList = this.impl.getAcl((OzoneObj)OzoneObjInfo.fromProtobuf((OzoneManagerProtocolProtos.OzoneObj)req.getObj()));
        if (aclList != null) {
            aclList.forEach(a -> {
                boolean bl = acls.add(OzoneAcl.toProtobuf((OzoneAcl)a));
            });
        }
        return OzoneManagerProtocolProtos.GetAclResponse.newBuilder().addAllAcls(acls).build();
    }

    protected OzoneManagerProtocolProtos.Status exceptionToResponseStatus(IOException ex) {
        if (ex instanceof OMException) {
            return OzoneManagerProtocolProtos.Status.values()[((OMException)((Object)ex)).getResult().ordinal()];
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unknown error occurs", (Throwable)ex);
        }
        return OzoneManagerProtocolProtos.Status.INTERNAL_ERROR;
    }

    @Override
    public void validateRequest(OzoneManagerProtocolProtos.OMRequest omRequest) throws OMException {
        OzoneManagerProtocolProtos.Type cmdType = omRequest.getCmdType();
        if (cmdType == null) {
            throw new OMException("CmdType is null", OMException.ResultCodes.INVALID_REQUEST);
        }
        if (omRequest.getClientId() == null) {
            throw new OMException("ClientId is null", OMException.ResultCodes.INVALID_REQUEST);
        }
        if (omRequest.getLayoutVersion() == null) {
            throw new OMException("LayoutVersion for request is null.", OMException.ResultCodes.INTERNAL_ERROR);
        }
    }

    private OzoneManagerProtocolProtos.CheckVolumeAccessResponse checkVolumeAccess(OzoneManagerProtocolProtos.CheckVolumeAccessRequest request) throws IOException {
        OzoneManagerProtocolProtos.CheckVolumeAccessResponse.Builder resp = OzoneManagerProtocolProtos.CheckVolumeAccessResponse.newBuilder();
        boolean access = this.impl.checkVolumeAccess(request.getVolumeName(), request.getUserAcl());
        if (!access) {
            throw new OMException(OMException.ResultCodes.ACCESS_DENIED);
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.InfoVolumeResponse infoVolume(OzoneManagerProtocolProtos.InfoVolumeRequest request) throws IOException {
        OzoneManagerProtocolProtos.InfoVolumeResponse.Builder resp = OzoneManagerProtocolProtos.InfoVolumeResponse.newBuilder();
        String volume = request.getVolumeName();
        OmVolumeArgs ret = this.impl.getVolumeInfo(volume);
        resp.setVolumeInfo(ret.getProtobuf());
        return resp.build();
    }

    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.MULTITENANCY_SCHEMA)
    private OzoneManagerProtocolProtos.TenantGetUserInfoResponse tenantGetUserInfo(OzoneManagerProtocolProtos.TenantGetUserInfoRequest request) throws IOException {
        OzoneManagerProtocolProtos.TenantGetUserInfoRequest tenantGetUserInfoRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)tenantGetUserInfoRequest);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        OzoneManagerProtocolProtos.TenantGetUserInfoResponse.Builder resp = OzoneManagerProtocolProtos.TenantGetUserInfoResponse.newBuilder();
        String userPrincipal = request.getUserPrincipal();
        TenantUserInfoValue ret = this.impl.tenantGetUserInfo(userPrincipal);
        if (ret != null) {
            resp.addAllAccessIdInfo((Iterable)ret.getAccessIdInfoList());
        }
        return resp.build();
    }

    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.MULTITENANCY_SCHEMA)
    private OzoneManagerProtocolProtos.TenantListUserResponse tenantListUsers(OzoneManagerProtocolProtos.TenantListUserRequest request) throws IOException {
        OzoneManagerProtocolProtos.TenantListUserRequest tenantListUserRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)tenantListUserRequest);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        OzoneManagerProtocolProtos.TenantListUserResponse.Builder builder = OzoneManagerProtocolProtos.TenantListUserResponse.newBuilder();
        TenantUserList usersInTenant = this.impl.listUsersInTenant(request.getTenantId(), request.getPrefix());
        if (usersInTenant != null) {
            builder.addAllUserAccessIdInfo((Iterable)usersInTenant.getUserAccessIds());
        }
        return builder.build();
    }

    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.MULTITENANCY_SCHEMA)
    private OzoneManagerProtocolProtos.ListTenantResponse listTenant(OzoneManagerProtocolProtos.ListTenantRequest request) throws IOException {
        OzoneManagerProtocolProtos.ListTenantRequest listTenantRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)listTenantRequest);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        OzoneManagerProtocolProtos.ListTenantResponse.Builder resp = OzoneManagerProtocolProtos.ListTenantResponse.newBuilder();
        TenantStateList ret = this.impl.listTenant();
        resp.addAllTenantState((Iterable)ret.getTenantStateList());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.ListVolumeResponse listVolumes(OzoneManagerProtocolProtos.ListVolumeRequest request) throws IOException {
        OzoneManagerProtocolProtos.ListVolumeResponse.Builder resp = OzoneManagerProtocolProtos.ListVolumeResponse.newBuilder();
        List<Object> result = Lists.newArrayList();
        if (request.getScope() == OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_USER) {
            result = this.impl.listVolumeByUser(request.getUserName(), request.getPrefix(), request.getPrevKey(), request.getMaxKeys());
        } else if (request.getScope() == OzoneManagerProtocolProtos.ListVolumeRequest.Scope.VOLUMES_BY_CLUSTER) {
            result = this.impl.listAllVolumes(request.getPrefix(), request.getPrevKey(), request.getMaxKeys());
        }
        result.forEach(item -> {
            OzoneManagerProtocolProtos.ListVolumeResponse.Builder builder2 = resp.addVolumeInfo(item.getProtobuf());
        });
        return resp.build();
    }

    private OzoneManagerProtocolProtos.InfoBucketResponse infoBucket(OzoneManagerProtocolProtos.InfoBucketRequest request) throws IOException {
        OzoneManagerProtocolProtos.InfoBucketResponse.Builder resp = OzoneManagerProtocolProtos.InfoBucketResponse.newBuilder();
        OmBucketInfo omBucketInfo = this.impl.getBucketInfo(request.getVolumeName(), request.getBucketName());
        resp.setBucketInfo(omBucketInfo.getProtobuf());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.LookupKeyResponse lookupKey(OzoneManagerProtocolProtos.LookupKeyRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.LookupKeyResponse.Builder resp = OzoneManagerProtocolProtos.LookupKeyResponse.newBuilder();
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setLatestVersionLocation(keyArgs.getLatestVersionLocation()).setSortDatanodesInPipeline(keyArgs.getSortDatanodes()).setHeadOp(keyArgs.getHeadOp()).build();
        OmKeyInfo keyInfo = this.impl.lookupKey(omKeyArgs);
        resp.setKeyInfo(keyInfo.getProtobuf(keyArgs.getHeadOp(), clientVersion));
        return resp.build();
    }

    private OzoneManagerProtocolProtos.GetKeyInfoResponse getKeyInfo(OzoneManagerProtocolProtos.GetKeyInfoRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setLatestVersionLocation(keyArgs.getLatestVersionLocation()).setSortDatanodesInPipeline(keyArgs.getSortDatanodes()).setHeadOp(keyArgs.getHeadOp()).setForceUpdateContainerCacheFromSCM(keyArgs.getForceUpdateContainerCacheFromSCM()).setMultipartUploadPartNumber(keyArgs.getMultipartNumber()).build();
        KeyInfoWithVolumeContext keyInfo = this.impl.getKeyInfo(omKeyArgs, request.getAssumeS3Context());
        return keyInfo.toProtobuf(clientVersion);
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.POST_PROCESS, requestType=OzoneManagerProtocolProtos.Type.LookupKey)
    public static OzoneManagerProtocolProtos.OMResponse disallowLookupKeyResponseWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, OzoneManagerProtocolProtos.OMResponse resp, ValidationContext ctx) throws ServiceException {
        if (!resp.hasLookupKeyResponse()) {
            return resp;
        }
        if (resp.getLookupKeyResponse().getKeyInfo().hasEcReplicationConfig()) {
            resp = resp.toBuilder().setStatus(OzoneManagerProtocolProtos.Status.NOT_SUPPORTED_OPERATION).setMessage("Key is a key with Erasure Coded replication, which the client can not understand.\nPlease upgrade the client before trying to read the key: " + req.getLookupKeyRequest().getKeyArgs().getVolumeName() + "/" + req.getLookupKeyRequest().getKeyArgs().getBucketName() + "/" + req.getLookupKeyRequest().getKeyArgs().getKeyName() + ".").clearLookupKeyResponse().build();
        }
        return resp;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.POST_PROCESS, requestType=OzoneManagerProtocolProtos.Type.LookupKey)
    public static OzoneManagerProtocolProtos.OMResponse disallowLookupKeyWithBucketLayout(OzoneManagerProtocolProtos.OMRequest req, OzoneManagerProtocolProtos.OMResponse resp, ValidationContext ctx) throws ServiceException, IOException {
        if (!resp.hasLookupKeyResponse()) {
            return resp;
        }
        OzoneManagerProtocolProtos.KeyInfo keyInfo = resp.getLookupKeyResponse().getKeyInfo();
        if (keyInfo.hasVolumeName() && keyInfo.hasBucketName() && !ctx.getBucketLayout(keyInfo.getVolumeName(), keyInfo.getBucketName()).equals((Object)BucketLayout.LEGACY)) {
            resp = resp.toBuilder().setStatus(OzoneManagerProtocolProtos.Status.NOT_SUPPORTED_OPERATION).setMessage("Key is present inside a bucket with bucket layout features, which the client can not understand. Please upgrade the client to a compatible version before trying to read the key info for " + req.getLookupKeyRequest().getKeyArgs().getVolumeName() + "/" + req.getLookupKeyRequest().getKeyArgs().getBucketName() + "/" + req.getLookupKeyRequest().getKeyArgs().getKeyName() + ".").clearLookupKeyResponse().build();
        }
        return resp;
    }

    private OzoneManagerProtocolProtos.ListBucketsResponse listBuckets(OzoneManagerProtocolProtos.ListBucketsRequest request) throws IOException {
        OzoneManagerProtocolProtos.ListBucketsResponse.Builder resp = OzoneManagerProtocolProtos.ListBucketsResponse.newBuilder();
        List<OmBucketInfo> buckets = this.impl.listBuckets(request.getVolumeName(), request.getStartKey(), request.getPrefix(), request.getCount(), request.getHasSnapshot());
        for (OmBucketInfo bucket : buckets) {
            resp.addBucketInfo(bucket.getProtobuf());
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.ListKeysResponse listKeys(OzoneManagerProtocolProtos.ListKeysRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.ListKeysResponse.Builder resp = OzoneManagerProtocolProtos.ListKeysResponse.newBuilder();
        ListKeysResult listKeysResult = this.impl.listKeys(request.getVolumeName(), request.getBucketName(), request.getStartKey(), request.getPrefix(), this.limitListSizeInt(request.getCount()));
        for (OmKeyInfo key : listKeysResult.getKeys()) {
            resp.addKeyInfo(key.getProtobuf(true, clientVersion));
        }
        resp.setIsTruncated(listKeysResult.isTruncated());
        return resp.build();
    }

    private OzoneManagerProtocolProtos.ListKeysLightResponse listKeysLight(OzoneManagerProtocolProtos.ListKeysRequest request) throws IOException {
        OzoneManagerProtocolProtos.ListKeysLightResponse.Builder resp = OzoneManagerProtocolProtos.ListKeysLightResponse.newBuilder();
        ListKeysLightResult listKeysLightResult = this.impl.listKeysLight(request.getVolumeName(), request.getBucketName(), request.getStartKey(), request.getPrefix(), this.limitListSizeInt(request.getCount()));
        for (BasicOmKeyInfo key : listKeysLightResult.getKeys()) {
            resp.addBasicKeyInfo(key.getProtobuf());
        }
        resp.setIsTruncated(listKeysLightResult.isTruncated());
        return resp.build();
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.POST_PROCESS, requestType=OzoneManagerProtocolProtos.Type.ListKeys)
    public static OzoneManagerProtocolProtos.OMResponse disallowListKeysResponseWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, OzoneManagerProtocolProtos.OMResponse resp, ValidationContext ctx) throws ServiceException {
        if (!resp.hasListKeysResponse()) {
            return resp;
        }
        List keys = resp.getListKeysResponse().getKeyInfoList();
        for (OzoneManagerProtocolProtos.KeyInfo key : keys) {
            if (!key.hasEcReplicationConfig()) continue;
            resp = resp.toBuilder().setStatus(OzoneManagerProtocolProtos.Status.NOT_SUPPORTED_OPERATION).setMessage("The list of keys contains keys with Erasure Coded replication set, hence the client is not able to represent all the keys returned. Please upgrade the client to get the list of keys.").clearListKeysResponse().build();
        }
        return resp;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.POST_PROCESS, requestType=OzoneManagerProtocolProtos.Type.ListKeys)
    public static OzoneManagerProtocolProtos.OMResponse disallowListKeysWithBucketLayout(OzoneManagerProtocolProtos.OMRequest req, OzoneManagerProtocolProtos.OMResponse resp, ValidationContext ctx) throws ServiceException, IOException {
        if (!resp.hasListKeysResponse()) {
            return resp;
        }
        HashSet<ImmutablePair> volumeBucketSet = new HashSet<ImmutablePair>();
        List keys = resp.getListKeysResponse().getKeyInfoList();
        for (OzoneManagerProtocolProtos.KeyInfo keyInfo : keys) {
            if (!keyInfo.hasVolumeName() || !keyInfo.hasBucketName()) continue;
            volumeBucketSet.add(new ImmutablePair((Object)keyInfo.getVolumeName(), (Object)keyInfo.getBucketName()));
        }
        for (Pair pair : volumeBucketSet) {
            if (ctx.getBucketLayout((String)pair.getLeft(), (String)pair.getRight()).isLegacy()) continue;
            resp = resp.toBuilder().setStatus(OzoneManagerProtocolProtos.Status.NOT_SUPPORTED_OPERATION).setMessage("The list of keys contains keys present inside bucket with bucket layout features, hence the client is not able to understand all the keys returned. Please upgrade the client to get the list of keys.").clearListKeysResponse().build();
            break;
        }
        return resp;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.POST_PROCESS, requestType=OzoneManagerProtocolProtos.Type.ListTrash)
    public static OzoneManagerProtocolProtos.OMResponse disallowListTrashWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, OzoneManagerProtocolProtos.OMResponse resp, ValidationContext ctx) throws ServiceException {
        if (!resp.hasListTrashResponse()) {
            return resp;
        }
        List repeatedKeys = resp.getListTrashResponse().getDeletedKeysList();
        for (OzoneManagerProtocolProtos.RepeatedKeyInfo repeatedKey : repeatedKeys) {
            for (OzoneManagerProtocolProtos.KeyInfo key : repeatedKey.getKeyInfoList()) {
                if (!key.hasEcReplicationConfig()) continue;
                resp = resp.toBuilder().setStatus(OzoneManagerProtocolProtos.Status.NOT_SUPPORTED_OPERATION).setMessage("The list of keys contains keys with Erasure Coded replication set, hence the client is not able to represent all the keys returned. Please upgrade the client to get the list of keys.").clearListTrashResponse().build();
            }
        }
        return resp;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.POST_PROCESS, requestType=OzoneManagerProtocolProtos.Type.ListTrash)
    public static OzoneManagerProtocolProtos.OMResponse disallowListTrashWithBucketLayout(OzoneManagerProtocolProtos.OMRequest req, OzoneManagerProtocolProtos.OMResponse resp, ValidationContext ctx) throws ServiceException, IOException {
        if (!resp.hasListTrashResponse()) {
            return resp;
        }
        List repeatedKeys = resp.getListTrashResponse().getDeletedKeysList();
        HashSet<ImmutablePair> volumeBucketSet = new HashSet<ImmutablePair>();
        for (OzoneManagerProtocolProtos.RepeatedKeyInfo repeatedKeyInfo : repeatedKeys) {
            for (OzoneManagerProtocolProtos.KeyInfo key : repeatedKeyInfo.getKeyInfoList()) {
                if (!key.hasVolumeName() || !key.hasBucketName()) continue;
                volumeBucketSet.add(new ImmutablePair((Object)key.getVolumeName(), (Object)key.getBucketName()));
            }
        }
        for (Pair pair : volumeBucketSet) {
            if (ctx.getBucketLayout((String)pair.getLeft(), (String)pair.getRight()).isLegacy()) continue;
            resp = resp.toBuilder().setStatus(OzoneManagerProtocolProtos.Status.NOT_SUPPORTED_OPERATION).setMessage("The list of keys contains keys present in buckets  using bucket layout features, hence the client is not able to understand all the keys returned. Please upgrade the client to get the list of keys.").clearListTrashResponse().build();
            break;
        }
        return resp;
    }

    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.HBASE_SUPPORT)
    private OzoneManagerProtocolProtos.ListOpenFilesResponse listOpenFiles(OzoneManagerProtocolProtos.ListOpenFilesRequest req, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.ListOpenFilesRequest listOpenFilesRequest = req;
        int n = clientVersion;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)listOpenFilesRequest, (Object)Conversions.intObject((int)n));
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        OzoneManagerProtocolProtos.ListOpenFilesResponse.Builder resp = OzoneManagerProtocolProtos.ListOpenFilesResponse.newBuilder();
        ListOpenFilesResult res = this.impl.listOpenFiles(req.getPath(), this.limitListSizeInt(req.getCount()), req.getToken());
        resp.setTotalOpenKeyCount(res.getTotalOpenKeyCount());
        resp.setHasMore(res.hasMore());
        if (res.getContinuationToken() != null) {
            resp.setContinuationToken(res.getContinuationToken());
        }
        for (OpenKeySession e : res.getOpenKeys()) {
            resp.addClientID(e.getId());
            resp.addKeyInfo(e.getKeyInfo().getProtobuf(clientVersion));
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.ServiceListResponse getServiceList(OzoneManagerProtocolProtos.ServiceListRequest request) throws IOException {
        OzoneManagerProtocolProtos.ServiceListResponse.Builder resp = OzoneManagerProtocolProtos.ServiceListResponse.newBuilder();
        ServiceInfoEx serviceInfoEx = this.impl.getServiceInfo();
        ArrayList<OzoneManagerProtocolProtos.ServiceInfo> serviceInfoProtos = new ArrayList<OzoneManagerProtocolProtos.ServiceInfo>();
        List serviceInfos = serviceInfoEx.getServiceInfoList();
        for (ServiceInfo info : serviceInfos) {
            serviceInfoProtos.add(info.getProtobuf());
        }
        resp.addAllServiceInfo(serviceInfoProtos);
        if (serviceInfoEx.getCaCertificate() != null) {
            resp.setCaCertificate(serviceInfoEx.getCaCertificate());
        }
        for (String ca : serviceInfoEx.getCaCertPemList()) {
            resp.addCaCerts(ca);
        }
        return resp.build();
    }

    private OzoneManagerProtocolProtos.MultipartUploadListPartsResponse listParts(OzoneManagerProtocolProtos.MultipartUploadListPartsRequest multipartUploadListPartsRequest) throws IOException {
        OzoneManagerProtocolProtos.MultipartUploadListPartsResponse.Builder response = OzoneManagerProtocolProtos.MultipartUploadListPartsResponse.newBuilder();
        OmMultipartUploadListParts omMultipartUploadListParts = this.impl.listParts(multipartUploadListPartsRequest.getVolume(), multipartUploadListPartsRequest.getBucket(), multipartUploadListPartsRequest.getKey(), multipartUploadListPartsRequest.getUploadID(), multipartUploadListPartsRequest.getPartNumbermarker(), multipartUploadListPartsRequest.getMaxParts());
        List omPartInfoList = omMultipartUploadListParts.getPartInfoList();
        ArrayList partInfoList = new ArrayList();
        omPartInfoList.forEach(partInfo -> {
            boolean bl = partInfoList.add(partInfo.getProto());
        });
        HddsProtos.ReplicationType repType = omMultipartUploadListParts.getReplicationConfig().getReplicationType();
        response.setType(repType);
        if (repType == HddsProtos.ReplicationType.EC) {
            response.setEcReplicationConfig(((ECReplicationConfig)omMultipartUploadListParts.getReplicationConfig()).toProto());
        } else {
            response.setFactor(ReplicationConfig.getLegacyFactor((ReplicationConfig)omMultipartUploadListParts.getReplicationConfig()));
        }
        response.setNextPartNumberMarker(omMultipartUploadListParts.getNextPartNumberMarker());
        response.setIsTruncated(omMultipartUploadListParts.isTruncated());
        return response.addAllPartsList(partInfoList).build();
    }

    private OzoneManagerProtocolProtos.ListMultipartUploadsResponse listMultipartUploads(OzoneManagerProtocolProtos.ListMultipartUploadsRequest request) throws IOException {
        OmMultipartUploadList omMultipartUploadList = this.impl.listMultipartUploads(request.getVolume(), request.getBucket(), request.getPrefix(), request.getKeyMarker(), request.getUploadIdMarker(), request.getMaxUploads(), request.getWithPagination());
        List info = omMultipartUploadList.getUploads().stream().map(upload -> {
            OzoneManagerProtocolProtos.MultipartUploadInfo.Builder bldr = OzoneManagerProtocolProtos.MultipartUploadInfo.newBuilder().setVolumeName(upload.getVolumeName()).setBucketName(upload.getBucketName()).setKeyName(upload.getKeyName()).setUploadId(upload.getUploadId());
            HddsProtos.ReplicationType repType = upload.getReplicationConfig().getReplicationType();
            bldr.setType(repType);
            if (repType == HddsProtos.ReplicationType.EC) {
                bldr.setEcReplicationConfig(((ECReplicationConfig)upload.getReplicationConfig()).toProto());
            } else {
                bldr.setFactor(ReplicationConfig.getLegacyFactor((ReplicationConfig)upload.getReplicationConfig()));
            }
            bldr.setCreationTime(upload.getCreationTime().toEpochMilli());
            return bldr.build();
        }).collect(Collectors.toList());
        OzoneManagerProtocolProtos.ListMultipartUploadsResponse response = OzoneManagerProtocolProtos.ListMultipartUploadsResponse.newBuilder().addAllUploadsList(info).setIsTruncated(omMultipartUploadList.isTruncated()).setNextKeyMarker(omMultipartUploadList.getNextKeyMarker()).setNextUploadIdMarker(omMultipartUploadList.getNextUploadIdMarker()).build();
        return response;
    }

    private OzoneManagerProtocolProtos.GetFileStatusResponse getOzoneFileStatus(OzoneManagerProtocolProtos.GetFileStatusRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).build();
        OzoneManagerProtocolProtos.GetFileStatusResponse.Builder rb = OzoneManagerProtocolProtos.GetFileStatusResponse.newBuilder();
        rb.setStatus(this.impl.getFileStatus(omKeyArgs).getProtobuf(clientVersion));
        return rb.build();
    }

    private OzoneManagerProtocolProtos.RangerBGSyncResponse triggerRangerBGSync(OzoneManagerProtocolProtos.RangerBGSyncRequest rangerBGSyncRequest) throws IOException {
        boolean res = this.impl.triggerRangerBGSync(rangerBGSyncRequest.getNoWait());
        return OzoneManagerProtocolProtos.RangerBGSyncResponse.newBuilder().setRunSuccess(res).build();
    }

    private OzoneManagerProtocolProtos.RefetchSecretKeyResponse refetchSecretKey() {
        UUID uuid = this.impl.refetchSecretKey();
        OzoneManagerProtocolProtos.RefetchSecretKeyResponse response = OzoneManagerProtocolProtos.RefetchSecretKeyResponse.newBuilder().setId(ProtobufUtils.toProtobuf((UUID)uuid)).build();
        return response;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.POST_PROCESS, requestType=OzoneManagerProtocolProtos.Type.GetFileStatus)
    public static OzoneManagerProtocolProtos.OMResponse disallowGetFileStatusWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, OzoneManagerProtocolProtos.OMResponse resp, ValidationContext ctx) throws ServiceException {
        if (!resp.hasGetFileStatusResponse()) {
            return resp;
        }
        if (resp.getGetFileStatusResponse().getStatus().getKeyInfo().hasEcReplicationConfig()) {
            resp = resp.toBuilder().setStatus(OzoneManagerProtocolProtos.Status.NOT_SUPPORTED_OPERATION).setMessage("Key is a key with Erasure Coded replication, which the client can not understand. Please upgrade the client before trying to read the key info for " + req.getGetFileStatusRequest().getKeyArgs().getVolumeName() + "/" + req.getGetFileStatusRequest().getKeyArgs().getBucketName() + "/" + req.getGetFileStatusRequest().getKeyArgs().getKeyName() + ".").clearGetFileStatusResponse().build();
        }
        return resp;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.POST_PROCESS, requestType=OzoneManagerProtocolProtos.Type.GetFileStatus)
    public static OzoneManagerProtocolProtos.OMResponse disallowGetFileStatusWithBucketLayout(OzoneManagerProtocolProtos.OMRequest req, OzoneManagerProtocolProtos.OMResponse resp, ValidationContext ctx) throws ServiceException, IOException {
        if (!resp.hasGetFileStatusResponse()) {
            return resp;
        }
        OzoneManagerProtocolProtos.KeyInfo keyInfo = resp.getGetFileStatusResponse().getStatus().getKeyInfo();
        if (keyInfo.hasVolumeName() && keyInfo.hasBucketName() && !ctx.getBucketLayout(keyInfo.getVolumeName(), keyInfo.getBucketName()).isLegacy()) {
            resp = resp.toBuilder().setStatus(OzoneManagerProtocolProtos.Status.NOT_SUPPORTED_OPERATION).setMessage("Key is present in a bucket using bucket layout features which the client can not understand. Please upgrade the client before trying to read the key info for " + req.getGetFileStatusRequest().getKeyArgs().getVolumeName() + "/" + req.getGetFileStatusRequest().getKeyArgs().getBucketName() + "/" + req.getGetFileStatusRequest().getKeyArgs().getKeyName() + ".").clearGetFileStatusResponse().build();
        }
        return resp;
    }

    private OzoneManagerProtocolProtos.LookupFileResponse lookupFile(OzoneManagerProtocolProtos.LookupFileRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setSortDatanodesInPipeline(keyArgs.getSortDatanodes()).setLatestVersionLocation(keyArgs.getLatestVersionLocation()).build();
        return OzoneManagerProtocolProtos.LookupFileResponse.newBuilder().setKeyInfo(this.impl.lookupFile(omKeyArgs).getProtobuf(clientVersion)).build();
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.POST_PROCESS, requestType=OzoneManagerProtocolProtos.Type.LookupFile)
    public static OzoneManagerProtocolProtos.OMResponse disallowLookupFileWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, OzoneManagerProtocolProtos.OMResponse resp, ValidationContext ctx) throws ServiceException {
        if (!resp.hasLookupFileResponse()) {
            return resp;
        }
        if (resp.getLookupFileResponse().getKeyInfo().hasEcReplicationConfig()) {
            resp = resp.toBuilder().setStatus(OzoneManagerProtocolProtos.Status.NOT_SUPPORTED_OPERATION).setMessage("Key is a key with Erasure Coded replication, which the client can not understand. Please upgrade the client before trying to read the key info for " + req.getLookupFileRequest().getKeyArgs().getVolumeName() + "/" + req.getLookupFileRequest().getKeyArgs().getBucketName() + "/" + req.getLookupFileRequest().getKeyArgs().getKeyName() + ".").clearLookupFileResponse().build();
        }
        return resp;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.POST_PROCESS, requestType=OzoneManagerProtocolProtos.Type.LookupFile)
    public static OzoneManagerProtocolProtos.OMResponse disallowLookupFileWithBucketLayout(OzoneManagerProtocolProtos.OMRequest req, OzoneManagerProtocolProtos.OMResponse resp, ValidationContext ctx) throws ServiceException, IOException {
        if (!resp.hasLookupFileResponse()) {
            return resp;
        }
        OzoneManagerProtocolProtos.KeyInfo keyInfo = resp.getLookupFileResponse().getKeyInfo();
        if (keyInfo.hasVolumeName() && keyInfo.hasBucketName() && !ctx.getBucketLayout(keyInfo.getVolumeName(), keyInfo.getBucketName()).equals((Object)BucketLayout.LEGACY)) {
            resp = resp.toBuilder().setStatus(OzoneManagerProtocolProtos.Status.NOT_SUPPORTED_OPERATION).setMessage("File is present inside a bucket with bucket layout features, which the client can not understand. Please upgrade the client to a compatible version before trying to read the key info for " + req.getLookupFileRequest().getKeyArgs().getVolumeName() + "/" + req.getLookupFileRequest().getKeyArgs().getBucketName() + "/" + req.getLookupFileRequest().getKeyArgs().getKeyName() + ".").clearLookupFileResponse().build();
        }
        return resp;
    }

    private OzoneManagerProtocolProtos.ListStatusResponse listStatus(OzoneManagerProtocolProtos.ListStatusRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setLatestVersionLocation(keyArgs.getLatestVersionLocation()).setHeadOp(keyArgs.getHeadOp()).build();
        boolean allowPartialPrefixes = request.hasAllowPartialPrefix() && request.getAllowPartialPrefix();
        List<OzoneFileStatus> statuses = this.impl.listStatus(omKeyArgs, request.getRecursive(), request.getStartKey(), this.limitListSize(request.getNumEntries()), allowPartialPrefixes);
        OzoneManagerProtocolProtos.ListStatusResponse.Builder listStatusResponseBuilder = OzoneManagerProtocolProtos.ListStatusResponse.newBuilder();
        for (OzoneFileStatus status : statuses) {
            listStatusResponseBuilder.addStatuses(status.getProtobuf(clientVersion));
        }
        return listStatusResponseBuilder.build();
    }

    private OzoneManagerProtocolProtos.ListStatusLightResponse listStatusLight(OzoneManagerProtocolProtos.ListStatusRequest request, int clientVersion) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).setSortDatanodesInPipeline(false).setLatestVersionLocation(true).setHeadOp(keyArgs.getHeadOp()).build();
        boolean allowPartialPrefixes = request.hasAllowPartialPrefix() && request.getAllowPartialPrefix();
        List<OzoneFileStatusLight> statuses = this.impl.listStatusLight(omKeyArgs, request.getRecursive(), request.getStartKey(), this.limitListSize(request.getNumEntries()), allowPartialPrefixes);
        OzoneManagerProtocolProtos.ListStatusLightResponse.Builder listStatusLightResponseBuilder = OzoneManagerProtocolProtos.ListStatusLightResponse.newBuilder();
        for (OzoneFileStatusLight status : statuses) {
            listStatusLightResponseBuilder.addStatuses(status.getProtobuf());
        }
        return listStatusLightResponseBuilder.build();
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.POST_PROCESS, requestType=OzoneManagerProtocolProtos.Type.ListStatus)
    public static OzoneManagerProtocolProtos.OMResponse disallowListStatusResponseWithECReplicationConfig(OzoneManagerProtocolProtos.OMRequest req, OzoneManagerProtocolProtos.OMResponse resp, ValidationContext ctx) throws ServiceException {
        if (!resp.hasListStatusResponse()) {
            return resp;
        }
        List statuses = resp.getListStatusResponse().getStatusesList();
        for (OzoneManagerProtocolProtos.OzoneFileStatusProto status : statuses) {
            if (!status.getKeyInfo().hasEcReplicationConfig()) continue;
            resp = resp.toBuilder().setStatus(OzoneManagerProtocolProtos.Status.NOT_SUPPORTED_OPERATION).setMessage("The list of keys contains keys with Erasure Coded replication set, hence the client is not able to represent all the keys returned. Please upgrade the client to get the list of keys.").clearListStatusResponse().build();
        }
        return resp;
    }

    @RequestFeatureValidator(conditions={ValidationCondition.OLDER_CLIENT_REQUESTS}, processingPhase=RequestProcessingPhase.POST_PROCESS, requestType=OzoneManagerProtocolProtos.Type.ListStatus)
    public static OzoneManagerProtocolProtos.OMResponse disallowListStatusResponseWithBucketLayout(OzoneManagerProtocolProtos.OMRequest req, OzoneManagerProtocolProtos.OMResponse resp, ValidationContext ctx) throws ServiceException, IOException {
        if (!resp.hasListStatusResponse()) {
            return resp;
        }
        List statuses = resp.getListStatusResponse().getStatusesList();
        HashSet<ImmutablePair> volumeBucketSet = new HashSet<ImmutablePair>();
        for (OzoneManagerProtocolProtos.OzoneFileStatusProto ozoneFileStatusProto : statuses) {
            OzoneManagerProtocolProtos.KeyInfo keyInfo = ozoneFileStatusProto.getKeyInfo();
            if (!keyInfo.hasVolumeName() || !keyInfo.hasBucketName()) continue;
            volumeBucketSet.add(new ImmutablePair((Object)keyInfo.getVolumeName(), (Object)keyInfo.getBucketName()));
        }
        for (Pair pair : volumeBucketSet) {
            if (ctx.getBucketLayout((String)pair.getLeft(), (String)pair.getRight()).isLegacy()) continue;
            resp = resp.toBuilder().setStatus(OzoneManagerProtocolProtos.Status.NOT_SUPPORTED_OPERATION).setMessage("The list of keys is present in a bucket using bucket layout features, hence the client is not able to represent all the keys returned. Please upgrade the client to get the list of keys.").clearListStatusResponse().build();
            break;
        }
        return resp;
    }

    private OzoneManagerProtocolProtos.FinalizeUpgradeProgressResponse reportUpgradeProgress(OzoneManagerProtocolProtos.FinalizeUpgradeProgressRequest request) throws IOException {
        String upgradeClientId = request.getUpgradeClientId();
        boolean takeover = request.getTakeover();
        boolean readonly = request.getReadonly();
        UpgradeFinalization.StatusAndMessages progress = this.impl.queryUpgradeFinalizationProgress(upgradeClientId, takeover, readonly);
        HddsProtos.UpgradeFinalizationStatus.Status protoStatus = HddsProtos.UpgradeFinalizationStatus.Status.valueOf((String)progress.status().name());
        HddsProtos.UpgradeFinalizationStatus response = HddsProtos.UpgradeFinalizationStatus.newBuilder().setStatus(protoStatus).addAllMessages((Iterable)progress.msgs()).build();
        return OzoneManagerProtocolProtos.FinalizeUpgradeProgressResponse.newBuilder().setStatus(response).build();
    }

    private OzoneManagerProtocolProtos.PrepareStatusResponse getPrepareStatus() {
        OzoneManagerPrepareState.State prepareState = this.impl.getPrepareState().getState();
        return OzoneManagerProtocolProtos.PrepareStatusResponse.newBuilder().setStatus(prepareState.getStatus()).setCurrentTxnIndex(prepareState.getIndex()).build();
    }

    private OzoneManagerProtocolProtos.GetS3VolumeContextResponse getS3VolumeContext() throws IOException {
        return this.impl.getS3VolumeContext().getProtobuf();
    }

    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.FILESYSTEM_SNAPSHOT)
    private OzoneManagerProtocolProtos.SnapshotDiffResponse snapshotDiff(OzoneManagerProtocolProtos.SnapshotDiffRequest snapshotDiffRequest) throws IOException {
        OzoneManagerProtocolProtos.SnapshotDiffRequest snapshotDiffRequest2 = snapshotDiffRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)snapshotDiffRequest2);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        SnapshotDiffResponse response = this.impl.snapshotDiff(snapshotDiffRequest.getVolumeName(), snapshotDiffRequest.getBucketName(), snapshotDiffRequest.getFromSnapshot(), snapshotDiffRequest.getToSnapshot(), snapshotDiffRequest.getToken(), snapshotDiffRequest.getPageSize(), snapshotDiffRequest.getForceFullDiff(), snapshotDiffRequest.getDisableNativeDiff());
        OzoneManagerProtocolProtos.SnapshotDiffResponse.Builder builder = OzoneManagerProtocolProtos.SnapshotDiffResponse.newBuilder().setJobStatus(response.getJobStatus().toProtobuf()).setWaitTimeInMs(response.getWaitTimeInMs());
        if (StringUtils.isNotEmpty((CharSequence)response.getReason())) {
            builder.setReason(response.getReason());
        }
        if (response.getSnapshotDiffReport() != null) {
            builder.setSnapshotDiffReport(response.getSnapshotDiffReport().toProtobuf());
        }
        return builder.build();
    }

    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.FILESYSTEM_SNAPSHOT)
    private OzoneManagerProtocolProtos.CancelSnapshotDiffResponse cancelSnapshotDiff(OzoneManagerProtocolProtos.CancelSnapshotDiffRequest cancelSnapshotDiffRequest) throws IOException {
        OzoneManagerProtocolProtos.CancelSnapshotDiffRequest cancelSnapshotDiffRequest2 = cancelSnapshotDiffRequest;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)cancelSnapshotDiffRequest2);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        CancelSnapshotDiffResponse response = this.impl.cancelSnapshotDiff(cancelSnapshotDiffRequest.getVolumeName(), cancelSnapshotDiffRequest.getBucketName(), cancelSnapshotDiffRequest.getFromSnapshot(), cancelSnapshotDiffRequest.getToSnapshot());
        OzoneManagerProtocolProtos.CancelSnapshotDiffResponse.Builder builder = OzoneManagerProtocolProtos.CancelSnapshotDiffResponse.newBuilder();
        if (StringUtils.isNotEmpty((CharSequence)response.getMessage())) {
            builder.setReason(response.getMessage());
        }
        return builder.build();
    }

    private OzoneManagerProtocolProtos.ListSnapshotDiffJobResponse listSnapshotDiffJobs(OzoneManagerProtocolProtos.ListSnapshotDiffJobRequest listSnapshotDiffJobRequest) throws IOException {
        List<SnapshotDiffJob> snapshotDiffJobs = this.impl.listSnapshotDiffJobs(listSnapshotDiffJobRequest.getVolumeName(), listSnapshotDiffJobRequest.getBucketName(), listSnapshotDiffJobRequest.getJobStatus(), listSnapshotDiffJobRequest.getListAll());
        OzoneManagerProtocolProtos.ListSnapshotDiffJobResponse.Builder builder = OzoneManagerProtocolProtos.ListSnapshotDiffJobResponse.newBuilder();
        for (SnapshotDiffJob diffJob : snapshotDiffJobs) {
            builder.addSnapshotDiffJob(diffJob.toProtoBuf());
        }
        return builder.build();
    }

    private OzoneManagerProtocolProtos.PrintCompactionLogDagResponse printCompactionLogDag(OzoneManagerProtocolProtos.PrintCompactionLogDagRequest printCompactionLogDagRequest) throws IOException {
        String message = this.impl.printCompactionLogDag(printCompactionLogDagRequest.getFileNamePrefix(), printCompactionLogDagRequest.getGraphType());
        return OzoneManagerProtocolProtos.PrintCompactionLogDagResponse.newBuilder().setMessage(message).build();
    }

    public OzoneManager getOzoneManager() {
        return this.impl;
    }

    private OzoneManagerProtocolProtos.EchoRPCResponse echoRPC(OzoneManagerProtocolProtos.EchoRPCRequest req) {
        OzoneManagerProtocolProtos.EchoRPCResponse.Builder builder = OzoneManagerProtocolProtos.EchoRPCResponse.newBuilder();
        ByteString payloadBytes = PayloadUtils.generatePayloadProto2((int)req.getPayloadSizeResp());
        builder.setPayload(payloadBytes);
        return builder.build();
    }

    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.FILESYSTEM_SNAPSHOT)
    private OzoneManagerProtocolProtos.SnapshotInfoResponse getSnapshotInfo(OzoneManagerProtocolProtos.SnapshotInfoRequest request) throws IOException {
        OzoneManagerProtocolProtos.SnapshotInfoRequest snapshotInfoRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)snapshotInfoRequest);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        SnapshotInfo snapshotInfo = this.impl.getSnapshotInfo(request.getVolumeName(), request.getBucketName(), request.getSnapshotName());
        return OzoneManagerProtocolProtos.SnapshotInfoResponse.newBuilder().setSnapshotInfo(snapshotInfo.getProtobuf()).build();
    }

    @DisallowedUntilLayoutVersion(value=OMLayoutFeature.FILESYSTEM_SNAPSHOT)
    private OzoneManagerProtocolProtos.ListSnapshotResponse getSnapshots(OzoneManagerProtocolProtos.ListSnapshotRequest request) throws IOException {
        OzoneManagerProtocolProtos.ListSnapshotRequest listSnapshotRequest = request;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)listSnapshotRequest);
        OMLayoutFeatureAspect.aspectOf().checkLayoutFeature(joinPoint);
        ListSnapshotResponse implResponse = this.impl.listSnapshot(request.getVolumeName(), request.getBucketName(), request.getPrefix(), request.getPrevSnapshot(), this.limitListSizeInt(request.getMaxListResult()));
        List snapshotInfoList = implResponse.getSnapshotInfos().stream().map(SnapshotInfo::getProtobuf).collect(Collectors.toList());
        OzoneManagerProtocolProtos.ListSnapshotResponse.Builder builder = OzoneManagerProtocolProtos.ListSnapshotResponse.newBuilder().addAllSnapshotInfo(snapshotInfoList);
        if (StringUtils.isNotEmpty((CharSequence)implResponse.getLastSnapshot())) {
            builder.setLastSnapshot(implResponse.getLastSnapshot());
        }
        return builder.build();
    }

    private HddsProtos.TransferLeadershipResponseProto transferLeadership(HddsProtos.TransferLeadershipRequestProto req) throws IOException {
        String newLeaderId = req.getNewLeaderId();
        this.impl.transferLeadership(newLeaderId);
        return HddsProtos.TransferLeadershipResponseProto.getDefaultInstance();
    }

    private OzoneManagerProtocolProtos.SetSafeModeResponse setSafeMode(OzoneManagerProtocolProtos.SetSafeModeRequest req) throws IOException {
        OzoneManagerProtocolProtos.SafeMode safeMode = req.getSafeMode();
        boolean response = this.impl.setSafeMode(this.toSafeModeAction(safeMode), false);
        return OzoneManagerProtocolProtos.SetSafeModeResponse.newBuilder().setResponse(response).build();
    }

    private OzoneManagerProtocolProtos.GetObjectTaggingResponse getObjectTagging(OzoneManagerProtocolProtos.GetObjectTaggingRequest request) throws IOException {
        OzoneManagerProtocolProtos.KeyArgs keyArgs = request.getKeyArgs();
        OmKeyArgs omKeyArgs = new OmKeyArgs.Builder().setVolumeName(keyArgs.getVolumeName()).setBucketName(keyArgs.getBucketName()).setKeyName(keyArgs.getKeyName()).build();
        OzoneManagerProtocolProtos.GetObjectTaggingResponse.Builder resp = OzoneManagerProtocolProtos.GetObjectTaggingResponse.newBuilder();
        Map<String, String> result = this.impl.getObjectTagging(omKeyArgs);
        resp.addAllTags((Iterable)KeyValueUtil.toProtobuf(result));
        return resp.build();
    }

    private SafeModeAction toSafeModeAction(OzoneManagerProtocolProtos.SafeMode safeMode) {
        switch (safeMode) {
            case ENTER: {
                return SafeModeAction.ENTER;
            }
            case LEAVE: {
                return SafeModeAction.LEAVE;
            }
            case FORCE_EXIT: {
                return SafeModeAction.FORCE_EXIT;
            }
            case GET: {
                return SafeModeAction.GET;
            }
        }
        throw new IllegalArgumentException("Unexpected safe mode action " + safeMode);
    }

    private OzoneManagerProtocolProtos.GetQuotaRepairStatusResponse getQuotaRepairStatus(OzoneManagerProtocolProtos.GetQuotaRepairStatusRequest req) throws IOException {
        return OzoneManagerProtocolProtos.GetQuotaRepairStatusResponse.newBuilder().setStatus(this.impl.getQuotaRepairStatus()).build();
    }

    private OzoneManagerProtocolProtos.StartQuotaRepairResponse startQuotaRepair(OzoneManagerProtocolProtos.StartQuotaRepairRequest req) throws IOException {
        this.impl.startQuotaRepair(req.getBucketsList());
        return OzoneManagerProtocolProtos.StartQuotaRepairResponse.newBuilder().build();
    }

    private int limitListSizeInt(int requestedSize) {
        return Math.toIntExact(this.limitListSize(requestedSize));
    }

    private long limitListSize(long requestedSize) {
        return Math.min(requestedSize, this.impl.getConfig().getMaxListSize());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OzoneManagerRequestHandler.java", OzoneManagerRequestHandler.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "tenantGetUserInfo", "org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$TenantGetUserInfoRequest", "request", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$TenantGetUserInfoResponse"), 546);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "tenantListUsers", "org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$TenantListUserRequest", "request", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$TenantListUserResponse"), 563);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "listTenant", "org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$ListTenantRequest", "request", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$ListTenantResponse"), 577);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "listOpenFiles", "org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$ListOpenFilesRequest:int", "req:clientVersion", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$ListOpenFilesResponse"), 918);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "snapshotDiff", "org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$SnapshotDiffRequest", "snapshotDiffRequest", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$SnapshotDiffResponse"), 1389);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "cancelSnapshotDiff", "org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$CancelSnapshotDiffRequest", "cancelSnapshotDiffRequest", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$CancelSnapshotDiffResponse"), 1418);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSnapshotInfo", "org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$SnapshotInfoRequest", "request", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$SnapshotInfoResponse"), 1478);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getSnapshots", "org.apache.hadoop.ozone.protocolPB.OzoneManagerRequestHandler", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$ListSnapshotRequest", "request", "java.io.IOException", "org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos$ListSnapshotResponse"), 1489);
    }
}

