/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.security.acl;

import java.util.Objects;
import org.apache.hadoop.ozone.OFSPath;
import org.apache.hadoop.ozone.om.exceptions.OMException;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.IOzoneObj;
import org.apache.hadoop.ozone.security.acl.OzoneNativeAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObjInfo;
import org.apache.hadoop.ozone.security.acl.RequestContext;

public class SharedTmpDirAuthorizer
implements IAccessAuthorizer {
    private final OzoneNativeAuthorizer ozoneNativeAuthorizer;
    private final IAccessAuthorizer authorizer;

    public SharedTmpDirAuthorizer(OzoneNativeAuthorizer ozoneNativeAuthorizer, IAccessAuthorizer authorizer) {
        this.ozoneNativeAuthorizer = ozoneNativeAuthorizer;
        this.authorizer = authorizer;
    }

    public boolean checkAccess(IOzoneObj ozObject, RequestContext context) throws OMException {
        OzoneObjInfo objInfo;
        Objects.requireNonNull(ozObject);
        Objects.requireNonNull(context);
        if (ozObject instanceof OzoneObjInfo && OFSPath.isSharedTmpBucket((OzoneObjInfo)(objInfo = (OzoneObjInfo)ozObject))) {
            return this.ozoneNativeAuthorizer.checkAccess(ozObject, context);
        }
        return this.authorizer.checkAccess(ozObject, context);
    }
}

