/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.transport.server.ratis;

import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.util.Time;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.util.Preconditions;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class DispatcherContext {
    private static final DispatcherContext HANDLE_READ_CHUNK = DispatcherContext.newBuilder(Op.HANDLE_READ_CHUNK).build();
    private static final DispatcherContext HANDLE_WRITE_CHUNK = DispatcherContext.newBuilder(Op.HANDLE_WRITE_CHUNK).build();
    private static final DispatcherContext HANDLE_GET_SMALL_FILE = DispatcherContext.newBuilder(Op.HANDLE_GET_SMALL_FILE).build();
    private static final DispatcherContext HANDLE_PUT_SMALL_FILE = DispatcherContext.newBuilder(Op.HANDLE_PUT_SMALL_FILE).build();
    private final Op op;
    private final WriteChunkStage stage;
    private final long term;
    private final long logIndex;
    private final Map<Long, Long> container2BCSIDMap;
    private final boolean releaseSupported;
    private volatile Runnable releaseMethod;
    private final long startTime = Time.monotonicNowNanos();

    public static DispatcherContext getHandleReadChunk() {
        return HANDLE_READ_CHUNK;
    }

    public static DispatcherContext getHandleWriteChunk() {
        return HANDLE_WRITE_CHUNK;
    }

    public static DispatcherContext getHandleGetSmallFile() {
        return HANDLE_GET_SMALL_FILE;
    }

    public static DispatcherContext getHandlePutSmallFile() {
        return HANDLE_PUT_SMALL_FILE;
    }

    public static Op op(DispatcherContext context) {
        return context == null ? Op.NULL : context.getOp();
    }

    private DispatcherContext(Builder b) {
        this.op = Objects.requireNonNull(b.op, "op == null");
        this.term = b.term;
        this.logIndex = b.logIndex;
        this.stage = b.stage;
        this.container2BCSIDMap = b.container2BCSIDMap;
        this.releaseSupported = b.releaseSupported;
    }

    private Op getOp() {
        return this.op;
    }

    public long getLogIndex() {
        return this.logIndex;
    }

    public long getTerm() {
        return this.term;
    }

    public WriteChunkStage getStage() {
        return this.stage;
    }

    public Map<Long, Long> getContainer2BCSIDMap() {
        return this.container2BCSIDMap;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public boolean isReleaseSupported() {
        return this.releaseSupported;
    }

    public void setReleaseMethod(Runnable releaseMethod) {
        Preconditions.assertTrue((boolean)this.releaseSupported, (Object)"Unsupported release method");
        this.releaseMethod = releaseMethod;
    }

    public void release() {
        if (this.releaseMethod != null) {
            this.releaseMethod.run();
        }
    }

    public String toString() {
        return (Object)((Object)this.op) + "-" + (Object)((Object)this.stage) + TermIndex.valueOf((long)this.term, (long)this.logIndex);
    }

    public static Builder newBuilder(Op op) {
        return new Builder(Objects.requireNonNull(op, "op == null"));
    }

    public static final class Builder {
        private final Op op;
        private WriteChunkStage stage = WriteChunkStage.COMBINED;
        private long term;
        private long logIndex;
        private Map<Long, Long> container2BCSIDMap;
        private boolean releaseSupported;

        private Builder(Op op) {
            this.op = op;
        }

        public Builder setStage(WriteChunkStage writeChunkStage) {
            this.stage = writeChunkStage;
            return this;
        }

        public Builder setTerm(long currentTerm) {
            this.term = currentTerm;
            return this;
        }

        public Builder setLogIndex(long index) {
            this.logIndex = index;
            return this;
        }

        public Builder setContainer2BCSIDMap(Map<Long, Long> map) {
            this.container2BCSIDMap = map;
            return this;
        }

        public Builder setReleaseSupported(boolean releaseSupported) {
            this.releaseSupported = releaseSupported;
            return this;
        }

        public DispatcherContext build() {
            return new DispatcherContext(this);
        }
    }

    public static enum Op {
        NULL,
        HANDLE_READ_CHUNK,
        HANDLE_WRITE_CHUNK,
        HANDLE_GET_SMALL_FILE,
        HANDLE_PUT_SMALL_FILE,
        READ_STATE_MACHINE_DATA,
        WRITE_STATE_MACHINE_DATA,
        APPLY_TRANSACTION,
        STREAM_INIT,
        STREAM_LINK;


        public boolean readFromTmpFile() {
            return this == READ_STATE_MACHINE_DATA;
        }

        public boolean validateToken() {
            switch (this) {
                case APPLY_TRANSACTION: 
                case WRITE_STATE_MACHINE_DATA: 
                case READ_STATE_MACHINE_DATA: 
                case STREAM_LINK: {
                    return false;
                }
            }
            return true;
        }
    }

    public static enum WriteChunkStage {
        WRITE_DATA,
        COMMIT_DATA,
        COMBINED;


        public boolean isWrite() {
            return this != COMMIT_DATA;
        }

        public boolean isCommit() {
            return this != WRITE_DATA;
        }
    }
}

