/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.ozone.container.common.interfaces.VolumeChoosingPolicy;
import org.apache.hadoop.ozone.container.common.volume.AvailableSpaceFilter;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeChoosingUtil;
import org.apache.hadoop.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinVolumeChoosingPolicy
implements VolumeChoosingPolicy {
    public static final Logger LOG = LoggerFactory.getLogger(RoundRobinVolumeChoosingPolicy.class);
    private AtomicInteger nextVolumeIndex = new AtomicInteger(0);

    @Override
    public HddsVolume chooseVolume(List<HddsVolume> volumes, long maxContainerSize) throws IOException {
        int currentVolumeIndex;
        if (volumes.isEmpty()) {
            throw new DiskChecker.DiskOutOfSpaceException("No more available volumes");
        }
        AvailableSpaceFilter filter = new AvailableSpaceFilter(maxContainerSize);
        int nextIndex = this.nextVolumeIndex.get();
        int startVolumeIndex = currentVolumeIndex = nextIndex < volumes.size() ? nextIndex : 0;
        while (true) {
            HddsVolume volume = volumes.get(currentVolumeIndex);
            boolean hasEnoughSpace = filter.test(volume);
            currentVolumeIndex = (currentVolumeIndex + 1) % volumes.size();
            if (hasEnoughSpace) {
                VolumeChoosingUtil.logIfSomeVolumesOutOfSpace(filter, LOG);
                this.nextVolumeIndex.compareAndSet(nextIndex, currentVolumeIndex);
                return volume;
            }
            if (currentVolumeIndex != startVolumeIndex) continue;
            VolumeChoosingUtil.throwDiskOutOfSpace(filter, LOG);
        }
    }
}

