/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.ec.reconstruction;

import java.util.Objects;
import org.apache.hadoop.ozone.container.ec.reconstruction.ECReconstructionCommandInfo;
import org.apache.hadoop.ozone.container.ec.reconstruction.ECReconstructionCoordinator;
import org.apache.hadoop.ozone.container.replication.AbstractReplicationTask;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ECReconstructionCoordinatorTask
extends AbstractReplicationTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ECReconstructionCoordinatorTask.class);
    private final ECReconstructionCoordinator reconstructionCoordinator;
    private final ECReconstructionCommandInfo reconstructionCommandInfo;
    private final String debugString;

    public ECReconstructionCoordinatorTask(ECReconstructionCoordinator coordinator, ECReconstructionCommandInfo reconstructionCommandInfo) {
        super(reconstructionCommandInfo.getContainerID(), reconstructionCommandInfo.getDeadline(), reconstructionCommandInfo.getTerm());
        this.reconstructionCoordinator = coordinator;
        this.reconstructionCommandInfo = reconstructionCommandInfo;
        this.debugString = reconstructionCommandInfo.toString();
    }

    @Override
    public String getMetricName() {
        return "ECReconstructions";
    }

    @Override
    public String getMetricDescriptionSegment() {
        return "EC reconstructions";
    }

    @Override
    public void runTask() {
        long start = Time.monotonicNow();
        LOG.info("{}", (Object)this);
        try {
            this.reconstructionCoordinator.reconstructECContainerGroup(this.reconstructionCommandInfo.getContainerID(), this.reconstructionCommandInfo.getEcReplicationConfig(), this.reconstructionCommandInfo.getSourceNodeMap(), this.reconstructionCommandInfo.getTargetNodeMap());
            long elapsed = Time.monotonicNow() - start;
            this.setStatus(AbstractReplicationTask.Status.DONE);
            LOG.info("{} in {} ms", (Object)this, (Object)elapsed);
        }
        catch (Exception e) {
            long elapsed = Time.monotonicNow() - start;
            this.setStatus(AbstractReplicationTask.Status.FAILED);
            LOG.warn("{} after {} ms", new Object[]{this, elapsed, e});
        }
    }

    @Override
    protected Object getCommandForDebug() {
        return this.debugString;
    }

    @Override
    public void run() {
        this.runTask();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ECReconstructionCoordinatorTask that = (ECReconstructionCoordinatorTask)o;
        return this.getContainerId() == that.getContainerId();
    }

    public int hashCode() {
        return Objects.hash(this.getContainerId());
    }
}

